@extends('layouts.master')

@section('title', 'Cashbooks - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .table-container {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-top: 30px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .table-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        background: white;
        border-radius: 6px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .table th {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px;
        text-align: left;
        font-weight: 600;
        border: none;
    }

    .table td {
        padding: 12px;
        border-bottom: 1px solid #e5e7eb;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background-color: #f8fafc;
    }

    .table tbody tr:last-child td {
        border-bottom: none;
    }

    .btn-action {
        padding: 6px 12px;
        border-radius: 4px;
        font-size: 0.875rem;
        font-weight: 600;
        cursor: pointer;
        border: none;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 0.25rem;
    }

    .btn-edit {
        background-color: #3b82f6;
        color: white;
    }

    .btn-edit:hover {
        background-color: #2563eb;
        transform: translateY(-1px);
    }

    .btn-delete {
        background-color: #ef4444;
        color: white;
    }

    .btn-delete:hover {
        background-color: #dc2626;
        transform: translateY(-1px);
    }

    .badge {
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .badge-success {
        background-color: #d1fae5;
        color: #065f46;
    }

    .badge-danger {
        background-color: #fee2e2;
        color: #991b1b;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }

    .refresh-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(107, 114, 128, 0.3);
    }

    .refresh-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(107, 114, 128, 0.4);
    }

    .refresh-btn:active {
        transform: translateY(0);
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        .form-row {
            grid-template-columns: 1fr;
        }

        h1 {
            font-size: 2rem;
        }
    }
</style>

<div class="container">
    <h1>Add Cashbook</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid #a7f3d0;">
            {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div style="background-color: #fee2e2; color: #991b1b; padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid #fecaca;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form id="cashbookForm" action="{{ route('cashbook.entry.store') }}" method="POST" novalidate>
        @csrf

        <!-- Basic Information -->
        <div class="form-section">
            <h2 class="section-title">Basic Information</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="code" class="required">Code</label>
                    <input type="text" id="code" name="code" required>
                </div>
                <div class="form-group">
                    <label for="name" class="required">Name</label>
                    <input type="text" id="name" name="name" required>
                </div>
                <div class="form-group">
                    <label for="cashbook_type">Cashbook Type</label>
                    <select id="cashbook_type" name="cashbook_type">
                        <option value="">Select Type</option>
                        <option value="bank">Office Cash</option>
                        <option value="cash">Client Trust</option>
                        <option value="petty_cash">Petty Cash</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Account and Currency -->
        <div class="form-section">
            <h2 class="section-title">Account and Currency</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="currency_id">Currency ID</label>
                    <select id="currency_id" name="currency_id">
                        <option value="">Select Currency</option>
                        @foreach($currencies ?? [] as $currency)
                            <option value="{{ $currency->id }}">{{ $currency->currency_code }} - {{ $currency->currency_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="is_trust">Is Trust Account</label>
                    <select id="is_trust" name="is_trust">
                        <option value="0">No</option>
                        <option value="1">Yes</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Opening Balance -->
        <div class="form-section">
            <h2 class="section-title">Opening Balance</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="opening_balance">Opening Balance</label>
                    <input type="number" id="opening_balance" name="opening_balance" step="0.01">
                </div>
                <div class="form-group">
                    <label for="opening_balance_date">Opening Balance Date</label>
                    <input type="date" id="opening_balance_date" name="opening_balance_date">
                </div>
            </div>
        </div>

        <!-- Bank Details -->
        <div class="form-section">
            <h2 class="section-title">Bank Details</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="bank_name">Bank Name</label>
                    <input type="text" id="bank_name" name="bank_name">
                </div>
                <div class="form-group">
                    <label for="branch_name">Branch Name</label>
                    <input type="text" id="branch_name" name="branch_name">
                </div>
                <div class="form-group">
                    <label for="account_number">Account Number</label>
                    <input type="text" id="account_number" name="account_number">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="swift_code">SWIFT Code</label>
                    <input type="text" id="swift_code" name="swift_code">
                </div>
                <div class="form-group">
                    <label for="is_reconcilable">Is Reconcilable</label>
                    <select id="is_reconcilable" name="is_reconcilable">
                        <option value="0">No</option>
                        <option value="1">Yes</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="is_active">Is Active</label>
                    <select id="is_active" name="is_active">
                        <option value="1">Yes</option>
                        <option value="0">No</option>
                    </select>
                </div>
            </div>
        </div>

        <div style="display: flex; justify-content: center; gap: 20px; margin-top: 30px;">
            <button type="submit" class="submit-btn">Save Cashbook</button>
            <button type="button" class="refresh-btn" onclick="document.getElementById('cashbookForm').reset();">Refresh</button>
            <button type="button" class="refresh-btn" onclick="window.location.href='{{ route('modules.edit.chart-of-accounts') }}'">Back</button>
        </div>
    </form>

    <!-- Cashbooks Table -->
    <div class="table-container">
        <h2 class="table-title">📋 Existing Cashbooks</h2>

        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Type</th>
                        <th>Currency</th>
                        <th>Opening Balance</th>
                        <th>Trust Account</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="cashbooksTable">
                    @forelse($cashbooks ?? [] as $cashbook)
                        <tr data-id="{{ $cashbook->id }}">
                            <td>{{ $cashbook->code }}</td>
                            <td>{{ $cashbook->name }}</td>
                            <td>{{ ucfirst(str_replace('_', ' ', $cashbook->cashbook_type ?? 'N/A')) }}</td>
                            <td>{{ optional($cashbook->currency)->currency_code ?? 'N/A' }}</td>
                            <td>{{ number_format($cashbook->opening_balance ?? 0, 2) }}</td>
                            <td>
                                <span class="badge {{ $cashbook->is_trust ? 'badge-success' : 'badge-danger' }}">
                                    {{ $cashbook->is_trust ? 'Yes' : 'No' }}
                                </span>
                            </td>
                            <td>
                                <span class="badge {{ $cashbook->is_active ? 'badge-success' : 'badge-danger' }}">
                                    {{ $cashbook->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <button class="btn-action btn-edit" onclick="editCashbook({{ $cashbook->id }})">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                    </svg>
                                    Edit
                                </button>
                                <button class="btn-action btn-delete" onclick="deleteCashbook({{ $cashbook->id }})">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                    Delete
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                No cashbooks found. Create your first cashbook using the form above.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Confirm Deletion</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this cashbook? This action cannot be undone.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Auto-generate cashbook code on page load
    function generateCashbookCode() {
        const prefix = 'csh';
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';

        // Generate 5 random uppercase alphanumeric characters
        let randomChars = '';
        for (let i = 0; i < 5; i++) {
            randomChars += chars.charAt(Math.floor(Math.random() * chars.length));
        }

        // Generate 3 random digits
        let randomDigits = '';
        for (let i = 0; i < 3; i++) {
            randomDigits += Math.floor(Math.random() * 10);
        }

        return prefix + randomChars + randomDigits;
    }

    document.addEventListener('DOMContentLoaded', function() {
        const codeInput = document.getElementById('code');

        // Only generate and set code if the field is empty (not user-edited)
        if (codeInput && !codeInput.value.trim()) {
            codeInput.value = generateCashbookCode();
        }
    });

    function editCashbook(id) {
        // This would typically make an AJAX call to get the cashbook data
        // and populate the form for editing
        alert('Edit functionality would be implemented here for cashbook ID: ' + id);
    }

    function deleteCashbook(id) {
        const deleteForm = document.getElementById('deleteForm');
        deleteForm.action = `{{ route('cashbook.destroy', ':id') }}`.replace(':id', id);
        const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
        modal.show();
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection
