@extends('layouts.master')

@section('title', 'Client Categories - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }

    .table-container {
        overflow-x: auto;
        border-radius: 8px;
        border: 1px solid #e2e8f0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        background: white;
    }

    th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
        color: #2d3748;
        border-right: 1px solid #e2e8f0;
        background: #f8fafc;
    }

    th:last-child {
        border-right: none;
    }

    td {
        padding: 15px;
        border-right: 1px solid #e2e8f0;
        border-bottom: 1px solid #e2e8f0;
    }

    td:last-child {
        border-right: none;
    }

    tr:nth-child(even) {
        background: #f8fafc;
    }

    .action-btn {
        background: #3b82f6;
        color: white;
        text-decoration: none;
        padding: 6px 12px;
        border-radius: 4px;
        font-size: 0.875rem;
        margin-right: 5px;
        display: inline-block;
    }

    .delete-btn {
        background: #e53e3e;
        color: white;
        border: none;
        padding: 6px 12px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 0.875rem;
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        .form-row {
            grid-template-columns: 1fr;
        }

        h1 {
            font-size: 2rem;
        }
    }
</style>

<div class="container">
    <h1>Client Categories</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid #a7f3d0;">
            {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div style="background-color: #fee2e2; color: #991b1b; padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid #fecaca;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ isset($category) ? route('client-categories.update', $category->category_id) : route('client-categories.store') }}" method="POST" class="form-section">
        @csrf
        @if(isset($category))
            @method('PUT')
        @endif
        <h2 class="section-title">{{ isset($category) ? 'Edit Category' : 'Add Category' }}</h2>
        <div class="form-row">
            <div class="form-group">
                <label for="category_code">Category Code</label>
                <input type="text" id="category_code" name="category_code" value="{{ old('category_code', isset($category) ? $category->category_code : '') }}" placeholder="e.g., WHITE COLLAR" required>
            </div>
            <div class="form-group">
                <label for="category_description">Category Description</label>
                <input type="text" id="category_description" name="category_description" value="{{ old('category_description', isset($category) ? $category->category_description : '') }}" placeholder="e.g., Violent and Public Order Crimes" required>
            </div>
        </div>
    <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 20px;">
        <button type="submit" class="submit-btn">{{ isset($category) ? 'Update Category' : 'Save Category' }}</button>
        <div>
            @if(isset($category))
                <a href="{{ route('modules.edit.client-categories') }}" class="btn btn-secondary ms-2">Cancel</a>
            @endif
            <a href="{{ route('modules.edit.client') }}" class="btn btn-primary ms-2" style="float: right;">Back to Clients</a>
        </div>
    </div>
    </form>

    <div class="form-section">
        <h2 class="section-title">Categories List</h2>
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Category Code</th>
                        <th>Category Description</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categories as $category)
                        <tr>
                            <td>{{ $category->category_code }}</td>
                            <td>{{ $category->category_description }}</td>
                            <td>
                                <a href="{{ route('client-categories.edit', $category->category_id) }}" class="action-btn">Edit</a>
                                <form action="{{ route('client-categories.destroy', $category->category_id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="delete-btn" onclick="return confirm('Are you sure you want to delete this category?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

