@extends('layouts.master')

@section('title', 'Court Area Details - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .detail-group {
        margin-bottom: 25px;
        padding: 20px;
        background: white;
        border-radius: 8px;
        border-left: 4px solid #3b82f6;
    }

    .detail-label {
        font-weight: 600;
        color: #374151;
        font-size: 1.1rem;
        margin-bottom: 8px;
        display: block;
    }

    .detail-value {
        color: #4b5563;
        font-size: 1rem;
        padding: 8px 0;
        border-bottom: 1px solid #e5e7eb;
    }

    .status-badge {
        padding: 6px 16px;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: 600;
        text-transform: uppercase;
        display: inline-block;
    }

    .status-active {
        background-color: #d1fae5;
        color: #065f46;
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #991b1b;
    }

    .actions {
        display: flex;
        gap: 10px;
        justify-content: center;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-warning {
        background-color: #f59e0b;
        color: white;
    }

    .btn-warning:hover {
        background-color: #d97706;
        transform: translateY(-2px);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        h1 {
            font-size: 2rem;
        }

        .actions {
            flex-direction: column;
        }

        .btn {
            width: 100%;
            text-align: center;
        }
    }
</style>

<div class="container">
    <h1>Court Area Details</h1>

    <div class="detail-group">
        <span class="detail-label">Area Code</span>
        <span class="detail-value">{{ $courtArea->area_code }}</span>
    </div>

    <div class="detail-group">
        <span class="detail-label">Area Name</span>
        <span class="detail-value">{{ $courtArea->area_name }}</span>
    </div>

    <div class="detail-group">
        <span class="detail-label">City</span>
        <span class="detail-value">{{ $courtArea->city ?? 'N/A' }}</span>
    </div>

    <div class="detail-group">
        <span class="detail-label">Country</span>
        <span class="detail-value">{{ $courtArea->country ?? 'Zimbabwe' }}</span>
    </div>

    <div class="detail-group">
        <span class="detail-label">Specific Location</span>
        <span class="detail-value">{{ $courtArea->specific_location ?? 'N/A' }}</span>
    </div>

    <div class="actions">
        <a href="{{ route('modules.edit.court-areas.edit', $courtArea->area_code) }}" class="btn btn-warning">Edit</a>
        <a href="{{ route('modules.edit.court-areas') }}" class="btn btn-secondary">Back to List</a>
    </div>
</div>

@endsection

