@extends('layouts.master')

@section('title', 'Court Areas - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 40px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .options-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin-top: 30px;
    }

    .option-card {
        background: white;
        border-radius: 12px;
        padding: 30px;
        text-align: center;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .option-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        border-color: #3b82f6;
    }

    .option-icon {
        font-size: 3rem;
        color: #3b82f6;
        margin-bottom: 20px;
    }

    .option-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 15px;
    }

    .option-description {
        color: #6b7280;
        margin-bottom: 20px;
        line-height: 1.5;
    }

    .option-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .option-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(107, 114, 128, 0.3);
        margin-bottom: 20px;
    }

    .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(107, 114, 128, 0.4);
        color: white;
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        h1 {
            font-size: 2rem;
        }

        .options-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }

        .option-card {
            padding: 20px;
        }
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.court-details') }}" class="back-btn">← Back to Court Details</a>

    <h1>Court Areas Management</h1>

    <div class="options-grid">
        <!-- Add Court Areas Option -->
        <div class="option-card">
            <div class="option-icon">➕</div>
            <div class="option-title">Add Court Areas</div>
            <div class="option-description">Create new court area records with their details and jurisdictions.</div>
            <a href="{{ route('modules.edit.court-areas.create') }}" class="option-btn">Add New Court Area</a>
        </div>

        <!-- View Court Areas Option -->
        <div class="option-card">
            <div class="option-icon">👁️</div>
            <div class="option-title">View Court Areas</div>
            <div class="option-description">Browse and manage existing court area records.</div>
            <a href="{{ route('modules.edit.court-areas') }}" class="option-btn">View All Court Areas</a>
        </div>
    </div>
</div>

@endsection

