@extends('layouts.master')

@section('title', 'Departments - Prolex Law Firm')

@section('content')
<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.edit.chart-of-accounts') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back
        </a>
    </div>

    <div class="row">
        <div class="col-lg-5">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-building me-2"></i> Add Department</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('departments.store') }}" method="POST" id="deptForm">
                        @csrf
                        <input type="hidden" name="id" id="deptId" value="">
                        <div id="timeout">
                            @if(Session::has('success'))
                            <div class="alert alert-success">{{ Session('success') }}</div>
                            @endif
                            @if(Session::has('error'))
                            <div class="alert alert-danger">{{ Session('error') }}</div>
                            @endif
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><strong>Department Code:</strong></label>
                            <input class="form-control" type="text" name="department_code" id="department_code" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><strong>Department Name:</strong></label>
                            <input class="form-control" type="text" name="department_name" id="department_name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><strong>Description:</strong></label>
                            <textarea class="form-control" name="description" id="description" rows="3"></textarea>
                        </div>
                        <div class="d-flex justify-content-end mt-4">
                            <input type="submit" id="submitButton" class="btn btn-primary me-2" value="SUBMIT">
                            <input type="reset" class="btn btn-outline-secondary" onclick="resetForm()" value="REFRESH">
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-7 mt-4 mt-lg-0">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-list me-2"></i> Departments</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Code</th>
                                    <th>Department Name</th>
                                    <th>Description</th>
                                    <th style="width:100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($records as $record)
                                <tr>
                                    <td>{{ $record->department_code }}</td>
                                    <td>{{ $record->department_name }}</td>
                                    <td>{{ $record->description }}</td>
                                    <td class="text-center">
                                        <a href="#" class="btn btn-sm btn-primary" onclick="editDepartment(event, '{{ $record->department_id }}', '{{ $record->department_code }}', '{{ $record->department_name }}', '{{ $record->description }}')">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="{{ route('departments.delete', ['id' => $record->department_id]) }}" class="btn btn-sm btn-danger deleteBtn">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this department?
            </div>
            <div class="modal-footer">
                <button id="cancelDeleteBtn" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button id="confirmDeleteBtn" type="button" class="btn btn-danger">Delete</button>
            </div>
        </div>
    </div>
</div>

<script>
    function editDepartment(event, id, code, name, description) {
        event.preventDefault();
        document.getElementById('deptId').value = id;
        document.getElementById('department_code').value = code;
        document.getElementById('department_name').value = name;
        document.getElementById('description').value = description;
        document.querySelector('.card-header h5').innerHTML = '<i class="fas fa-building me-2"></i> Edit Department';
        document.getElementById('submitButton').value = 'UPDATE';
        document.getElementById('deptForm').action = '{{ route("departments.edit") }}';
    }

    function resetForm() {
        document.getElementById('deptId').value = '';
        document.getElementById('department_code').value = '';
        document.getElementById('department_name').value = '';
        document.getElementById('description').value = '';
        document.querySelector('.card-header h5').innerHTML = '<i class="fas fa-building me-2"></i> Add Department';
        document.getElementById('submitButton').value = 'SUBMIT';
        document.getElementById('deptForm').action = '{{ route("departments.store") }}';
        document.getElementById('timeout').innerHTML = '';
    }
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let deleteUrl = null;
        const modalEl = document.getElementById('deleteConfirmModal');
        const bsModal = new bootstrap.Modal(modalEl);

        // Show modal and store the delete URL
        document.querySelectorAll('.deleteBtn').forEach(btn => {
            btn.addEventListener('click', function (e) {
                e.preventDefault();
                deleteUrl = this.getAttribute('href');
                bsModal.show();
            });
        });

        // On confirm delete, redirect to delete URL
        document.getElementById('confirmDeleteBtn').addEventListener('click', function () {
            if (deleteUrl) {
                window.location.href = deleteUrl;
            }
        });

        // On cancel delete, just hide the modal — NO redirect
        document.getElementById('cancelDeleteBtn').addEventListener('click', function () {
            bsModal.hide(); // this dismisses the modal properly
        });
    });
</script>

@endsection

<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
</style>

