@extends('layouts.master')

@section('title', 'Edit Ageing Analysis')

@section('content')
<div class="container py-4">
    <h2 class="text-center mb-4 fw-bold">Edit Ageing Analysis</h2>

    <form method="POST" action="{{ route('ageing.update', $ageAnalysis->id) }}">
        @csrf
        @method('PUT')

        <div class="mb-4">
            <label for="age_code" class="form-label fw-semibold">Age Code:</label>
            <input type="text" id="age_code" name="age_code" class="form-control" value="{{ old('age_code', $ageAnalysis->age_code) }}" required>
        </div>

        <div class="mb-4">
            <label for="description" class="form-label fw-semibold">Description:</label>
            <input type="text" id="description" name="description" class="form-control" value="{{ old('description', $ageAnalysis->description) }}" required>
        </div>

        <!-- Add other fields as needed, similar to the add form -->

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-primary px-5">Update</button>
        </div>
    </form>
</div>
@endsection

