@extends('layouts.master')

@section('title', 'Edit Case Outcome - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #ffffff;
        padding: 20px 30px 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 25px;
        user-select: none;
    }

    .back-btn {
        background-color: #6b7280;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        font-size: 1em;
        font-weight: 600;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #374151;
    }

    .required::after {
        content: ' *';
        color: #ef4444;
    }

    input[type="text"], textarea {
        width: 100%;
        padding: 10px 15px;
        font-size: 1em;
        border: 2px solid #d1d5db;
        border-radius: 8px;
        transition: border-color 0.3s ease;
        box-sizing: border-box;
    }

    input[type="text"]:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 8px rgba(59, 130, 246, 0.5);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .form-help {
        margin-top: 5px;
        font-size: 0.9em;
        color: #6b7280;
    }

    .submit-btn {
        background-color: #f59e0b;
        color: white;
        padding: 12px 30px;
        border: none;
        border-radius: 5px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease;
        display: block;
        margin: 30px auto 0;
    }

    .submit-btn:hover {
        background-color: #d97706;
    }

    .submit-btn:disabled {
        background-color: #9ca3af;
        cursor: not-allowed;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-outcomes.list') }}" class="back-btn">← Back to Case Outcomes</a>
    <h1>Edit Case Outcome</h1>

    <form id="caseOutcomeForm" action="{{ route('case-outcomes.update', $caseOutcome->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="code" class="required">Outcome Code</label>
            <input type="text" id="code" name="code" value="{{ $caseOutcome->code }}" required placeholder="e.g., CO001, WON_CASE" maxlength="20">
            <div class="form-help">Enter a unique code for this case outcome (max 20 characters)</div>
        </div>

        <div class="form-group">
            <label for="name" class="required">Outcome Name</label>
            <input type="text" id="name" name="name" value="{{ $caseOutcome->name }}" required placeholder="e.g., Case Won, Case Lost" maxlength="50">
            <div class="form-help">Enter the display name for this case outcome (max 50 characters)</div>
        </div>

        <div class="form-group">
            <label for="description">Description</label>
            <textarea id="description" name="description" rows="4" placeholder="Provide a detailed description of this case outcome...">{{ $caseOutcome->description }}</textarea>
            <div class="form-help">Optional: Describe when and why this case outcome would be used</div>
        </div>

        <button type="submit" class="submit-btn">Update Case Outcome</button>
    </form>
</div>

<script>
    // Form validation
    const form = document.getElementById('caseOutcomeForm');
    const submitBtn = document.querySelector('.submit-btn');

    form.addEventListener('submit', function(e) {
        const code = document.getElementById('code').value.trim();
        const name = document.getElementById('name').value.trim();

        if (!code || !name) {
            e.preventDefault();
            alert('Please fill in all required fields.');
            return;
        }

        submitBtn.disabled = true;
        submitBtn.textContent = 'Updating...';
    });
</script>
@endsection
