@extends('layouts.master')

@section('title', 'Edit Case Priority - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, textarea, select {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, textarea:focus, select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .refresh-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        text-decoration: none;
        display: inline-block;
    }

    .submit-btn:hover, .refresh-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Edit Case Priority</h1>

    <form id="casePriorityForm" action="{{ route('case-priorities.update', $casePriority->priority_id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-section">
            <div class="section-title">Case Priority Information</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="priority_name" class="required">Priority Name</label>
                    <input type="text" id="priority_name" name="priority_name" value="{{ old('priority_name', $casePriority->priority_name) }}" required>
                </div>

                <div class="form-group">
                    <label for="severity_rank" class="required">Severity Rank</label>
                    <select id="severity_rank" name="severity_rank" required>
                        <option value="">Select Severity Rank</option>
                        <option value="1" {{ old('severity_rank', $casePriority->severity_rank) == '1' ? 'selected' : '' }}>1 - Lowest</option>
                        <option value="2" {{ old('severity_rank', $casePriority->severity_rank) == '2' ? 'selected' : '' }}>2</option>
                        <option value="3" {{ old('severity_rank', $casePriority->severity_rank) == '3' ? 'selected' : '' }}>3</option>
                        <option value="4" {{ old('severity_rank', $casePriority->severity_rank) == '4' ? 'selected' : '' }}>4</option>
                        <option value="5" {{ old('severity_rank', $casePriority->severity_rank) == '5' ? 'selected' : '' }}>5</option>
                        <option value="6" {{ old('severity_rank', $casePriority->severity_rank) == '6' ? 'selected' : '' }}>6 - Highest</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label for="description">Description</label>
                <textarea id="description" name="description" rows="4">{{ old('description', $casePriority->description) }}</textarea>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('modules.edit.case-priorities') }}" class="back-btn">Back</a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">Refresh</button>
                <button type="submit" class="submit-btn">Update</button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('casePriorityForm').reset();
    }

    document.getElementById('casePriorityForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = 'Updating...';
    });
</script>

@endsection
