@extends('layouts.master')

@section('title', 'Edit Cancelled Reason - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;` 
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .form-help {
        font-size: 0.85rem;
        color: #6b7280;
        margin-top: 5px;
        font-style: italic;
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: auto;
        margin: 0;
    }

    .checkbox-group label {
        margin-bottom: 0;
        cursor: pointer;
    }

    .current-info {
        background-color: #eff6ff;
        border: 1px solid #3b82f6;
        border-radius: 6px;
        padding: 15px;
        margin-bottom: 20px;
    }

    .current-info h3 {
        color: #1e40af;
        margin-bottom: 10px;
        font-size: 1.1rem;
    }

    .current-info p {
        margin: 5px 0;
        color: #4b5563;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-reasons.list') }}" class="back-btn">← Back to List</a>
    <h1>Edit Cancelled Reason</h1>

    <div class="current-info">
        <h3>Current Information</h3>
        <p><strong>Reason Code:</strong> {{ $caseReason->reason_code }}</p>
        <p><strong>Reason Name:</strong> {{ $caseReason->reason_name }}</p>

        <p><strong>Status:</strong> {{ $caseReason->status ? 'Active' : 'Inactive' }}</p>
    </div>

    <form id="caseReasonForm" action="{{ route('case-reasons.update', $caseReason->reason_code) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-section">
            <h2 class="section-title">Basic Information</h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="reason_code" class="required">Reason Code</label>
                    <input type="text" id="reason_code" name="reason_code" value="{{ $caseReason->reason_code }}" required placeholder="e.g., CR001, CLIENT_REQ">
                    <div class="form-help">Enter a unique code for this case reason</div>
                </div>
                <div class="form-group">
                    <label for="reason_name" class="required">Reason Name</label>
                    <input type="text" id="reason_name" name="reason_name" value="{{ $caseReason->reason_name }}" required placeholder="e.g., Client Request">
                    <div class="form-help">Enter the display name for this case reason</div>
                </div>
            </div>

            <div class="form-group">
                <label for="reason_description" class="required">Reason Description</label>
                <textarea id="reason_description" name="reason_description" rows="4" required placeholder="Provide a detailed description of this case reason...">{{ $caseReason->reason_description }}</textarea>
                <div class="form-help">Describe when and why this case reason would be used</div>
            </div>
        </div>

        <div class="form-section">
            <h2 class="section-title">Settings</h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="status" class="required">Status</label>
                    <select id="status" name="status" required>
                        <option value="">Select Status</option>
                        <option value="1" {{ $caseReason->status ? 'selected' : '' }}>Active</option>
                        <option value="0" {{ !$caseReason->status ? 'selected' : '' }}>Inactive</option>
                    </select>
                    <div class="form-help">Set whether this case reason is active or inactive</div>
                </div>
            </div>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <button type="submit" class="submit-btn">Update Cancelled Reason</button>
        </div>
    </form>
</div>

<script>
    // Form validation
    document.getElementById('caseReasonForm').addEventListener('submit', function(e) {
        const reasonCode = document.getElementById('reason_code').value.trim();
        const reasonName = document.getElementById('reason_name').value.trim();
        const reasonDescription = document.getElementById('reason_description').value.trim();

        if (!reasonCode || !reasonName || !reasonDescription) {
            e.preventDefault();
            alert('Please fill in all required fields.');
            return false;
        }

        // Validate reason code format (alphanumeric, underscores, hyphens only)
        const codePattern = /^[A-Z0-9_-]+$/;
        if (!codePattern.test(reasonCode)) {
            e.preventDefault();
            alert('Reason code can only contain uppercase letters, numbers, underscores, and hyphens.');
            return false;
        }
    });
</script>
@endsection

