@extends('layouts.master')

@section('title', 'Edit Case - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #374151;
    }

    .form-group input,
    .form-group select {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 8px;
        font-size: 1rem;
        transition: border-color 0.3s ease;
    }

    .form-group input:focus,
    .form-group select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .form-row {
        display: flex;
        gap: 20px;
    }

    .form-row .form-group {
        flex: 1;
    }

    .actions {
        margin-top: 30px;
        text-align: center;
    }

    .action-btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin: 0 10px;
        transition: all 0.3s ease;
    }

    .save-btn {
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
    }

    .save-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(16, 185, 129, 0.4);
    }

    .cancel-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
    }

    .cancel-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(107, 114, 128, 0.4);
    }

    .error-message {
        color: #ef4444;
        font-size: 0.9rem;
        margin-top: 5px;
    }
</style>

<div class="container">
    <h1>Edit Case</h1>

    <form action="{{ route('case.update', $case->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-row">
            <div class="form-group">
                <label for="case_id">Case ID</label>
                <input type="text" id="case_id" name="case_id" value="{{ $case->case_code }}" required>
                @error('case_id')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <label for="type">Case Type</label>
                <select id="type" name="type" required>
                    <option value="">Select Case Type</option>
                    @foreach($caseTypes as $caseType)
                        <option value="{{ $caseType->type_name }}" {{ $case->type_name == $caseType->type_name ? 'selected' : '' }}>
                            {{ $caseType->type_name }}
                        </option>
                    @endforeach
                </select>
                @error('type')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="form-group">
            <label for="client_name">Client Name</label>
            <input type="text" id="client_name" name="client_name" value="{{ $case->client ? $case->client->full_name : '' }}" required>
            @error('client_name')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="case_category_id">Case Category</label>
                <select id="case_category_id" name="case_category_id" required>
                    <option value="">Select Case Category</option>
                    @foreach($caseCategories as $category)
                    <option value="{{ $category->id }}" {{ $case->case_category_id == $category->id ? 'selected' : '' }}>
                        {{ $category->category_code }}
                    </option>
                    @endforeach
                </select>
                @error('case_category_id')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <label for="lawyer_id">Assigned Lawyer</label>
                <select id="lawyer_id" name="lawyer_id" required>
                    <option value="">Select Lawyer</option>
                    @foreach($lawyers as $lawyer)
                        <option value="{{ $lawyer->id }}" {{ $case->lawyer_id == $lawyer->id ? 'selected' : '' }}>
                            {{ $lawyer->full_name }}
                        </option>
                    @endforeach
                </select>
                @error('lawyer_id')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="case_status_id">Case Status</label>
                <select id="case_status_id" name="case_status_id" required>
                    <option value="">Select Case Status</option>
                    @foreach($caseStatuses as $status)
                        <option value="{{ $status->id }}" style="color: {{ $status->color_code }};" {{ $case->caseStatus && $case->caseStatus->id == $status->id ? 'selected' : '' }}>
                            {{ $status->status_code }} - {{ $status->status_name }}
                        </option>
                    @endforeach
                </select>
                @error('case_status_id')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <label for="case_outcome_id">Case Outcome</label>
                <select id="case_outcome_id" name="case_outcome_id">
                    <option value="">Select Case Outcome</option>
                    @foreach($caseOutcomes as $outcome)
                        <option value="{{ $outcome->id }}" {{ $case->case_outcome == $outcome->id ? 'selected' : '' }}>
                            {{ $outcome->code }} - {{ $outcome->name }}
                        </option>
                    @endforeach
                </select>
                @error('case_outcome_id')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="actions">
            <button type="submit" class="action-btn save-btn">Update Case</button>
            <a href="{{ route('modules.edit.cases') }}" class="action-btn cancel-btn">Cancel</a>
        </div>

        <div class="actions" style="margin-top: 20px; text-align: center;">
            <form action="{{ route('case.markWon', $case->id) }}" method="POST" style="display: inline;">
                @csrf
                <button type="submit" class="action-btn save-btn" style="background-color: #16a34a; margin-right: 10px;">Mark as Won</button>
            </form>
            <form action="{{ route('case.markLost', $case->id) }}" method="POST" style="display: inline;">
                @csrf
                <button type="submit" class="action-btn save-btn" style="background-color: #dc2626;">Mark as Lost</button>
            </form>
        </div>
    </form>
</div>

<script>
    // Add any client-side validation or enhancements here
    document.addEventListener('DOMContentLoaded', function() {
        // You can add form validation or other JavaScript here if needed
    });
</script>
@endsection

