@extends('layouts.master')

@section('title', 'Edit Judgement - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #374151;
    }

    input[type="text"],
    input[type="date"],
    select,
    textarea {
        width: 100%;
        padding: 12px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        box-sizing: border-box;
    }

    input[type="text"]:focus,
    input[type="date"]:focus,
    select:focus,
    textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .btn-container {
        display: flex;
        justify-content: space-between;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
    }

    .btn-danger {
        background-color: #ef4444;
        color: white;
    }

    .btn-danger:hover {
        background-color: #dc2626;
        transform: translateY(-2px);
    }

    .error-message {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 5px;
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        h1 {
            font-size: 2rem;
        }

        .btn-container {
            flex-direction: column;
            gap: 15px;
        }

        .btn {
            width: 100%;
            text-align: center;
        }
    }
</style>

<div class="container">
    <h1>Edit Judgement</h1>

    <form action="{{ route('modules.edit.judgements.update', $judgement->judgement_code) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="judgement_code">Judgement Code *</label>
            <input type="text" id="judgement_code" name="judgement_code" value="{{ old('judgement_code', $judgement->judgement_code) }}" required readonly>
            @error('judgement_code')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="title">Judgement Title *</label>
            <input type="text" id="title" name="title" value="{{ old('title', $judgement->title) }}" required>
            @error('title')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="description">Description</label>
            <textarea id="description" name="description">{{ old('description', $judgement->description) }}</textarea>
            @error('description')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="btn-container">
            <a href="{{ route('modules.edit.court-details') }}" class="btn btn-secondary">Back to Court Details</a>
            <a href="{{ route('modules.edit.judgements.show', $judgement->judgement_code) }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Update Judgement</button>
        </div>
    </form>

    <div class="btn-container" style="justify-content: center; margin-top: 20px;">
        <form action="{{ route('modules.edit.judgements.destroy', $judgement->judgement_code) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this judgement?')">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger">Delete Judgement</button>
        </form>
    </div>
</div>

@endsection

