@extends('layouts.master')

@section('title', 'Edit Lawyer - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Edit Lawyer</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #a7f3d0;">
            {{ session('success') }}
        </div>
    @endif

    <div style="margin-bottom: 20px;">
        <a href="{{ route('modules.edit.lawyer-management') }}" style="background: linear-gradient(135deg, #6b7280, #4b5563); color: white; padding: 12px 24px; border-radius: 8px; text-decoration: none; font-weight: 600; display: inline-block; transition: all 0.3s ease;">
            <i class="fas fa-arrow-left"></i> Back to Lawyer Management
        </a>
    </div>

    <form id="lawyerForm" action="{{ route('modules.edit.lawyer.update', $lawyer->lawyer_id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="form-section">
            <h2 class="section-title">Lawyer Information</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="lawyer_id" class="required">Lawyer ID</label>
                    <input type="text" id="lawyer_id" name="lawyer_id" value="{{ $lawyer->lawyer_id }}" required readonly>
                </div>
                <div class="form-group">
                    <label for="first_name" class="required">First Name</label>
                    <input type="text" id="first_name" name="first_name" value="{{ $lawyer->first_name }}" required>
                </div>
                <div class="form-group">
                    <label for="last_name" class="required">Last Name</label>
                    <input type="text" id="last_name" name="last_name" value="{{ $lawyer->last_name }}" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" value="{{ $lawyer->email }}">
                </div>
                <div class="form-group">
                    <label for="phone_primary">Primary Phone</label>
                    <input type="tel" id="phone_primary" name="phone_primary" value="{{ $lawyer->phone_primary }}">
                </div>
                <div class="form-group">
                    <label for="phone_secondary">Secondary Phone</label>
                    <input type="tel" id="phone_secondary" name="phone_secondary" value="{{ $lawyer->phone_secondary }}">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="lawyer_group">Lawyer Group</label>
                    <select id="lawyer_group" name="lawyer_group">
                        <option value="">Select Lawyer Group</option>
                        @foreach($lawyerGroups ?? \App\Models\LawyerGroup::all() as $group)
                            <option value="{{ $group->group_id }}" {{ $lawyer->lawyer_group == $group->group_id ? 'selected' : '' }}>{{ $group->group_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="bar_number">Certificate Number</label>
                    <input type="text" id="bar_number" name="bar_number" value="{{ $lawyer->bar_number }}">
                </div>
                <div class="form-group">
                    <label for="date_of_admission">Date of Admission</label>
                    <input type="date" id="date_of_admission" name="date_of_admission" value="{{ $lawyer->date_of_admission ? $lawyer->date_of_admission->format('Y-m-d') : '' }}">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="status">Status</label>
                    <select id="status" name="status">
                        <option value="Active" {{ $lawyer->status == 'Active' ? 'selected' : '' }}>Active</option>
                        <option value="Inactive" {{ $lawyer->status == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="Suspended" {{ $lawyer->status == 'Suspended' ? 'selected' : '' }}>Suspended</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="lawyer_type">Lawyer Type</label>
                    <select id="lawyer_type" name="lawyer_type">
                        <option value="">Select Lawyer Type</option>
                        @foreach($lawyerTypes as $type)
                            <option value="{{ $type->lawyer_type_name }}" data-group="{{ $type->group_id }}" {{ $lawyer->lawyer_type == $type->lawyer_type_name ? 'selected' : '' }}>{{ $type->lawyer_type_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="tariff">Tariff</label>
                    <select id="tariff" name="tariff">
                        <option value="">Select Tariff</option>
                        @foreach(\App\Models\Tariff::all() as $tariffOption)
                            <option value="{{ $tariffOption->lawyer_tier }}" {{ $lawyer->tariff == $tariffOption->lawyer_tier ? 'selected' : '' }}>{{ $tariffOption->lawyer_tier }} - {{ $tariffOption->service_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="tier">Tier</label>
                    <select id="tier" name="tier">
                        <option value="">Select Tier</option>
                        @foreach($lawyerTiers as $tier)
                            <option value="{{ $tier->id }}" {{ $lawyer->tier == $tier->id ? 'selected' : '' }}>{{ $tier->tier_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label for="notes">Notes</label>
                <textarea id="notes" name="notes">{{ $lawyer->notes }}</textarea>
            </div>
            <button type="submit" class="submit-btn">Update Lawyer</button>
        </div>
    </form>
</div>

<script>
    // Filter lawyer types based on selected lawyer group
    document.getElementById('lawyer_group').addEventListener('change', function() {
        const selectedGroupId = this.value;
        const lawyerTypeSelect = document.getElementById('lawyer_type');
        const options = lawyerTypeSelect.querySelectorAll('option');

        options.forEach(option => {
            if (option.value === '') {
                option.style.display = 'block'; // Always show the default option
            } else {
                const optionGroupId = option.getAttribute('data-group');
                if (optionGroupId === selectedGroupId) {
                    option.style.display = 'block';
                } else {
                    option.style.display = 'none';
                }
            }
        });

        // Reset lawyer type selection
        lawyerTypeSelect.value = '';
    });
</script>
@endsection
