@extends('layouts.master')

@section('title', 'Edit Supplier - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, textarea, select {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, textarea:focus, select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .refresh-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        text-decoration: none;
        display: inline-block;
    }

    .submit-btn:hover, .refresh-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Edit Supplier</h1>

    <form id="supplierForm" action="{{ route('suppliers.update', $supplier->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-section">
            <div class="section-title">Supplier Details</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="supplier_code" class="required">Supplier Code</label>
                    <input type="text" id="supplier_code" name="supplier_code" value="{{ old('supplier_code', $supplier->supplier_code) }}" required>
                </div>

                <div class="form-group">
                    <label for="full_name" class="required">Full Name</label>
                    <input type="text" id="full_name" name="full_name" value="{{ old('full_name', $supplier->full_name) }}" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="supplier_name" class="required">Supplier Name</label>
                    <input type="text" id="supplier_name" name="supplier_name" value="{{ old('supplier_name', $supplier->supplier_name) }}" required>
                </div>

                <div class="form-group">
                    <label for="date_of_registration" class="required">Date Of Registration</label>
                    <input type="date" id="date_of_registration" name="date_of_registration" value="{{ old('date_of_registration', $supplier->date_of_registration) }}" required>
                </div>
            </div>
        </div>

        <div class="form-section">
            <div class="section-title">Contact Details</div>

            <div class="form-group">
                <label for="address" class="required">Address</label>
                <textarea id="address" name="address" rows="4" required>{{ old('address', $supplier->address) }}</textarea>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="mobile" class="required">Mobile</label>
                    <input type="text" id="mobile" name="mobile" value="{{ old('mobile', $supplier->mobile) }}" required>
                </div>

                <div class="form-group">
                    <label for="email" class="required">Email</label>
                    <input type="email" id="email" name="email" value="{{ old('email', $supplier->email) }}" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="contact_person">Contact Person</label>
                    <input type="text" id="contact_person" name="contact_person" value="{{ old('contact_person', $supplier->contact_person) }}">
                </div>

                <div class="form-group">
                    <label for="contact_1">Contact 1</label>
                    <input type="text" id="contact_1" name="contact_1" value="{{ old('contact_1', $supplier->contact_1) }}">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="contact_2">Contact 2</label>
                    <input type="text" id="contact_2" name="contact_2" value="{{ old('contact_2', $supplier->contact_2) }}">
                </div>

                <div class="form-group">
                    <label for="currency_id" class="required">Select Currency</label>
                    <select id="currency_id" name="currency_id" required>
                        <option value="">Select Currency</option>
                        @foreach($currencies as $currency)
                            <option value="{{ $currency->id }}" {{ old('currency_id', $supplier->currency_id) == $currency->id ? 'selected' : '' }}>{{ $currency->name }} ({{ $currency->symbol }})</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-section">
            <div class="section-title">Additional Details</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="category_id">Category</label>
                    <select id="category_id" name="category_id">
                        <option value="">Select Category</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id', $supplier->category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="age_analysis_id">Age Analysis</label>
                    <select id="age_analysis_id" name="age_analysis_id">
                        <option value="">Select Age Analysis</option>
                        @foreach($ageAnalyses as $ageAnalysis)
                            <option value="{{ $ageAnalysis->id }}" {{ old('age_analysis_id', $supplier->age_analysis_id) == $ageAnalysis->id ? 'selected' : '' }}>{{ $ageAnalysis->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label for="area_id">Area</label>
                <select id="area_id" name="area_id">
                    <option value="">Select Area</option>
                    @foreach($departments as $department)
                        <option value="{{ $department->id }}" {{ old('area_id', $supplier->area_id) == $department->id ? 'selected' : '' }}>{{ $department->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('suppliers.index') }}" class="back-btn">Back</a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">Refresh</button>
                <button type="submit" class="submit-btn">Update</button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('supplierForm').reset();
    }

    document.getElementById('supplierForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = 'Updating...';
    });
</script>

@endsection

