@extends('layouts.master')

@section('title', 'Edit Tariff - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .refresh-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        text-decoration: none;
        display: inline-block;
    }

    .submit-btn:hover, .refresh-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Edit Tariff</h1>

    <form id="tariffForm" action="{{ route('tariffs.update', $tariff->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-section">
            <div class="section-title">Tariff Information</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="lawyer_id" class="required">Lawyer</label>
                    <select id="lawyer_id" name="lawyer_id" required>
                        <option value="">Select Lawyer</option>
                        @foreach($lawyers as $lawyer)
                            <option value="{{ $lawyer->lawyer_id }}" {{ old('lawyer_id', $tariff->lawyer_id) == $lawyer->lawyer_id ? 'selected' : '' }}>{{ $lawyer->full_name }} ({{ $lawyer->lawyer_id }})</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="lawyer_tier_id" class="required">Lawyer Tier</label>
                    <select id="lawyer_tier_id" name="lawyer_tier_id" required>
                        <option value="">Select Lawyer Tier</option>
                        @foreach($lawyerTiers as $tier)
                            <option value="{{ $tier->tier_id }}" {{ old('lawyer_tier_id', $tariff->lawyer_tier_id) == $tier->tier_id ? 'selected' : '' }}>{{ $tier->tier_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="lawyer_group_id" class="required">Lawyer Group</label>
                    <select id="lawyer_group_id" name="lawyer_group_id" required>
                        <option value="">Select Lawyer Group</option>
                        @foreach($lawyerGroups as $group)
                            <option value="{{ $group->group_id }}" {{ old('lawyer_group_id', $tariff->lawyer_group_id) == $group->group_id ? 'selected' : '' }}>{{ $group->group_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="lawyer_type_id" class="required">Lawyer Type</label>
                    <select id="lawyer_type_id" name="lawyer_type_id" required>
                        <option value="">Select Lawyer Type</option>
                        @foreach($lawyerTypes as $type)
                            <option value="{{ $type->type_id }}" data-group="{{ $type->group_id }}" {{ old('lawyer_type_id', $tariff->lawyer_type_id) == $type->type_id ? 'selected' : '' }}>{{ $type->lawyer_type_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="service_name" class="required">Service Name</label>
                    <input type="text" id="service_name" name="service_name" value="{{ old('service_name', $tariff->service_name) }}" required>
                </div>

                <div class="form-group">
                    <label for="billing_method" class="required">Billing Method</label>
                    <select id="billing_method" name="billing_method" required>
                        <option value="">Select Billing Method</option>
                        <option value="HOURLY" {{ old('billing_method', $tariff->billing_method) == 'HOURLY' ? 'selected' : '' }}>Hourly</option>
                        <option value="FIXED_FEE" {{ old('billing_method', $tariff->billing_method) == 'FIXED_FEE' ? 'selected' : '' }}>Fixed Fee</option>
                        <option value="PER_APPEARANCE" {{ old('billing_method', $tariff->billing_method) == 'PER_APPEARANCE' ? 'selected' : '' }}>Per Appearance</option>
                        <option value="PER_STAGE" {{ old('billing_method', $tariff->billing_method) == 'PER_STAGE' ? 'selected' : '' }}>Per Stage</option>
                        <option value="RETAINER_PLUS" {{ old('billing_method', $tariff->billing_method) == 'RETAINER_PLUS' ? 'selected' : '' }}>Retainer Plus</option>
                        <option value="CONTINGENCY" {{ old('billing_method', $tariff->billing_method) == 'CONTINGENCY' ? 'selected' : '' }}>Contingency</option>
                        <option value="SUBSCRIPTION" {{ old('billing_method', $tariff->billing_method) == 'SUBSCRIPTION' ? 'selected' : '' }}>Subscription</option>
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="rate_type" class="required">Rate Type</label>
                    <select id="rate_type" name="rate_type" required>
                        <option value="">Select Rate Type</option>
                        <option value="PER_HOUR" {{ old('rate_type', $tariff->rate_type) == 'PER_HOUR' ? 'selected' : '' }}>Per Hour</option>
                        <option value="PER_CASE" {{ old('rate_type', $tariff->rate_type) == 'PER_CASE' ? 'selected' : '' }}>Per Case</option>
                        <option value="PER_DOCUMENT" {{ old('rate_type', $tariff->rate_type) == 'PER_DOCUMENT' ? 'selected' : '' }}>Per Document</option>
                        <option value="PER_APPEARANCE" {{ old('rate_type', $tariff->rate_type) == 'PER_APPEARANCE' ? 'selected' : '' }}>Per Appearance</option>
                        <option value="PER_CONSULTATION" {{ old('rate_type', $tariff->rate_type) == 'PER_CONSULTATION' ? 'selected' : '' }}>Per Consultation</option>
                        <option value="PER_MONTH" {{ old('rate_type', $tariff->rate_type) == 'PER_MONTH' ? 'selected' : '' }}>Per Month</option>
                        <option value="PERCENTAGE" {{ old('rate_type', $tariff->rate_type) == 'PERCENTAGE' ? 'selected' : '' }}>Percentage</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="rate_amount" class="required">Rate Amount</label>
                    <input type="number" id="rate_amount" name="rate_amount" step="0.01" value="{{ old('rate_amount', $tariff->rate_amount) }}" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="currency" class="required">Currency</label>
                    <select id="currency" name="currency" required>
                        <option value="">Select Currency</option>
                        @foreach($currencies as $currency)
                            <option value="{{ $currency->currency_code }}" {{ old('currency', $tariff->currency) == $currency->currency_code ? 'selected' : '' }}>{{ $currency->currency_code }} - {{ $currency->currency_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="effective_from" class="required">Effective From</label>
                    <input type="date" id="effective_from" name="effective_from" value="{{ old('effective_from', $tariff->effective_from ? $tariff->effective_from->format('Y-m-d') : '') }}" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="minimum_fee">Minimum Fee</label>
                    <input type="number" id="minimum_fee" name="minimum_fee" step="0.01" value="{{ old('minimum_fee', $tariff->minimum_fee) }}">
                </div>

                <div class="form-group">
                    <label for="maximum_fee">Maximum Fee</label>
                    <input type="number" id="maximum_fee" name="maximum_fee" step="0.01" value="{{ old('maximum_fee', $tariff->maximum_fee) }}">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="billing_increment">Billing Increment (Minutes)</label>
                    <select id="billing_increment" name="billing_increment">
                        <option value="">Select Increment</option>
                        <option value="15" {{ old('billing_increment', $tariff->billing_increment) == 15 ? 'selected' : '' }}>15</option>
                        <option value="30" {{ old('billing_increment', $tariff->billing_increment) == 30 ? 'selected' : '' }}>30</option>
                        <option value="60" {{ old('billing_increment', $tariff->billing_increment) == 60 ? 'selected' : '' }}>60</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="court_level">Court Level</label>
                    <select id="court_level" name="court_level">
                        <option value="">Select Court Level</option>
                        <option value="MAGISTRATES" {{ old('court_level', $tariff->court_level) == 'MAGISTRATES' ? 'selected' : '' }}>Magistrates</option>
                        <option value="HIGH_COURT" {{ old('court_level', $tariff->court_level) == 'HIGH_COURT' ? 'selected' : '' }}>High Court</option>
                        <option value="SUPREME_COURT" {{ old('court_level', $tariff->court_level) == 'SUPREME_COURT' ? 'selected' : '' }}>Supreme Court</option>
                        <option value="CONSTITUTIONAL_COURT" {{ old('court_level', $tariff->court_level) == 'CONSTITUTIONAL_COURT' ? 'selected' : '' }}>Constitutional Court</option>
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="complexity_level">Complexity Level</label>
                    <select id="complexity_level" name="complexity_level">
                        <option value="">Select Complexity Level</option>
                        <option value="LOW" {{ old('complexity_level', $tariff->complexity_level) == 'LOW' ? 'selected' : '' }}>Low</option>
                        <option value="MEDIUM" {{ old('complexity_level', $tariff->complexity_level) == 'MEDIUM' ? 'selected' : '' }}>Medium</option>
                        <option value="HIGH" {{ old('complexity_level', $tariff->complexity_level) == 'HIGH' ? 'selected' : '' }}>High</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="effective_to">Effective To</label>
                    <input type="date" id="effective_to" name="effective_to" value="{{ old('effective_to', $tariff->effective_to ? $tariff->effective_to->format('Y-m-d') : '') }}">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="retainer_required">Retainer Required</label>
                    <input type="checkbox" id="retainer_required" name="retainer_required" value="1" {{ old('retainer_required', $tariff->retainer_required) ? 'checked' : '' }}>
                </div>

                <div class="form-group" id="retainer_amount_group" style="display: {{ old('retainer_required', $tariff->retainer_required) ? 'block' : 'none' }};">
                    <label for="retainer_amount">Retainer Amount</label>
                    <input type="number" id="retainer_amount" name="retainer_amount" step="0.01" value="{{ old('retainer_amount', $tariff->retainer_amount) }}">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="tax_inclusive">Tax Inclusive</label>
                    <input type="checkbox" id="tax_inclusive" name="tax_inclusive" value="1" {{ old('tax_inclusive', $tariff->tax_inclusive) ? 'checked' : '' }}>
                </div>

                <div class="form-group" id="vat_rate_group" style="display: {{ old('tax_inclusive', $tariff->tax_inclusive) ? 'block' : 'none' }};">
                    <label for="vat_rate">VAT Rate (%)</label>
                    <input type="number" id="vat_rate" name="vat_rate" step="0.01" min="0" max="100" value="{{ old('vat_rate', $tariff->vat_rate) }}">
                </div>
            </div>

            <div class="form-group">
                <label for="description">Description / Notes</label>
                <textarea id="description" name="description">{{ old('description', $tariff->description) }}</textarea>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('tariffs.index') }}" class="back-btn">Back</a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">Refresh</button>
                <button type="submit" class="submit-btn">Update</button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('tariffForm').reset();
    }

    document.getElementById('tariffForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = 'Updating...';
    });
</script>

@endsection

