@extends('layouts.master')

@section('title', 'Edit Tax - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, textarea, select {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, textarea:focus, select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    select {
        cursor: pointer;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .refresh-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        text-decoration: none;
        display: inline-block;
    }

    .submit-btn:hover, .refresh-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Edit Tax</h1>

    <form id="taxForm" action="{{ route('taxes.update', $tax->tax_id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-section">
            <div class="section-title">Tax Information</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="tax_name" class="required">Tax Name</label>
                    <input type="text" id="tax_name" name="tax_name" value="{{ old('tax_name', $tax->tax_name) }}" required>
                </div>

                <div class="form-group">
                    <label for="tax_rate" class="required">Rate (%)</label>
                    <input type="number" id="tax_rate" name="tax_rate" value="{{ old('tax_rate', $tax->tax_rate) }}" step="0.01" min="0" max="100" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="tax_type" class="required">Tax Type</label>
                    <select id="tax_type" name="tax_type" required>
                        <option value="Corporate Income Tax" {{ old('tax_type', $tax->tax_type) == 'Corporate Income Tax' ? 'selected' : '' }}>Corporate Income Tax</option>
                        <option value="PAYE / Payroll Tax" {{ old('tax_type', $tax->tax_type) == 'PAYE / Payroll Tax' ? 'selected' : '' }}>PAYE / Payroll Tax</option>
                        <option value="VAT" {{ old('tax_type', $tax->tax_type) == 'VAT' ? 'selected' : '' }}>VAT</option>
                        <option value="Withholding Tax" {{ old('tax_type', $tax->tax_type) == 'Withholding Tax' ? 'selected' : '' }}>Withholding Tax</option>
                        <option value="Capital Gains Tax" {{ old('tax_type', $tax->tax_type) == 'Capital Gains Tax' ? 'selected' : '' }}>Capital Gains Tax</option>
                        <option value="Presumptive/Turnover Tax" {{ old('tax_type', $tax->tax_type) == 'Presumptive/Turnover Tax' ? 'selected' : '' }}>Presumptive/Turnover Tax</option>
                        <option value="Local Business Taxes" {{ old('tax_type', $tax->tax_type) == 'Local Business Taxes' ? 'selected' : '' }}>Local Business Taxes</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="is_active">Active</label>
                    <input type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $tax->is_active) ? 'checked' : '' }}>
                </div>
            </div>

            <div class="form-group">
                <label for="tax_description">Tax Description</label>
                <textarea id="tax_description" name="tax_description" rows="4">{{ old('tax_description', $tax->tax_description) }}</textarea>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('taxes.index') }}" class="back-btn">Back</a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">Refresh</button>
                <button type="submit" class="submit-btn">Update</button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('taxForm').reset();
    }

    document.getElementById('taxForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = 'Updating...';
    });
</script>

@endsection

