@extends('layouts.master')

@section('title', 'General Ledger - Prolex Law Firm')

@section('content')
<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.edit.chart-of-accounts') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back
        </a>
    </div>

    <div class="row">
        <div class="col-lg-5">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-book me-2"></i>
                        {{ isset($isEdit) ? 'Edit Account' : 'Add General Ledger Account' }}
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ isset($isEdit) ? route('editMainAccount') : route('ledger.store') }}" method="POST" id="ledgerForm">
                        @csrf
                        <input type="hidden" name="id" id="ledgerId" value="">
                        <div id="timeout">
                            @if(Session::has('success'))
                                <div class="alert alert-success">{{ Session('success') }}</div>
                            @endif
                            @if(Session::has('error'))
                                <div class="alert alert-danger">{{ Session('error') }}</div>
                            @endif
                        </div>

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                @foreach ($errors->all() as $error)
                                    <div>{{ $error }}</div>
                                @endforeach
                            </div>
                        @endif

                        <div class="mb-3">
                            <label class="form-label"><strong>Code:</strong></label>
                            <input id="code" class="form-control" type="text" name="code"
                                value="{{ old('code') }}" required />
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><strong>Name:</strong></label>
                            <input id="accountName" class="form-control" type="text" name="account_name"
                                value="{{ old('account_name') }}" required />
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><strong>Financial Category:</strong></label>
                            <select name="financial_category" id="financial_category" class="form-control">
                                <option value="">Select Financial Category</option>
                                <option value="IS" {{ old('financial_category') == 'IS' ? 'selected' : '' }}>Income Statement (IS)</option>
                                <option value="BS" {{ old('financial_category') == 'BS' ? 'selected' : '' }}>Balance Sheet (BS)</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label"><strong>Account Type:</strong></label>
                            <select id="accountTypeSelect" name="account_type" class="form-control">
                                <option value="" disabled selected>Select account type</option>
                                @foreach ($accounts as $acctType)
                                    <option value="{{ $acctType->account_type_id }}"
                                        {{ old('account_type') == $acctType->account_type_id ? 'selected' : '' }}>
                                        {{ $acctType->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="d-flex justify-content-end mt-4">
                            <input id="submitButton" type="submit" class="btn btn-primary me-2"
                                value="{{ isset($isEdit) ? 'UPDATE' : 'SUBMIT' }}">
                            <input type="button" class="btn btn-outline-secondary" value="REFRESH"
                                onclick="resetLedgerForm()">
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-7 mt-4 mt-lg-0">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-list me-2"></i> General Ledger Accounts</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Financial Category</th>
                                    <th>Account Type</th>
                                    <th>Sub Accounts</th>
                                    <th style="width:100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($records as $record)
                                    <tr>
                                        <td>{{ $record->code }}</td>
                                        <td>{{ $record->name }}</td>
                                        <td>{{ $record->financial_category }}</td>
                                        <td>{{ $record->accountType ? $record->accountType->name : 'N/A' }}</td>
                                        <td>
                                            <a href="{{ route('subacc.add', $record->account_id) }}" class="btn btn-sm btn-info">
                                                Sub Accounts
                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <a href="#" class="btn btn-sm btn-primary"
                                                onclick="editAccountType(event,
                                                    '{{ $record->account_id }}',
                                                    '{{ $record->account_type_id }}',
                                                    '{{ $record->code }}',
                                                    '{{ $record->name }}',
                                                    '{{ $record->financial_category }}'
                                                )">
                                                <i class="fas fa-edit"></i>
                                            </a>

                                            <button class="btn btn-sm btn-danger deleteBtn"
                                                    data-id="{{ $record->account_id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this account?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" action="">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function editAccountType(event, id, account_type, code, account_name, financial_category) {
        event.preventDefault();
        document.getElementById('ledgerId').value = id;
        document.getElementById('accountTypeSelect').value = account_type;
        document.getElementById('code').value = code;
        document.getElementById('financial_category').value = financial_category;
        document.getElementById('accountName').value = account_name;
        document.querySelector('.card-header h5').innerHTML = '<i class="fas fa-book me-2"></i> Edit Account';
        document.getElementById('submitButton').value = 'UPDATE';
        document.getElementById('ledgerForm').action = '{{ route("editMainAccount") }}';

        if (!document.querySelector('input[name="isEdit"]')) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'isEdit';
            input.value = '1';
            document.getElementById('ledgerForm').appendChild(input);
        }
    }

    function resetLedgerForm() {
        window.location.href = "{{ route('ledger.create') }}";
    }

    document.addEventListener('DOMContentLoaded', function() {
        const deleteButtons = document.querySelectorAll('.deleteBtn');
        const deleteForm = document.getElementById('deleteForm');
        const modal = new bootstrap.Modal(document.getElementById('deleteConfirmModal'));

        deleteButtons.forEach(button => {
            button.addEventListener('click', function() {
                const accountId = this.getAttribute('data-id');
                const actionUrl = "{{ route('deleteMainAccount', ['id' => ':id']) }}".replace(':id', accountId);

                deleteForm.action = actionUrl;
                modal.show();
            });
        });
    });
</script>

<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection

