@extends('layouts.master')

@section('title', 'Judge Details - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .detail-group {
        margin-bottom: 20px;
        padding: 15px;
        background: white;
        border-radius: 8px;
        border: 1px solid #e2e8f0;
    }

    .detail-label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 5px;
    }

    .detail-value {
        color: #6b7280;
        font-size: 1rem;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        display: inline-block;
    }

    .status-active {
        background-color: #d1fae5;
        color: #065f46;
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #991b1b;
    }

    .btn-container {
        display: flex;
        justify-content: space-between;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #f59e0b;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #d97706;
        transform: translateY(-2px);
    }

    .btn-danger {
        background-color: #ef4444;
        color: white;
    }

    .btn-danger:hover {
        background-color: #dc2626;
        transform: translateY(-2px);
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        h1 {
            font-size: 2rem;
        }

        .btn-container {
            flex-direction: column;
            gap: 15px;
        }

        .btn {
            width: 100%;
            text-align: center;
        }
    }
</style>

<div class="container">
    <h1>Judge Details</h1>

    <div class="detail-group">
        <div class="detail-label">Judge Code</div>
        <div class="detail-value">{{ $judge->judge_code }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Full Name</div>
        <div class="detail-value">{{ $judge->full_name }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Court Area</div>
        <div class="detail-value">{{ $judge->courtArea ? $judge->courtArea->area_name : 'N/A' }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Court Type</div>
        <div class="detail-value">{{ $judge->courtType ? $judge->courtType->type_name : 'N/A' }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Contact</div>
        <div class="detail-value">{{ $judge->contact ?: 'N/A' }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Email</div>
        <div class="detail-value">{{ $judge->email ?: 'N/A' }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Notes</div>
        <div class="detail-value">{{ $judge->notes ?: 'N/A' }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Status</div>
        <div class="detail-value">
            <span class="status-badge {{ $judge->is_active ? 'status-active' : 'status-inactive' }}">
                {{ $judge->is_active ? 'Active' : 'Inactive' }}
            </span>
        </div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Created At</div>
        <div class="detail-value">{{ $judge->created_at->format('M d, Y H:i') }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Updated At</div>
        <div class="detail-value">{{ $judge->updated_at->format('M d, Y H:i') }}</div>
    </div>

    <div class="btn-container">
        <a href="{{ route('modules.edit.judges.index') }}" class="btn btn-primary">Back to List</a>
        <a href="{{ route('modules.edit.judges.edit', $judge->judge_code) }}" class="btn btn-secondary">Edit Judge</a>
        <form action="{{ route('modules.edit.judges.destroy', $judge->judge_code) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this judge?')">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger">Delete Judge</button>
        </form>
    </div>
</div>

@endsection

