@extends('layouts.master')

@section('title', 'View Judgement - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .detail-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 20px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .detail-row {
        display: flex;
        margin-bottom: 15px;
        padding-bottom: 15px;
        border-bottom: 1px solid #f1f5f9;
    }

    .detail-row:last-child {
        border-bottom: none;
        margin-bottom: 0;
        padding-bottom: 0;
    }

    .detail-label {
        font-weight: 600;
        color: #374151;
        min-width: 150px;
        margin-right: 20px;
    }

    .detail-value {
        color: #4b5563;
        flex: 1;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background-color: #d1fae5;
        color: #065f46;
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #991b1b;
    }

    .btn-container {
        display: flex;
        justify-content: space-between;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
    }

    .btn-danger {
        background-color: #ef4444;
        color: white;
    }

    .btn-danger:hover {
        background-color: #dc2626;
        transform: translateY(-2px);
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        h1 {
            font-size: 2rem;
        }

        .detail-row {
            flex-direction: column;
        }

        .detail-label {
            margin-bottom: 5px;
            margin-right: 0;
        }

        .btn-container {
            flex-direction: column;
            gap: 15px;
        }

        .btn {
            width: 100%;
            text-align: center;
        }
    }
</style>

<div class="container">
    <h1>Judgement Details</h1>

    <div class="detail-section">
        <div class="detail-row">
            <div class="detail-label">Judgement Code:</div>
            <div class="detail-value">{{ $judgement->judgement_code }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Judgement Title:</div>
            <div class="detail-value">{{ $judgement->title }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Description:</div>
            <div class="detail-value">{{ $judgement->description ?: 'N/A' }}</div>
        </div>
    </div>

    <div class="btn-container">
        <a href="{{ route('modules.edit.court-details') }}" class="btn btn-secondary">Back to Court Details</a>
        <a href="{{ route('modules.edit.judgements.index') }}" class="btn btn-secondary">Back to Judgements</a>
        <a href="{{ route('modules.edit.judgements.edit', $judgement->judgement_code) }}" class="btn btn-primary">Edit Judgement</a>
    </div>
</div>

@endsection

