@extends('layouts.master')

@section('title', 'Lawyer Management - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1400px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .search-container {
        margin-bottom: 20px;
        display: flex;
        gap: 10px;
        align-items: center;
    }

    .search-input {
        flex: 1;
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 8px;
        font-size: 1rem;
        transition: border-color 0.3s ease;
    }

    .search-input:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .filter-select {
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 8px;
        font-size: 1rem;
        background-color: white;
    }

    .table-container {
        background: white;
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #2d3748;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    tr:hover {
        background-color: #f8fafc;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        font-size: 0.9rem;
        margin-right: 5px;
        transition: all 0.3s ease;
    }

    .edit-btn {
        background-color: #3b82f6;
        color: white;
    }

    .edit-btn:hover {
        background-color: #2563eb;
    }

    .delete-btn {
        background-color: #e53e3e;
        color: white;
    }

    .delete-btn:hover {
        background-color: #c53030;
    }

    .view-btn {
        background-color: #38a169;
        color: white;
    }

    .view-btn:hover {
        background-color: #2f855a;
    }

    .no-lawyers {
        text-align: center;
        padding: 40px;
        color: #718096;
        font-style: italic;
    }

    .status-badge {
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 0.8rem;
        font-weight: 600;
    }

    .status-active {
        background-color: #c6f6d5;
        color: #22543d;
    }

    .status-inactive {
        background-color: #fed7d7;
        color: #742a2a;
    }

    .status-suspended {
        background-color: #fef5e7;
        color: #7c2d12;
    }
</style>

<div class="container">
    <h1>Lawyer Management</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #a7f3d0;">
            {{ session('success') }}
        </div>
    @endif

    <div style="margin-bottom: 20px;">
        <a href="{{ route('modules.edit.add-lawyer') }}" style="background: linear-gradient(135deg, #3b82f6, #1d4ed8); color: white; padding: 12px 24px; border-radius: 8px; text-decoration: none; font-weight: 600; display: inline-block; transition: all 0.3s ease;">
            <i class="fas fa-plus"></i> Add New Lawyer
        </a>
    </div>

    <div class="search-container">
        <input type="text" id="searchInput" class="search-input" placeholder="Search lawyers by name, email, or ID...">
        <select id="statusFilter" class="filter-select">
            <option value="">All Status</option>
            <option value="Active">Active</option>
            <option value="Inactive">Inactive</option>
            <option value="Suspended">Suspended</option>
        </select>
        <select id="groupFilter" class="filter-select">
            <option value="">All Groups</option>
            @foreach($lawyerGroups as $group)
                <option value="{{ $group->group_name }}">{{ $group->group_name }}</option>
            @endforeach
        </select>
    </div>

    <div class="table-container">
        @if($lawyers->count() > 0)
            <table id="lawyersTable">
                <thead>
                    <tr>
                        <th>Lawyer ID</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th>Primary Phone</th>
                        <th>Secondary Phone</th>
                        <th>Lawyer Group</th>
                        <th>Certificate Number</th>
                        <th>Date of Admission</th>
                        <th>Status</th>
                        <th>Lawyer Type</th>
                        <th>Tariff</th>
                        <th>Tier</th>
                        <th>Notes</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($lawyers as $lawyer)
                        <tr>
                            <td>{{ $lawyer->lawyer_id }}</td>
                            <td>{{ $lawyer->first_name }}</td>
                            <td>{{ $lawyer->last_name }}</td>
                            <td>{{ $lawyer->email ?? 'N/A' }}</td>
                            <td>{{ $lawyer->phone_primary ?? 'N/A' }}</td>
                            <td>{{ $lawyer->phone_secondary ?? 'N/A' }}</td>
                            <td>{{ $lawyer->lawyerGroup->group_name ?? 'N/A' }}</td>
                            <td>{{ $lawyer->bar_number ?? 'N/A' }}</td>
                            <td>{{ $lawyer->date_of_admission ? $lawyer->date_of_admission->format('Y-m-d') : 'N/A' }}</td>
                            <td>
                                <span class="status-badge status-{{ strtolower($lawyer->status ?? 'inactive') }}">
                                    {{ $lawyer->status ?? 'Inactive' }}
                                </span>
                            </td>
                            <td>{{ $lawyer->lawyer_type ?? 'N/A' }}</td>
                            <td>{{ $lawyer->tariff ?? 'N/A' }}</td>
                            <td>{{ $lawyer->tier ?? 'N/A' }}</td>
                            <td>{{ $lawyer->notes ?? 'N/A' }}</td>
                            <td>
                                <a href="{{ route('modules.edit.lawyer.show', $lawyer->lawyer_id) }}" class="action-btn view-btn">View</a>
                                <a href="{{ route('modules.edit.lawyer.edit', $lawyer->lawyer_id) }}" class="action-btn edit-btn">Edit</a>
                                <form action="{{ route('modules.edit.lawyer.destroy', $lawyer->lawyer_id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this lawyer?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="no-lawyers">No lawyers found.</p>
        @endif
    </div>
</div>

<script>
    // Search and filter functionality
    document.addEventListener('DOMContentLoaded', function() {
        const searchInput = document.getElementById('searchInput');
        const statusFilter = document.getElementById('statusFilter');
        const groupFilter = document.getElementById('groupFilter');
        const table = document.getElementById('lawyersTable');
        const rows = table ? table.querySelectorAll('tbody tr') : [];

        function filterTable() {
            const searchTerm = searchInput.value.toLowerCase();
            const statusValue = statusFilter.value.toLowerCase();
            const groupValue = groupFilter.value.toLowerCase();

            rows.forEach(row => {
                const cells = row.querySelectorAll('td');
                const lawyerId = cells[0].textContent.toLowerCase();
                const firstName = cells[1].textContent.toLowerCase();
                const lastName = cells[2].textContent.toLowerCase();
                const email = cells[3].textContent.toLowerCase();
                const status = cells[9].textContent.toLowerCase();
                const group = cells[6].textContent.toLowerCase();

                const matchesSearch = lawyerId.includes(searchTerm) ||
                                    firstName.includes(searchTerm) ||
                                    lastName.includes(searchTerm) ||
                                    email.includes(searchTerm);
                const matchesStatus = !statusValue || status.includes(statusValue);
                const matchesGroup = !groupValue || group.includes(groupValue);

                row.style.display = matchesSearch && matchesStatus && matchesGroup ? '' : 'none';
            });
        }

        searchInput.addEventListener('input', filterTable);
        statusFilter.addEventListener('change', filterTable);
        groupFilter.addEventListener('change', filterTable);
    });
</script>
@endsection

