@extends('layouts.master')

@section('title', 'Add Lawyer Role - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f0f9ff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        user-select: none;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #374151;
    }

    input[type="text"],
    input[type="number"],
    select,
    textarea {
        width: 100%;
        padding: 10px 15px;
        border: 2px solid #3b82f6;
        border-radius: 8px;
        font-size: 1em;
        transition: border-color 0.3s ease;
    }

    input[type="text"]:focus,
    input[type="number"]:focus,
    select:focus,
    textarea:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 8px rgba(37, 99, 235, 0.5);
    }

    textarea {
        resize: vertical;
        min-height: 80px;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: auto;
        margin: 0;
    }

    .checkbox-group label {
        margin: 0;
        font-weight: normal;
    }

    .button-group {
        display: flex;
        gap: 15px;
        justify-content: center;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 25px;
        border: none;
        border-radius: 8px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        user-select: none;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(107, 114, 128, 0.4);
    }

    .required {
        color: #dc2626;
    }

    .help-text {
        font-size: 0.9em;
        color: #6b7280;
        margin-top: 3px;
    }

    .error-message {
        color: #dc2626;
        font-size: 0.9em;
        margin-top: 5px;
    }
</style>

<div class="container" role="main" aria-label="Add Lawyer Role">
    <h1>Add Lawyer Role</h1>

    <form action="{{ route('modules.edit.lawyer-roles.store') }}" method="POST" id="lawyerRoleForm">
        @csrf

        <div class="form-group">
            <label for="code">
                Code <span class="required">*</span>
            </label>
            <input
                type="text"
                id="code"
                name="code"
                value="{{ old('code') }}"
                required
                pattern="[a-zA-Z_]+"
                title="Only letters and underscores allowed"
                placeholder="e.g., lead_counsel"
            >
            <div class="help-text">Machine-safe identifier, must be unique (letters and underscores only)</div>
            @error('code')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="name">
                Name <span class="required">*</span>
            </label>
            <input
                type="text"
                id="name"
                name="name"
                value="{{ old('name') }}"
                required
                placeholder="e.g., Lead Counsel"
            >
            <div class="help-text">Human-readable name for the role</div>
            @error('name')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="description">Description</label>
            <textarea
                id="description"
                name="description"
                placeholder="Optional internal notes about this role"
            >{{ old('description') }}</textarea>
            <div class="help-text">Optional description for internal reference</div>
            @error('description')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="side">
                Side <span class="required">*</span>
            </label>
            <select id="side" name="side" required>
                <option value="">Select a side</option>
                <option value="plaintiff" {{ old('side') == 'plaintiff' ? 'selected' : '' }}>Plaintiff</option>
                <option value="defendant" {{ old('side') == 'defendant' ? 'selected' : '' }}>Defendant</option>
                <option value="prosecution" {{ old('side') == 'prosecution' ? 'selected' : '' }}>Prosecution</option>
                <option value="defense" {{ old('side') == 'defense' ? 'selected' : '' }}>Defense</option>
                <option value="neutral" {{ old('side') == 'neutral' ? 'selected' : '' }}>Neutral</option>
            </select>
            <div class="help-text">The side this role represents in legal proceedings</div>
            @error('side')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input
                    type="checkbox"
                    id="is_primary"
                    name="is_primary"
                    value="1"
                    {{ old('is_primary') ? 'checked' : '' }}
                >
                <label for="is_primary">Is Primary</label>
            </div>
            <div class="help-text">Indicates this is the lead/coordinating counsel for that side</div>
            @error('is_primary')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input
                    type="checkbox"
                    id="requires_bar_status"
                    name="requires_bar_status"
                    value="1"
                    {{ old('requires_bar_status', true) ? 'checked' : '' }}
                >
                <label for="requires_bar_status">Requires Bar Status</label>
            </div>
            <div class="help-text">Check if this role requires a licensed attorney (default: checked)</div>
            @error('requires_bar_status')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="jurisdiction_scope">Jurisdiction Scope</label>
            <select id="jurisdiction_scope" name="jurisdiction_scope">
                <option value="GLOBAL" {{ old('jurisdiction_scope', 'GLOBAL') == 'GLOBAL' ? 'selected' : '' }}>Global</option>
                <option value="US" {{ old('jurisdiction_scope') == 'US' ? 'selected' : '' }}>US</option>
                <option value="UK" {{ old('jurisdiction_scope') == 'UK' ? 'selected' : '' }}>UK</option>
            </select>
            <div class="help-text">Geographic scope where this role applies (default: Global)</div>
            @error('jurisdiction_scope')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input
                    type="checkbox"
                    id="is_active"
                    name="is_active"
                    value="1"
                    {{ old('is_active', true) ? 'checked' : '' }}
                >
                <label for="is_active">Is Active</label>
            </div>
            <div class="help-text">Whether this role is currently active (default: checked)</div>
            @error('is_active')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="sort_order">Sort Order</label>
            <input
                type="number"
                id="sort_order"
                name="sort_order"
                value="{{ old('sort_order') }}"
                min="0"
                placeholder="e.g., 1"
            >
            <div class="help-text">Optional number to control ordering in dropdowns/UI</div>
            @error('sort_order')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="button-group">
            <button type="submit" class="btn btn-primary">
                Create Role
            </button>
            <a href="{{ route('modules.edit.lawyer-roles') }}" class="btn btn-secondary">
                Cancel
            </a>
        </div>
    </form>
</div>

<script>
    // Form validation
    document.getElementById('lawyerRoleForm').addEventListener('submit', function(e) {
        const code = document.getElementById('code').value.trim();
        const name = document.getElementById('name').value.trim();
        const side = document.getElementById('side').value;

        if (!code) {
            alert('Code is required');
            e.preventDefault();
            return;
        }

        if (!/^[a-zA-Z_]+$/.test(code)) {
            alert('Code can only contain letters and underscores');
            e.preventDefault();
            return;
        }

        if (!name) {
            alert('Name is required');
            e.preventDefault();
            return;
        }

        if (!side) {
            alert('Side selection is required');
            e.preventDefault();
            return;
        }
    });

    // Auto-format code field
    document.getElementById('code').addEventListener('input', function(e) {
        this.value = this.value.replace(/[^a-zA-Z_]/g, '').toLowerCase();
    });
</script>
@endsection
