@extends('layouts.master')

@section('title', 'Edit Lawyer Role - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 600px;
        margin: 40px auto;
        background-color: #f0f9ff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        user-select: none;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #374151;
    }

    input[type="text"],
    input[type="number"],
    select,
    textarea {
        width: 100%;
        padding: 10px 12px;
        border: 2px solid #3b82f6;
        border-radius: 6px;
        font-size: 14px;
        transition: border-color 0.3s ease;
        box-sizing: border-box;
    }

    input[type="text"]:focus,
    input[type="number"]:focus,
    select:focus,
    textarea:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 8px rgba(37, 99, 235, 0.5);
    }

    textarea {
        resize: vertical;
        min-height: 80px;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: auto;
        margin: 0;
    }

    .checkbox-group label {
        margin: 0;
        font-weight: normal;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 6px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        user-select: none;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
        margin-left: 10px;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(107, 114, 128, 0.4);
    }

    .form-actions {
        display: flex;
        justify-content: center;
        gap: 15px;
        margin-top: 30px;
    }

    .error-message {
        color: #dc2626;
        font-size: 14px;
        margin-top: 5px;
    }

    .required {
        color: #dc2626;
    }

    .help-text {
        color: #6b7280;
        font-size: 12px;
        margin-top: 5px;
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        .form-actions {
            flex-direction: column;
        }

        .btn {
            width: 100%;
        }
    }
</style>

<div class="container" role="main" aria-label="Edit Lawyer Role">
    <h1>Edit Lawyer Role</h1>

    <form method="POST" action="{{ route('modules.edit.lawyer-roles.update', $lawyerRole->lawyer_role_id) }}" novalidate>
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="code">Code <span class="required">*</span></label>
            <input
                type="text"
                id="code"
                name="code"
                value="{{ old('code', $lawyerRole->code) }}"
                required
                pattern="[a-zA-Z_]+"
                title="Only letters and underscores allowed"
                aria-describedby="code-help"
            >
            <div class="help-text" id="code-help">Use only letters and underscores (e.g., SENIOR_COUNSEL)</div>
            @error('code')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="name">Name <span class="required">*</span></label>
            <input
                type="text"
                id="name"
                name="name"
                value="{{ old('name', $lawyerRole->name) }}"
                required
                maxlength="255"
            >
            @error('name')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="description">Description</label>
            <textarea
                id="description"
                name="description"
                maxlength="1000"
                rows="3"
            >{{ old('description', $lawyerRole->description) }}</textarea>
            @error('description')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="side">Side <span class="required">*</span></label>
            <select id="side" name="side" required>
                <option value="">Select Side</option>
                <option value="plaintiff" {{ old('side', $lawyerRole->side) == 'plaintiff' ? 'selected' : '' }}>Plaintiff</option>
                <option value="defendant" {{ old('side', $lawyerRole->side) == 'defendant' ? 'selected' : '' }}>Defendant</option>
                <option value="prosecution" {{ old('side', $lawyerRole->side) == 'prosecution' ? 'selected' : '' }}>Prosecution</option>
                <option value="defense" {{ old('side', $lawyerRole->side) == 'defense' ? 'selected' : '' }}>Defense</option>
                <option value="neutral" {{ old('side', $lawyerRole->side) == 'neutral' ? 'selected' : '' }}>Neutral</option>
            </select>
            @error('side')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="jurisdiction_scope">Jurisdiction Scope</label>
            <select id="jurisdiction_scope" name="jurisdiction_scope">
                <option value="GLOBAL" {{ old('jurisdiction_scope', $lawyerRole->jurisdiction_scope ?? 'GLOBAL') == 'GLOBAL' ? 'selected' : '' }}>Global</option>
                <option value="US" {{ old('jurisdiction_scope', $lawyerRole->jurisdiction_scope ?? 'GLOBAL') == 'US' ? 'selected' : '' }}>United States</option>
                <option value="UK" {{ old('jurisdiction_scope', $lawyerRole->jurisdiction_scope ?? 'GLOBAL') == 'UK' ? 'selected' : '' }}>United Kingdom</option>
            </select>
            @error('jurisdiction_scope')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="sort_order">Sort Order</label>
            <input
                type="number"
                id="sort_order"
                name="sort_order"
                value="{{ old('sort_order', $lawyerRole->sort_order ?? 0) }}"
                min="0"
                step="1"
            >
            <div class="help-text">Lower numbers appear first in lists</div>
            @error('sort_order')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input
                    type="checkbox"
                    id="is_primary"
                    name="is_primary"
                    value="1"
                    {{ old('is_primary', $lawyerRole->is_primary) ? 'checked' : '' }}
                >
                <label for="is_primary">Is Primary Counsel</label>
            </div>
            <div class="help-text">Check if this role represents lead/coordinating counsel</div>
            @error('is_primary')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input
                    type="checkbox"
                    id="requires_bar_status"
                    name="requires_bar_status"
                    value="1"
                    {{ old('requires_bar_status', $lawyerRole->requires_bar_status) ? 'checked' : '' }}
                >
                <label for="requires_bar_status">Requires Bar Status</label>
            </div>
            <div class="help-text">Check if lawyers in this role must be admitted to practice</div>
            @error('requires_bar_status')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input
                    type="checkbox"
                    id="is_active"
                    name="is_active"
                    value="1"
                    {{ old('is_active', $lawyerRole->is_active) ? 'checked' : '' }}
                >
                <label for="is_active">Is Active</label>
            </div>
            <div class="help-text">Inactive roles won't be available for new assignments</div>
            @error('is_active')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                Update Role
            </button>
            <a href="{{ route('modules.edit.lawyer-roles.view') }}" class="btn btn-secondary">
                Cancel
            </a>
        </div>
    </form>
</div>

<script>
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const codeInput = document.getElementById('code');
        const nameInput = document.getElementById('name');
        const sideSelect = document.getElementById('side');

        let isValid = true;

        // Validate code
        if (!codeInput.value.trim()) {
            showError(codeInput, 'Code is required');
            isValid = false;
        } else if (!/^[a-zA-Z_]+$/.test(codeInput.value)) {
            showError(codeInput, 'Code can only contain letters and underscores');
            isValid = false;
        } else {
            clearError(codeInput);
        }

        // Validate name
        if (!nameInput.value.trim()) {
            showError(nameInput, 'Name is required');
            isValid = false;
        } else {
            clearError(nameInput);
        }

        // Validate side
        if (!sideSelect.value) {
            showError(sideSelect, 'Side is required');
            isValid = false;
        } else {
            clearError(sideSelect);
        }

        if (!isValid) {
            e.preventDefault();
        }
    });

    function showError(element, message) {
        clearError(element);
        const errorDiv = document.createElement('div');
        errorDiv.className = 'error-message';
        errorDiv.textContent = message;
        element.parentNode.insertBefore(errorDiv, element.nextSibling);
        element.style.borderColor = '#dc2626';
    }

    function clearError(element) {
        const existingError = element.parentNode.querySelector('.error-message');
        if (existingError) {
            existingError.remove();
        }
        element.style.borderColor = '#3b82f6';
    }

    // Auto-format code input
    document.getElementById('code').addEventListener('input', function() {
        this.value = this.value.replace(/[^a-zA-Z_]/g, '').toUpperCase();
    });
</script>
@endsection
