@extends('layouts.master')

@section('title', 'View Lawyer Roles - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f0f9ff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        user-select: none;
    }

    .actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 25px;
        flex-wrap: wrap;
        gap: 15px;
    }

    .search-container {
        display: flex;
        gap: 10px;
        align-items: center;
    }

    #searchInput {
        padding: 8px 12px;
        border: 2px solid #3b82f6;
        border-radius: 6px;
        font-size: 14px;
        width: 250px;
        transition: border-color 0.3s ease;
    }

    #searchInput:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 8px rgba(37, 99, 235, 0.5);
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 6px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        user-select: none;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(107, 114, 128, 0.4);
    }

    .table-container {
        overflow-x: auto;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    table {
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
    }

    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }

    th {
        background-color: #f9fafb;
        font-weight: 600;
        color: #374151;
        position: sticky;
        top: 0;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .status-badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background-color: #dcfce7;
        color: #166534;
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #991b1b;
    }

    .primary-badge {
        background-color: #fef3c7;
        color: #92400e;
        padding: 2px 6px;
        border-radius: 10px;
        font-size: 11px;
        font-weight: 600;
    }

    .actions-column {
        white-space: nowrap;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        margin-right: 5px;
        transition: all 0.2s ease;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
    }

    .pagination {
        display: flex;
        justify-content: center;
        margin-top: 20px;
        gap: 5px;
    }

    .pagination a, .pagination span {
        padding: 8px 12px;
        border: 1px solid #d1d5db;
        border-radius: 4px;
        text-decoration: none;
        color: #374151;
        background: white;
        transition: all 0.2s ease;
    }

    .pagination a:hover, .pagination .active {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .no-data {
        text-align: center;
        padding: 40px;
        color: #6b7280;
        font-style: italic;
    }

    @media (max-width: 768px) {
        .container {
            margin: 20px;
            padding: 20px;
        }

        .actions {
            flex-direction: column;
            align-items: stretch;
        }

        .search-container {
            justify-content: center;
        }

        #searchInput {
            width: 100%;
        }

        th, td {
            padding: 8px 10px;
            font-size: 12px;
        }
    }
</style>

<div class="container" role="main" aria-label="View Lawyer Roles">
    <h1>Lawyer Roles</h1>

    <div class="actions">
        <div class="search-container">
            <input
                type="text"
                id="searchInput"
                placeholder="Search roles..."
                aria-label="Search lawyer roles"
            >
        </div>
        <div>
            <a href="{{ route('modules.edit.lawyer-roles.add') }}" class="btn btn-primary">
                Add New Role
            </a>
            <a href="{{ route('modules.edit.lawyer-roles') }}" class="btn btn-secondary">
                Back to Menu
            </a>
        </div>
    </div>

    <div class="table-container">
        <table id="rolesTable">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Name</th>
                    <th>Side</th>
                    <th>Jurisdiction</th>
                    <th>Primary</th>
                    <th>Requires Bar</th>
                    <th>Status</th>
                    <th>Sort Order</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($lawyerRoles ?? [] as $role)
                <tr>
                    <td>{{ $role->code }}</td>
                    <td>{{ $role->name }}</td>
                    <td>{{ ucfirst($role->side) }}</td>
                    <td>{{ $role->jurisdiction_scope ?? 'GLOBAL' }}</td>
                    <td>
                        @if($role->is_primary)
                            <span class="primary-badge">Primary</span>
                        @else
                            -
                        @endif
                    </td>
                    <td>
                        @if($role->requires_bar_status)
                            <span class="status-badge status-active">Yes</span>
                        @else
                            <span class="status-badge status-inactive">No</span>
                        @endif
                    </td>
                    <td>
                        @if($role->is_active)
                            <span class="status-badge status-active">Active</span>
                        @else
                            <span class="status-badge status-inactive">Inactive</span>
                        @endif
                    </td>
                    <td>{{ $role->sort_order ?? 0 }}</td>
                    <td class="actions-column">
                        <a href="{{ route('modules.edit.lawyer-roles.edit', $role->lawyer_role_id) }}" class="action-btn edit-btn">Edit</a>
                        <form method="POST" action="{{ route('modules.edit.lawyer-roles.destroy', $role->lawyer_role_id) }}" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this role?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="9" class="no-data">
                        No lawyer roles found. <a href="{{ route('modules.edit.lawyer-roles.add') }}">Create your first role</a>.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if(isset($lawyerRoles) && $lawyerRoles->hasPages())
    <div class="pagination">
        {{ $lawyerRoles->links() }}
    </div>
    @endif
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase().trim();
        const rows = document.querySelectorAll('#rolesTable tbody tr');

        rows.forEach(row => {
            if (row.cells.length > 1) { // Skip the "no data" row
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            }
        });
    });

    // Confirm delete action
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            if (!confirm('Are you sure you want to delete this lawyer role? This action cannot be undone.')) {
                e.preventDefault();
            }
        });
    });
</script>
@endsection
