@extends('layouts.master')

@section('title', 'Lawyer Roles - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 600px;
        margin: 40px auto;
        background-color: #f0f9ff; /* light blue */
        padding: 20px 30px 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af; /* blue-900 */
        margin-bottom: 25px;
        user-select: none;
    }

    #searchInput {
        width: 100%;
        padding: 10px 15px;
        font-size: 1em;
        border: 2px solid #3b82f6; /* blue-500 */
        border-radius: 8px;
        margin-bottom: 25px;
        transition: border-color 0.3s ease;
    }
    #searchInput:focus {
        outline: none;
        border-color: #2563eb; /* blue-600 */
        box-shadow: 0 0 8px rgba(37, 99, 235, 0.5);
    }

    .option-list {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .option-item {
        background-color: #3b82f6; /* blue-500 */
        color: white;
        padding: 15px 20px;
        border-radius: 8px;
        font-size: 1.2em;
        font-weight: 600;
        text-align: center;
        text-decoration: none;
        position: relative;
        overflow: hidden;
        cursor: pointer;
        user-select: none;
        transition:
            background-color 0.3s ease,
            transform 0.2s ease,
            box-shadow 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.4);
    }

    .option-item:hover,
    .option-item:focus-visible {
        background-color: #2563eb; /* blue-600 */
        transform: scale(1.05);
        box-shadow: 0 8px 15px rgba(37, 99, 235, 0.6);
        outline: none;
        z-index: 1;
    }

    /* Ripple effect container */
    .option-item .ripple {
        position: absolute;
        border-radius: 50%;
        transform: scale(0);
        animation: ripple 600ms linear;
        background-color: rgba(255, 255, 255, 0.7);
        pointer-events: none;
        z-index: 2;
    }

    @keyframes ripple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }
</style>

<div class="container" role="main" aria-label="Lawyer Roles">
    <h1>Lawyer Roles</h1>

    <input
        type="search"
        id="searchInput"
        placeholder="Search options..."
        aria-label="Search Lawyer Roles options"
        autocomplete="off"
    />

    <div class="option-list" role="list" id="optionList">
        <a href="{{ route('modules.edit.lawyer-roles.add') }}" class="option-item" role="listitem" tabindex="0">
            Add Roles
        </a>
        <a href="{{ route('modules.edit.lawyer-roles.view') }}" class="option-item" role="listitem" tabindex="0">
            View Roles
        </a>
    </div>
</div>

<script>
    // Ripple effect on click
    document.querySelectorAll('.option-item').forEach(item => {
        item.addEventListener('click', function (e) {
            const ripple = document.createElement('span');
            ripple.classList.add('ripple');
            this.appendChild(ripple);

            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            ripple.style.width = ripple.style.height = size + 'px';

            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';

            ripple.addEventListener('animationend', () => {
                ripple.remove();
            });
        });
    });

    // Search/filter functionality
    const searchInput = document.getElementById('searchInput');
    const optionList = document.getElementById('optionList');
    const options = optionList.querySelectorAll('.option-item');

    searchInput.addEventListener('input', () => {
        const query = searchInput.value.toLowerCase().trim();
        options.forEach(option => {
            const text = option.textContent.toLowerCase();
            option.style.display = text.includes(query) ? '' : 'none';
        });
    });
</script>
@endsection
