@extends('layouts.master')

@section('title', 'Multi Currency - Prolex Law Firm')

@section('content')
<style>
    /* Custom blue theme */
    body {
        background-color: #f8faff;
        color: #1a237e;
    }
    .card {
        background-color: #ffffff;
        border: none;
        border-radius: 0.5rem;
        box-shadow: 0 0.125rem 0.25rem rgba(26, 35, 126, 0.15);
    }
    .card-header {
        background-color: #1a237e;
        color: #ffffff;
        font-weight: 600;
        font-size: 1.1rem;
        border-bottom: none;
        border-radius: 0.5rem 0.5rem 0 0;
    }
    .nav-tabs .nav-link {
        color: #1a237e;
        font-weight: 600;
        border: none;
        border-bottom: 3px solid transparent;
        transition: border-color 0.3s ease;
    }
    .nav-tabs .nav-link.active {
        color: #ffffff;
        background-color: #1a237e;
        border-radius: 0.5rem 0.5rem 0 0;
        border-bottom: 3px solid #1976d2;
    }
    .nav-tabs .nav-link:hover {
        color: #1976d2;
        border-bottom: 3px solid #1976d2;
    }
    .btn-primary {
        background-color: #1976d2;
        border-color: #1976d2;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }
    .btn-primary:hover {
        background-color: #1565c0;
        border-color: #1565c0;
    }
    .btn-secondary {
        background-color: #90caf9;
        border-color: #90caf9;
        color: #1a237e;
        font-weight: 600;
    }
    .btn-secondary:hover {
        background-color: #64b5f6;
        border-color: #64b5f6;
        color: #1a237e;
    }
    .btn-circle {
        border-radius: 50%;
        width: 36px;
        height: 36px;
        padding: 0;
        display: inline-flex;
        justify-content: center;
        align-items: center;
        font-size: 1rem;
    }
    table.table-bordered {
        border: 1px solid #1976d2;
    }
    table.table-bordered th,
    table.table-bordered td {
        border: 1px solid #1976d2;
        vertical-align: middle;
    }
    .form-control-user {
        border-radius: 0.375rem;
        border: 1px solid #1976d2;
        transition: border-color 0.3s ease;
    }
    .form-control-user:focus {
        border-color: #1565c0;
        box-shadow: 0 0 0 0.2rem rgba(21, 101, 192, 0.25);
    }
    label {
        font-weight: 600;
        color: #1a237e;
    }
    .alert-success {
        background-color: #c8e6c9;
        color: #2e7d32;
        border-radius: 0.375rem;
        border: none;
    }
    .card.bg-warning {
        background-color: #fff3e0 !important;
        color: #ef6c00 !important;
        border-radius: 0.375rem;
    }
</style>

<div class="container-fluid py-4">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0" style="color: #1a237e;">Multi Currency Management</h1>
    </div>

    <!-- Nav tabs -->
    <ul class="nav nav-tabs mb-4" id="currencyTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="currency-tab" data-bs-toggle="tab" data-bs-target="#currency" type="button" role="tab" aria-controls="currency" aria-selected="true">Currency</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="home-currency-tab" data-bs-toggle="tab" data-bs-target="#home-currency" type="button" role="tab" aria-controls="home-currency" aria-selected="false">Home Currency</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="rates-tab" data-bs-toggle="tab" data-bs-target="#rates" type="button" role="tab" aria-controls="rates" aria-selected="false">Daily Rates</button>
        </li>
    </ul>

    <!-- Tab panes -->
    <div class="tab-content" id="currencyTabContent">
        <!-- Currency Tab -->
        <div class="tab-pane fade show active" id="currency" role="tabpanel" aria-labelledby="currency-tab">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0" id="formHeader_currency">Add Currency</h6>
                </div>
                @if (session('success'))
                    <div class="alert alert-success mx-4 my-3" id="successMessage_currency">
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="form-group mx-4 my-3" id="errorMessage_currency">
                        <div class="card bg-warning shadow p-3">
                            @foreach ($errors->all() as $error)
                            <div>{{ $error }}</div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <form class="card-body" action="{{ route('currency.store') }}" method="post" id="currencyForm">
                    @csrf
                    <input type="hidden" id="currencyId" name="id" value="">
                    <input type="hidden" name="_method" value="POST" id="currencyMethod">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <input type="text" class="form-control form-control-user" id="currency_code" placeholder="Currency Code" name="currency_code" value="{{ old('currency_code') }}" required>
                        </div>
                        <div class="col-md-6">
                            <input type="text" class="form-control form-control-user" id="currency_name" placeholder="Currency Name" name="currency_name" value="{{ old('currency_name') }}" required>
                        </div>
                        <div class="col-md-6">
                            <input type="text" class="form-control form-control-user" id="symbol" placeholder="Currency Symbol" name="symbol" value="{{ old('symbol') }}">
                        </div>
                        <div class="col-md-6">
                            <input type="text" class="form-control form-control-user" id="country" placeholder="Country" name="country" value="{{ old('country') }}">
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex mt-3">
                        <input type="submit" style="width: 120px; height: 42px; margin-right: 12px;" value="Create" class="btn btn-primary btn-user" id="submitButton_currency"/>
                        <input style="width: 120px; height: 42px;" type="reset" value="Refresh" class="btn btn-secondary btn-user" onclick="refreshCurrency('','', '')"/>
                    </div>

                    <hr class="mt-4">
                </form>

                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="currencyTable" width="100%" cellspacing="0">
                            <thead class="table-primary">
                                <tr>
                                    <th>Currency Code</th>
                                    <th>Currency Name</th>
                                    <th>Symbol</th>
                                    <th>Country</th>
                                    <th>Status</th>
                                    <th class="text-center" style="width: 120px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($currencies as $currency)
                                    @if($currency->currency_id)
                                    <tr>
                                        <td>{{ $currency->currency_code }}</td>
                                        <td>{{ $currency->currency_name }}</td>
                                        <td>{{ $currency->symbol }}</td>
                                        <td>{{ $currency->country }}</td>
                                        <td>{{ $currency->is_active ? 'Active' : 'Inactive' }}</td>
                                        <td class="text-center">
                                            <a href="#" onclick="editCurrency(event,'{{ $currency->currency_id }}', '{{ $currency->currency_code }}', '{{ $currency->currency_name }}', '{{ $currency->symbol }}', '{{ $currency->country }}', '{{ $currency->is_active }}')" class="btn btn-primary btn-circle me-2" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form method="POST" action="{{ route('currency.delete', $currency->currency_id) }}" style="display:inline;" onsubmit="return confirmDelete('{{ $currency->currency_name }}');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-circle" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Home Currency Tab -->
        <div class="tab-pane fade" id="home-currency" role="tabpanel" aria-labelledby="home-currency-tab">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0" id="formHeader_home">{{ $homeCurrency ? 'Update Home Currency' : 'Add Home Currency' }}</h6>
                </div>
                @if (session('success'))
                    <div class="alert alert-success mx-4 my-3" id="successMessage_home">
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="form-group mx-4 my-3" id="errorMessage_home">
                        <div class="card bg-warning shadow p-3">
                            @foreach ($errors->all() as $error)
                            <div>{{ $error }}</div>
                            @endforeach
                        </div>
                    </div>
                @endif

                @if($homeCurrency)
                    <form class="card-body" action="{{ route('home.currency.update') }}" method="post" id="homeCurrencyForm">
                        @csrf
                        @method('PUT')
                        <input type="hidden" id="homeCurrencyId" name="id" value="{{ $homeCurrency->home_currency_id }}">
                        <input type="hidden" name="_method" value="PUT" id="homeCurrencyMethod">

                        <div class="row g-3">
                            <div class="col-md-6">
                                <select class="form-select form-control-user" id="currency_home" name="currency" required>
                                    <option value="" disabled>Select Currency</option>
                                    @foreach ($allCurrencies as $allCurrency)
                                    <option value="{{ $allCurrency->currency_id }}" {{ $homeCurrency->currency_id == $allCurrency->currency_id ? 'selected' : '' }}>{{ $allCurrency->currency_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="d-flex mt-3">
                            <input type="submit" style="width: 120px; height: 42px; margin-right: 12px;" value="Update" class="btn btn-primary btn-user" id="submitButton_home"/>
                            <input style="width: 120px; height: 42px;" type="reset" value="Refresh" class="btn btn-secondary btn-user" onclick="refreshHomeCurrency('{{ $homeCurrency->home_currency_id }}','{{ $homeCurrency->currency_id }}')"/>
                        </div>

                        <hr class="mt-4">
                    </form>
                @else
                    <form class="card-body" action="{{ route('home.currency.store') }}" method="post" id="homeCurrencyForm">
                        @csrf
                        <input type="hidden" id="homeCurrencyId" name="id" value="">
                        <input type="hidden" name="_method" value="POST" id="homeCurrencyMethod">

                        <div class="row g-3">
                            <div class="col-md-6">
                                <select class="form-select form-control-user" id="currency_home" name="currency" required>
                                    <option value="" disabled selected>Select Currency</option>
                                    @foreach ($allCurrencies as $allCurrency)
                                    <option value="{{ $allCurrency->currency_id }}">{{ $allCurrency->currency_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="d-flex mt-3">
                            <input type="submit" style="width: 120px; height: 42px; margin-right: 12px;" value="Create" class="btn btn-primary btn-user" id="submitButton_home"/>
                            <input style="width: 120px; height: 42px;" type="reset" value="Refresh" class="btn btn-secondary btn-user" onclick="refreshHomeCurrency('','', '')"/>
                        </div>

                        <hr class="mt-4">
                    </form>
                @endif

                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="homeCurrencyTable" width="100%" cellspacing="0">
                            <thead class="table-primary">
                                <tr>
                                    <th>Currency Symbol</th>
                                    <th>Currency Name</th>
                                    <th class="text-center" style="width: 120px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($homeCurrencies as $homeCurrency)
                                    @if($homeCurrency->home_currency_id)
                                    <tr>
                                        <td>{{ $homeCurrency->currency ? $homeCurrency->currency->symbol : '' }}</td>
                                        <td>{{ $homeCurrency->currency ? $homeCurrency->currency->currency_name : '' }}</td>
                                        <td class="text-center">
                                            <a href="#" onclick="editHomeCurrency(event,'{{ $homeCurrency->home_currency_id }}','{{ $homeCurrency->currency_id }}')" class="btn btn-primary btn-circle me-2" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form method="POST" action="{{ route('home.currency.delete', $homeCurrency->home_currency_id) }}" style="display:inline;" onsubmit="return confirmDelete('{{ $homeCurrency->currency ? $homeCurrency->currency->currency_name : '' }}');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-circle" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Daily Rates Tab -->
        <div class="tab-pane fade" id="rates" role="tabpanel" aria-labelledby="rates-tab">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0" id="formHeader_rates">Add Daily Rate</h6>
                </div>
                @if (session('success'))
                    <div class="alert alert-success mx-4 my-3" id="successMessage_rates">
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="form-group mx-4 my-3" id="errorMessage_rates">
                        <div class="card bg-warning shadow p-3">
                            @foreach ($errors->all() as $error)
                            <div>{{ $error }}</div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <form class="card-body" action="{{ route('rate.store') }}" method="post" id="ratesForm">
                    @csrf
                    <input type="hidden" id="rateId" name="id" value="">
                    <input type="hidden" name="_method" value="POST" id="rateMethod">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <select class="form-select form-control-user" id="base_currency" name="base_currency" required>
                                <option value="" disabled selected>Select Base Currency</option>
                                @foreach ($allCurrencies as $allCurrency)
                                <option value="{{ $allCurrency->currency_id }}">{{ $allCurrency->currency_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <select class="form-select form-control-user" id="target_currency" name="target_currency" required>
                                <option value="" disabled selected>Select Target Currency</option>
                                @foreach ($allCurrencies as $allCurrency)
                                <option value="{{ $allCurrency->currency_id }}">{{ $allCurrency->currency_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <input type="date" class="form-control form-control-user" id="rate_date" name="rate_date" value="{{ old('rate_date', date('Y-m-d')) }}" required>
                        </div>
                        <div class="col-md-6">
                            <input type="number" step="0.000001" class="form-control form-control-user" id="exchange_rate" placeholder="Exchange Rate" name="exchange_rate" value="{{ old('exchange_rate') }}" required>
                        </div>
                        <div class="col-md-6">
                            <input type="text" class="form-control form-control-user" id="source" placeholder="Source (optional)" name="source" value="{{ old('source') }}">
                        </div>
                    </div>

                    <div class="d-flex mt-3">
                        <input type="submit" style="width: 120px; height: 42px; margin-right: 12px;" value="Create" class="btn btn-primary btn-user" id="submitButton_rates"/>
                        <input style="width: 120px; height: 42px;" type="reset" value="Refresh" class="btn btn-secondary btn-user" onclick="refreshRate('','', '')"/>
                    </div>

                    <hr class="mt-4">
                </form>

                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="ratesTable" width="100%" cellspacing="0">
                            <thead class="table-primary">
                                <tr>
                                    <th>Rate Date</th>
                                    <th>Base Currency</th>
                                    <th>Target Currency</th>
                                    <th>Exchange Rate</th>
                                    <th>Source</th>
                                    <th class="text-center" style="width: 120px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($rates as $rate)
                                    @if($rate->rate_id)
                                    <tr>
                                        <td>{{ $rate->rate_date }}</td>
                                        <td>{{ $rate->baseCurrency ? $rate->baseCurrency->symbol . ' - ' . $rate->baseCurrency->currency_name : '' }}</td>
                                        <td>{{ $rate->targetCurrency ? $rate->targetCurrency->symbol . ' - ' . $rate->targetCurrency->currency_name : '' }}</td>
                                        <td>{{ $rate->exchange_rate }}</td>
                                        <td>{{ $rate->source }}</td>
                                        <td class="text-center">
                                            <a href="#" onclick="editRate(event,'{{ $rate->rate_id }}', '{{ $rate->base_currency_id }}', '{{ $rate->target_currency_id }}', '{{ $rate->rate_date }}', '{{ $rate->exchange_rate }}', '{{ $rate->source }}')" class="btn btn-primary btn-circle me-2" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form method="POST" action="{{ route('rate.delete', $rate->rate_id) }}" style="display:inline;" onsubmit="return confirmDelete('Rate for {{ $rate->baseCurrency ? $rate->baseCurrency->currency_name : '' }} to {{ $rate->targetCurrency ? $rate->targetCurrency->currency_name : '' }}');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-circle" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Your existing JS functions remain unchanged
    function editCurrency(event, id, currencyCode, currencyName, symbol, country, isActive) {
        event.preventDefault();
        document.getElementById('currencyId').value = id;
        document.getElementById('currency_code').value = currencyCode;
        document.getElementById('currency_name').value = currencyName;
        document.getElementById('symbol').value = symbol;
        document.getElementById('country').value = country;
        document.getElementById('is_active').checked = isActive == '1';
        document.getElementById('formHeader_currency').innerText = 'Edit Currency';
        document.getElementById('submitButton_currency').value = 'Update';
        document.getElementById('currencyForm').action = '{{ route("currency.update") }}';
        document.getElementById('currencyMethod').value = 'PUT';
    }

    function refreshCurrency(id, currencyCode, currencyName, symbol, country, isActive) {
        document.getElementById('currencyId').value = id;
        document.getElementById('currency_code').value = currencyCode;
        document.getElementById('currency_name').value = currencyName;
        document.getElementById('symbol').value = symbol;
        document.getElementById('country').value = country;
        document.getElementById('is_active').checked = isActive == '1';
        document.getElementById('formHeader_currency').innerText = 'Add Currency';
        document.getElementById('submitButton_currency').value = 'Create';
        document.getElementById('currencyForm').action = '{{ route("currency.store") }}';
        document.getElementById('currencyMethod').value = 'POST';
        hideMessages('currency');
    }

    function editHomeCurrency(event, id, currency) {
        event.preventDefault();
        document.getElementById('homeCurrencyId').value = id;
        document.getElementById('currency_home').value = currency;
        document.getElementById('formHeader_home').innerText = 'Edit Home Currency';
        document.getElementById('submitButton_home').value = 'Update';
        document.getElementById('homeCurrencyForm').action = '{{ route("home.currency.update") }}';
        document.getElementById('homeCurrencyMethod').value = 'PUT';
    }

    function refreshHomeCurrency(id, currency) {
        document.getElementById('homeCurrencyId').value = id;
        document.getElementById('currency_home').value = currency;
        document.getElementById('formHeader_home').innerText = 'Add Home Currency';
        document.getElementById('submitButton_home').value = 'Create';
        document.getElementById('homeCurrencyForm').action = '{{ route("home.currency.store") }}';
        document.getElementById('homeCurrencyMethod').value = 'POST';
        hideMessages('home');
    }
    
    function editRate(event, id, baseCurrency, targetCurrency, rateDate, exchangeRate, source) {
        event.preventDefault();
        document.getElementById('rateId').value = id;
        document.getElementById('base_currency').value = baseCurrency;
        document.getElementById('target_currency').value = targetCurrency;
        document.getElementById('rate_date').value = rateDate;
        document.getElementById('exchange_rate').value = exchangeRate;
        document.getElementById('source').value = source;
        document.getElementById('formHeader_rates').innerText = 'Edit Daily Rate';
        document.getElementById('submitButton_rates').value = 'Update';
        document.getElementById('ratesForm').action = '{{ route("rate.update") }}';
        document.getElementById('rateMethod').value = 'PUT';
    }

    function refreshRate(id, baseCurrency, targetCurrency, rateDate, exchangeRate, source) {
        document.getElementById('rateId').value = id;
        document.getElementById('base_currency').value = baseCurrency;
        document.getElementById('target_currency').value = targetCurrency;
        document.getElementById('rate_date').value = rateDate;
        document.getElementById('exchange_rate').value = exchangeRate;
        document.getElementById('source').value = source;
        document.getElementById('formHeader_rates').innerText = 'Add Daily Rate';
        document.getElementById('submitButton_rates').value = 'Create';
        document.getElementById('ratesForm').action = '{{ route("rate.store") }}';
        document.getElementById('rateMethod').value = 'POST';
        hideMessages('rates');
    }

    function confirmDelete(Name) {
        return confirm("Are you sure you want to delete: " + Name + "?");
    }

    function calculateRates() {
        const rateInput = document.getElementById('rate').value;
        const buyRateSpan = document.getElementById('calculated_buy_rate');

        if (rateInput && !isNaN(rateInput) && parseFloat(rateInput) > 0) {
            const rate = parseFloat(rateInput);
            const buyRate = rate.toFixed(4);

            buyRateSpan.textContent = buyRate;
        } else {
            buyRateSpan.textContent = '-';
        }
    }

    // Add event listener to rate input
    document.addEventListener('DOMContentLoaded', function() {
        const rateInput = document.getElementById('rate');
        if (rateInput) {
            rateInput.addEventListener('input', calculateRates);
            rateInput.addEventListener('change', calculateRates);
        }
    });

    function hideMessages(tab) {
        if (tab === 'currency') {
            const success = document.getElementById('successMessage_currency');
            const error = document.getElementById('errorMessage_currency');
            if(success) success.style.display = 'none';
            if(error) error.style.display = 'none';
        } else if (tab === 'home') {
            const success = document.getElementById('successMessage_home');
            const error = document.getElementById('errorMessage_home');
            if(success) success.style.display = 'none';
            if(error) error.style.display = 'none';
        } else if (tab === 'rates') {
            const success = document.getElementById('successMessage_rates');
            const error = document.getElementById('errorMessage_rates');
            if(success) success.style.display = 'none';
            if(error) error.style.display = 'none';
        }
    }
</script>

@endsection
