@extends('layouts.master')

@section('title', 'Sub Accounts - Prolex Law Firm')

@section('content')
<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.edit.chart-of-accounts.general-ledger') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to General Ledger
        </a>
    </div>

    <div class="row">
        <div class="col-lg-5">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-book me-2"></i>
                        {{ isset($isEdit) ? 'Edit Sub Account' : 'Add Sub Account' }}
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ isset($isEdit) ? route('subacc.edit') : route('subacc.store') }}" method="POST" id="subAccountForm">
                        @csrf
                        <input type="hidden" name="id" id="subAccountId" value="">
                        <input type="hidden" name="parent_id" value="{{ $parentAccount->account_id }}">
                        <div id="timeout">
                            @if(Session::has('success'))
                                <div class="alert alert-success">{{ Session('success') }}</div>
                            @endif
                            @if(Session::has('error'))
                                <div class="alert alert-danger">{{ Session('error') }}</div>
                            @endif
                        </div>

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                @foreach ($errors->all() as $error)
                                    <div>{{ $error }}</div>
                                @endforeach
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><strong>Main Account Code:</strong></label>
                                <input id="mainAccountCode" class="form-control" type="text" name="main_account_code"
                                    value="{{ old('main_account_code', $parentCodeParts[0] ?? '') }}" required />
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><strong>Main Account Name:</strong></label>
                                <input id="mainAccountName" class="form-control" type="text" name="main_account_name"
                                    value="{{ old('main_account_name', $parentAccount->name ?? '') }}" readonly />
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><strong>Sub Account Code:</strong></label>
                                <input id="subAccountCode" class="form-control" type="text" name="sub_account_code"
                                    value="{{ old('sub_account_code', '') }}" required />
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><strong>Sub Account Name:</strong></label>
                                <input id="subAccountName" class="form-control" type="text" name="account_name"
                                    value="{{ old('account_name', '') }}" required />
                            </div>
                        </div>

                        <input type="hidden" name="sub_account_number" id="subAccountNumber" class="form-control" value="{{ old('sub_account_number', '') }}" />

                        <div class="d-flex justify-content-end mt-4">
                            <input id="submitButton" type="submit" class="btn btn-primary me-2"
                                value="{{ isset($isEdit) ? 'UPDATE' : 'SUBMIT' }}">
                            <input type="button" class="btn btn-outline-secondary" value="REFRESH"
                                onclick="resetSubAccountForm()">
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-7 mt-4 mt-lg-0">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-list me-2"></i> Sub Accounts</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Main Account Code</th>
                                    <th>Main Account Name</th>
                                    <th>Sub Account Code</th>
                                    <th>Sub Account Name</th>
                                    <th style="width:100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($subAccounts ?? [] as $subAccount)
                                    <tr>
                                        <td>{{ explode('.', $subAccount->code)[0] ?? '' }}</td>
                                        <td>{{ $parentAccount->name }}</td>
                                        <td>{{ explode('.', $subAccount->code)[1] ?? '' }}</td>
                                        <td>{{ $subAccount->name }}</td>
                                        <td class="text-center">
                                            <a href="#" class="btn btn-sm btn-primary"
                                                onclick="editSubAccount(event,
                                                    '{{ $subAccount->account_id }}',
                                                    '{{ explode('.', $subAccount->code)[0] ?? '' }}',
                                                    '{{ explode('.', $subAccount->code)[1] ?? '' }}',
                                                    '{{ $subAccount->name }}'
                                                )">
                                                <i class="fas fa-edit"></i>
                                            </a>

                                            <button class="btn btn-sm btn-danger deleteBtn"
                                                    data-id="{{ $subAccount->account_id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this sub account?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" action="">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function editSubAccount(event, id, mainCode, mainName, subCode, subName) {
        event.preventDefault();
        document.getElementById('subAccountId').value = id;
        document.getElementById('mainAccountCode').value = mainCode;
        document.getElementById('mainAccountName').value = mainName;
        document.getElementById('subAccountCode').value = subCode;
        document.getElementById('subAccountName').value = subName;

        // Set hidden fields
        document.querySelector('input[name="sub_account_number"]').value = subCode;

        document.querySelector('.card-header h5').innerHTML = '<i class="fas fa-book me-2"></i> Edit Sub Account';
        document.getElementById('submitButton').value = 'UPDATE';
        document.getElementById('subAccountForm').action = '{{ route("subacc.edit") }}';

        if (!document.querySelector('input[name="isEdit"]')) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'isEdit';
            input.value = '1';
            document.getElementById('subAccountForm').appendChild(input);
        }
    }

    function resetSubAccountForm() {
        window.location.href = "{{ route('subacc.add', $parentAccount->account_id) }}";
    }

    document.addEventListener('DOMContentLoaded', function() {
        const deleteButtons = document.querySelectorAll('.deleteBtn');
        const deleteForm = document.getElementById('deleteForm');
        const modal = new bootstrap.Modal(document.getElementById('deleteConfirmModal'));

        deleteButtons.forEach(button => {
            button.addEventListener('click', function() {
                const accountId = this.getAttribute('data-id');
                const actionUrl = "{{ route('subacc.delete', ['id' => ':id']) }}".replace(':id', accountId);

                deleteForm.action = actionUrl;
                modal.show();
            });
        });

        // Sync hidden fields with visible fields before submit
        document.getElementById('subAccountForm').addEventListener('submit', function() {
            // Set sub_account_number to match sub_account_code
            document.getElementById('subAccountNumber').value = document.getElementById('subAccountCode').value;
        });
    });
</script>

<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endsection

