@extends('layouts.master')

@section('title', 'Supplier Accounts - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .add-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .search-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    #searchInput {
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        width: 300px;
    }

    #searchInput:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .table-container {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
        font-size: 0.95rem;
    }

    td {
        color: #4b5563;
        font-size: 0.9rem;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin-right: 5px;
    }

    .view-btn {
        background-color: #10b981;
        color: white;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .no-suppliers {
        text-align: center;
        color: #6b7280;
        font-style: italic;
    }
</style>

<div class="container">
    <h1>Supplier Accounts</h1>

    <div class="actions">
        <a href="{{ route('modules.edit.suppliers.accounts.create') }}" class="add-btn">Add Supplier Account</a>
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search supplier accounts...">
            <button id="filterToggle" class="add-btn">Show Filters</button>
            <button id="selectAll" class="add-btn">Select All</button>
            <button id="bulkDelete" class="add-btn" style="background-color: #ef4444;">Bulk Delete</button>
        </div>
    </div>

    <div id="filters" style="display: none; margin-bottom: 20px;">
        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
            <select id="categoryFilter">
                <option value="">All Categories</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}">{{ $category->category_name }}</option>
                @endforeach
            </select>
            <select id="areaFilter">
                <option value="">All Areas</option>
                @foreach($areas as $area)
                    <option value="{{ $area->id }}">{{ $area->area_name }}</option>
                @endforeach
            </select>
            <select id="ageAnalysisFilter">
                <option value="">All Age Analyses</option>
                @foreach($ageAnalyses as $ageAnalysis)
                    <option value="{{ $ageAnalysis->id }}">{{ $ageAnalysis->name }}</option>
                @endforeach
            </select>
            <button id="clearFilters" class="add-btn">Clear Filters</button>
        </div>
    </div>

    <div class="table-container">
        <table id="suppliersTable">
            <thead>
                <tr>
                    <th><input type="checkbox" id="selectAllCheckbox"></th>
                    <th>Supplier Code</th>
                    <th>Supplier Name</th>
                    <th>Contact Person</th>
                    <th>Contact 1</th>
                    <th>Contact 2</th>
                    <th>Email</th>
                    <th>Physical Address</th>
                    <th>Category</th>
                    <th>Age Analysis</th>
                    <th>Area</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($suppliers as $supplier)
                <tr>
                    <td><input type="checkbox" class="row-checkbox" value="{{ $supplier->supplier_id }}"></td>
                    <td>{{ $supplier->supplier_code }}</td>
                    <td>{{ $supplier->supplier_name }}</td>
                    <td>{{ $supplier->contact_person ?: 'N/A' }}</td>
                    <td>{{ $supplier->contact_1 ?: 'N/A' }}</td>
                    <td>{{ $supplier->contact_2 ?: 'N/A' }}</td>
                    <td>{{ $supplier->email ?: 'N/A' }}</td>
                    <td>{{ $supplier->address ?: 'N/A' }}</td>
                    <td>{{ $supplier->category->category_name ?? 'N/A' }}</td>
                    <td>{{ $supplier->ageAnalysis->name ?? 'N/A' }}</td>
                    <td>{{ $supplier->area->area_name ?? 'N/A' }}</td>
                    <td>
                        <a href="{{ route('modules.edit.suppliers.accounts.show', $supplier->supplier_id) }}" class="action-btn view-btn">View</a>
                        <a href="{{ route('modules.edit.suppliers.accounts.edit', $supplier->supplier_id) }}" class="action-btn edit-btn">Edit</a>
                        <form action="{{ route('modules.edit.suppliers.accounts.destroy', $supplier->supplier_id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this supplier account?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="12" class="no-suppliers">No supplier accounts found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        filterSuppliers();
    });

    // Filter toggle
    document.getElementById('filterToggle').addEventListener('click', function() {
        const filters = document.getElementById('filters');
        filters.style.display = filters.style.display === 'none' ? 'block' : 'none';
    });

    // Filter change events
    document.getElementById('categoryFilter').addEventListener('change', filterSuppliers);
    document.getElementById('areaFilter').addEventListener('change', filterSuppliers);
    document.getElementById('ageAnalysisFilter').addEventListener('change', filterSuppliers);

    // Clear filters
    document.getElementById('clearFilters').addEventListener('click', function() {
        document.getElementById('searchInput').value = '';
        document.getElementById('categoryFilter').value = '';
        document.getElementById('areaFilter').value = '';
        document.getElementById('ageAnalysisFilter').value = '';
        filterSuppliers();
    });

    // Select All functionality
    document.getElementById('selectAll').addEventListener('click', function() {
        const checkboxes = document.querySelectorAll('.row-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = true;
        });
    });

    // Bulk Delete functionality
    document.getElementById('bulkDelete').addEventListener('click', function() {
        const selectedCheckboxes = document.querySelectorAll('.row-checkbox:checked');
        if (selectedCheckboxes.length === 0) {
            alert('Please select at least one supplier account to delete.');
            return;
        }

        if (confirm(`Are you sure you want to delete ${selectedCheckboxes.length} supplier account(s)?`)) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '{{ route("suppliers.bulk-destroy") }}';
            form.style.display = 'none';

            selectedCheckboxes.forEach(checkbox => {
                const csrfInput = document.createElement('input');
                csrfInput.type = 'hidden';
                csrfInput.name = '_token';
                csrfInput.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

                const methodInput = document.createElement('input');
                methodInput.type = 'hidden';
                methodInput.name = '_method';
                methodInput.value = 'DELETE';

                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'supplier_ids[]';
                idInput.value = checkbox.value;

                form.appendChild(csrfInput);
                form.appendChild(methodInput);
                form.appendChild(idInput);
            });

            document.body.appendChild(form);
            form.submit();
        }
    });

    // Select All checkbox functionality
    document.getElementById('selectAllCheckbox').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.row-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    function filterSuppliers() {
        const searchTerm = document.getElementById('searchInput').value.toLowerCase();
        const categoryFilter = document.getElementById('categoryFilter').value;
        const areaFilter = document.getElementById('areaFilter').value;
        const ageAnalysisFilter = document.getElementById('ageAnalysisFilter').value;
        const rows = document.querySelectorAll('#suppliersTable tbody tr');

        rows.forEach(row => {
            if (row.cells.length > 1) { // Skip the "no suppliers" row
                const text = row.textContent.toLowerCase();
                const category = row.cells[9].textContent; // Category column (adjusted for checkbox)
                const area = row.cells[11].textContent; // Area column (adjusted for checkbox)
                const ageAnalysis = row.cells[10].textContent; // Age Analysis column (adjusted for checkbox)

                const matchesSearch = text.includes(searchTerm);
                const matchesCategory = !categoryFilter || category.includes(categoryFilter);
                const matchesArea = !areaFilter || area.includes(areaFilter);
                const matchesAgeAnalysis = !ageAnalysisFilter || ageAnalysis.includes(ageAnalysisFilter);

                row.style.display = matchesSearch && matchesCategory && matchesArea && matchesAgeAnalysis ? '' : 'none';
            }
        });
    }
</script>

@endsection

