@extends('layouts.master')

@section('title', 'Add Supplier Area - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .refresh-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        text-decoration: none;
        display: inline-block;
    }

    .submit-btn:hover, .refresh-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Add Supplier Area</h1>

    <form id="supplierAreaForm" action="{{ route('modules.edit.suppliers.area.store') }}" method="POST">
        @csrf

        <div class="form-section">
            <div class="section-title">Supplier Area Information</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="area_code" class="required">Area Code</label>
                    <input type="text" id="area_code" name="area_code" placeholder="Enter area code" required>
                </div>

                <div class="form-group">
                    <label for="area_name" class="required">Area Name</label>
                    <input type="text" id="area_name" name="area_name" placeholder="Enter area name" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="city" class="required">City</label>
                    <input type="text" id="city" name="city" placeholder="Enter city" required>
                </div>

                <div class="form-group">
                    <label for="country" class="required">Country</label>
                    <input type="text" id="country" name="country" placeholder="Enter country" required>
                </div>
            </div>

            <div class="form-group">
                <label for="specific_location">Specific Location</label>
                <textarea id="specific_location" name="specific_location" rows="4" placeholder="Enter specific location"></textarea>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('modules.edit.suppliers.area') }}" class="back-btn">Back to Supplier Areas</a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">Refresh</button>
                <button type="submit" class="submit-btn">Save</button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('supplierAreaForm').reset();
    }

    document.getElementById('supplierAreaForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = 'Saving...';
    });
</script>

@endsection

