@extends('layouts.master')

@section('title', 'View Supplier Area - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 600px;
        margin: 40px auto;
        background-color: #f0f9ff; /* light blue */
        padding: 20px 30px 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af; /* blue-900 */
        margin-bottom: 25px;
        user-select: none;
    }

    .detail-group {
        margin-bottom: 20px;
    }

    .detail-label {
        font-weight: 600;
        color: #1e40af;
        margin-bottom: 5px;
        user-select: none;
    }

    .detail-value {
        background-color: #ffffff;
        padding: 10px 15px;
        border: 2px solid #3b82f6;
        border-radius: 8px;
        font-size: 1em;
        color: #374151;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 30px;
        border: none;
        border-radius: 8px;
        font-size: 1.1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease;
        text-decoration: none;
        display: inline-block;
        user-select: none;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .back-btn {
        background-color: #6b7280;
        color: white;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }
</style>

<div class="container">
    <h1>Supplier Area Details</h1>

    <div class="detail-group">
        <div class="detail-label">Area Code:</div>
        <div class="detail-value">{{ $supplierArea->area_code }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Area Name:</div>
        <div class="detail-value">{{ $supplierArea->area_name }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">City:</div>
        <div class="detail-value">{{ $supplierArea->city }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Country:</div>
        <div class="detail-value">{{ $supplierArea->country }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Specific Location:</div>
        <div class="detail-value">{{ $supplierArea->specific_location ?: 'N/A' }}</div>
    </div>

    <div class="button-group">
        <a href="{{ route('modules.edit.suppliers.area.edit', $supplierArea->id) }}" class="btn edit-btn">Edit</a>
        <a href="{{ route('modules.edit.suppliers') }}" class="btn back-btn">Back to List</a>
    </div>
</div>
@endsection

