@extends('layouts.master')

@section('title', 'Supplier Areas - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .add-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .search-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    #searchInput {
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        width: 300px;
    }

    #searchInput:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .table-container {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
        font-size: 0.95rem;
    }

    td {
        color: #4b5563;
        font-size: 0.9rem;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin-right: 5px;
    }

    .view-btn {
        background-color: #10b981;
        color: white;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .no-areas {
        text-align: center;
        color: #6b7280;
        font-style: italic;
    }
</style>

<div class="container">
    <h1>Supplier Areas</h1>

    <div class="actions">
        <a href="{{ route('modules.edit.suppliers.area.create') }}" class="add-btn">Add Supplier Area</a>
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search supplier areas...">
        </div>
    </div>

    <div class="table-container">
        <table id="supplierAreasTable">
            <thead>
                <tr>
                    <th>Area Code</th>
                    <th>Area Name</th>
                    <th>City</th>
                    <th>Country</th>
                    <th>Specific Location</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($supplierAreas as $area)
                <tr>
                    <td>{{ $area->area_code }}</td>
                    <td>{{ $area->area_name }}</td>
                    <td>{{ $area->city }}</td>
                    <td>{{ $area->country }}</td>
                    <td>{{ $area->specific_location ?: 'N/A' }}</td>
                    <td>
                        <a href="{{ route('modules.edit.suppliers.area.show', $area->area_id) }}" class="action-btn view-btn">View</a>
                        <a href="{{ route('modules.edit.suppliers.area.edit', $area->area_id) }}" class="action-btn edit-btn">Edit</a>
                        <form action="{{ route('modules.edit.suppliers.area.destroy', $area->area_id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this supplier area?')">Delete</button>
                        </form>
                  </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="no-areas">No supplier areas found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        const rows = document.querySelectorAll('#supplierAreasTable tbody tr');

        rows.forEach(row => {
            if (row.cells.length > 1) { // Skip the "no areas" row
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            }
        });
    });   
</script>

@endsection

