@extends('layouts.master')

@section('title', 'View Supplier Category - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .details-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .detail-row {
        display: flex;
        margin-bottom: 15px;
        padding-bottom: 15px;
        border-bottom: 1px solid #e2e8f0;
    }

    .detail-row:last-child {
        border-bottom: none;
        margin-bottom: 0;
        padding-bottom: 0;
    }

    .detail-label {
        font-weight: 600;
        color: #4a5568;
        width: 200px;
        flex-shrink: 0;
    }

    .detail-value {
        color: #2d3748;
        flex: 1;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .edit-btn, .back-btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .edit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
    }

    .edit-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }
</style>

<div class="container">
    <h1>Supplier Category Details</h1>

    <div class="details-section">
        <div class="detail-row">
            <div class="detail-label">Category Code:</div>
            <div class="detail-value">{{ $supplierCategory->category_code }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Category Name:</div>
            <div class="detail-value">{{ $supplierCategory->category_name }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Description:</div>
            <div class="detail-value">{{ $supplierCategory->description ?: 'N/A' }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Created At:</div>
            <div class="detail-value">{{ $supplierCategory->created_at->format('d M Y, H:i') }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Updated At:</div>
            <div class="detail-value">{{ $supplierCategory->updated_at->format('d M Y, H:i') }}</div>
        </div>
    </div>

    <div class="button-group">
        <a href="{{ route('modules.edit.suppliers.categories') }}" class="back-btn">Back to Supplier Categories</a>
        <a href="{{ route('modules.edit.suppliers.categories.edit', $supplierCategory->category_code) }}" class="edit-btn">Edit Category</a>
    </div>
</div>

@endsection

