@extends('layouts.master')

@section('title', 'View Supplier - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .info-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .info-row {
        display: flex;
        margin-bottom: 15px;
    }

    .info-label {
        font-weight: 600;
        color: #4a5568;
        width: 200px;
        flex-shrink: 0;
    }

    .info-value {
        color: #2d3748;
        flex: 1;
    }

    .button-group {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 30px;
    }

    .edit-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .edit-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
    }

    .edit-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .edit-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>View Supplier</h1>

    <div class="info-section">
        <div class="section-title">Supplier Details</div>

        <div class="info-row">
            <div class="info-label">Supplier Code:</div>
            <div class="info-value">{{ $supplier->supplier_code }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Full Name:</div>
            <div class="info-value">{{ $supplier->full_name }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Supplier Name:</div>
            <div class="info-value">{{ $supplier->supplier_name }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Date Of Registration:</div>
            <div class="info-value">{{ $supplier->date_of_registration }}</div>
        </div>
    </div>

    <div class="info-section">
        <div class="section-title">Contact Details</div>

        <div class="info-row">
            <div class="info-label">Address:</div>
            <div class="info-value">{{ $supplier->address }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Mobile:</div>
            <div class="info-value">{{ $supplier->mobile }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Email:</div>
            <div class="info-value">{{ $supplier->email }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Contact Person:</div>
            <div class="info-value">{{ $supplier->contact_person ?: 'N/A' }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Contact 1:</div>
            <div class="info-value">{{ $supplier->contact_1 ?: 'N/A' }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Contact 2:</div>
            <div class="info-value">{{ $supplier->contact_2 ?: 'N/A' }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Currency:</div>
            <div class="info-value">{{ $supplier->currency->name }} ({{ $supplier->currency->symbol }})</div>
        </div>
    </div>

    <div class="info-section">
        <div class="section-title">Additional Details</div>

        <div class="info-row">
            <div class="info-label">Category:</div>
            <div class="info-value">{{ $supplier->category ? $supplier->category->name : 'N/A' }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Age Analysis:</div>
            <div class="info-value">{{ $supplier->ageAnalysis ? $supplier->ageAnalysis->name : 'N/A' }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Area:</div>
            <div class="info-value">{{ $supplier->area ? $supplier->area->name : 'N/A' }}</div>
        </div>
    </div>

    <div class="info-section">
        <div class="section-title">Timestamps</div>

        <div class="info-row">
            <div class="info-label">Created At:</div>
            <div class="info-value">{{ $supplier->created_at->format('Y-m-d H:i:s') }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Updated At:</div>
            <div class="info-value">{{ $supplier->updated_at->format('Y-m-d H:i:s') }}</div>
        </div>
    </div>

    <div class="button-group">
        <a href="{{ route('suppliers.edit', $supplier->id) }}" class="edit-btn">Edit</a>
        <a href="{{ route('suppliers.index') }}" class="back-btn">Back to Suppliers</a>
    </div>
</div>

@endsection

