@extends('layouts.master')

@section('title', 'Create New Assignment - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #ffffff;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2rem;
        font-weight: 700;
    }

    .form-container {
        background: #f8fafc;
        padding: 25px;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 20px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group.full-width {
        grid-column: 1 / -1;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #374151;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .checkbox-group {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        margin-top: 10px;
    }

    .checkbox-item {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .checkbox-item input[type="checkbox"] {
        width: auto;
        margin: 0;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 1px solid #e2e8f0;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 6px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
    }

    .required {
        color: #ef4444;
    }
</style>

<div class="container">
    <h1>Create New Assignment</h1>

    <form action="{{ route('modules.processing.assignment.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="form-container">
            <div class="form-group full-width">
                <label for="task_title">Task Title <span class="required">*</span></label>
                <input type="text" id="task_title" name="task_title" placeholder="Enter task title" value="{{ old('task_title') }}" required>
                @error('task_title')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="assigned_lawyers">Assigned Lawyer(s) <span class="required">*</span></label>
                    <select id="assigned_lawyers" name="assigned_lawyers[]" multiple required>
                        <option value="">Select Lawyers</option>
                        <option value="john-doe" {{ in_array('john-doe', old('assigned_lawyers', [])) ? 'selected' : '' }}>John Doe - Senior Partner</option>
                        <option value="jane-smith" {{ in_array('jane-smith', old('assigned_lawyers', [])) ? 'selected' : '' }}>Jane Smith - Associate</option>
                        <option value="bob-johnson" {{ in_array('bob-johnson', old('assigned_lawyers', [])) ? 'selected' : '' }}>Bob Johnson - Paralegal</option>
                        <option value="alice-brown" {{ in_array('alice-brown', old('assigned_lawyers', [])) ? 'selected' : '' }}>Alice Brown - Secretary</option>
                    </select>
                    @error('assigned_lawyers')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="consultation_status">Consultation Status <span class="required">*</span></label>
                    <select id="consultation_status" name="consultation_status" required>
                        <option value="">Select Status</option>
                        <option value="consulted" {{ old('consultation_status') == 'consulted' ? 'selected' : '' }}>Consulted</option>
                        <option value="not-consulted" {{ old('consultation_status') == 'not-consulted' ? 'selected' : '' }}>Not Consulted</option>
                        <option value="pending-review" {{ old('consultation_status') == 'pending-review' ? 'selected' : '' }}>Pending Review</option>
                    </select>
                    @error('consultation_status')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="deadline">Deadline / Due Date <span class="required">*</span></label>
                    <input type="date" id="deadline" name="deadline" value="{{ old('deadline') }}" required>
                    @error('deadline')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="priority">Priority <span class="required">*</span></label>
                    <select id="priority" name="priority" required>
                        <option value="">Select Priority</option>
                        <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                        <option value="medium" {{ old('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                        <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                    </select>
                    @error('priority')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>
            </div>

            <div class="form-group full-width">
                <label for="description">Description</label>
                <textarea id="description" name="description" placeholder="Task description and detailed instructions">{{ old('description') }}</textarea>
                @error('description')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="follow_up_reminder">Follow-Up Reminder</label>
                    <div class="checkbox-item">
                        <input type="checkbox" id="follow_up_reminder" name="follow_up_reminder" value="1" {{ old('follow_up_reminder') ? 'checked' : '' }}>
                        <label for="follow_up_reminder" style="margin-bottom: 0; font-weight: normal;">Enable reminder notifications</label>
                    </div>
                    @error('follow_up_reminder')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="attachments">Attachments / Files</label>
                    <input type="file" id="attachments" name="attachments[]" multiple>
                    <small class="text-gray-500">Select multiple files if needed</small>
                    @error('attachments')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('modules.processing.assignment.list') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Assignment</button>
        </div>
    </form>
</div>
@endsection

