@extends('layouts.master')

@section('title', 'Assignment Management - Prolex Law Firm')

@section('content')
<style>
    .assignments-container {
        max-width: 1400px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .controls-section {
        background: white;
        padding: 25px;
        border-radius: 10px;
        margin-bottom: 25px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .filters-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
        margin-bottom: 20px;
    }

    .search-box {
        grid-column: 1 / -1;
        max-width: 400px;
        margin: 0 auto;
    }

    .search-input {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #d1d5db;
        border-radius: 8px;
        font-size: 1rem;
    }

    .search-input:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .assignments-table {
        background: white;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .table-header {
        background: linear-gradient(135deg, #1e40af, #3b82f6);
        color: white;
        padding: 20px;
        font-weight: 600;
        font-size: 1.1rem;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
    }

    tr:hover {
        background-color: #f1f5f9;
    }

    .assignment-title {
        font-weight: 600;
        color: #1e40af;
        text-decoration: none;
    }

    .assignment-title:hover {
        text-decoration: underline;
    }

    .priority-badge {
        display: inline-flex;
        align-items: center;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .priority-low {
        background-color: #dcfce7;
        color: #166534;
    }

    .priority-medium {
        background-color: #fef3c7;
        color: #92400e;
    }

    .priority-high {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-pending {
        background-color: #fef3c7;
        color: #92400e;
    }

    .status-in_progress {
        background-color: #dbeafe;
        color: #1e40af;
    }

    .status-completed {
        background-color: #dcfce7;
        color: #166534;
    }

    .status-cancelled {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .task-type-badge {
        background-color: #e0e7ff;
        color: #3730a3;
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .lawyer-name {
        font-weight: 500;
        color: #374151;
    }

    .client-name {
        color: #6b7280;
        font-size: 0.9rem;
    }

    .due-date {
        font-weight: 500;
    }

    .overdue {
        color: #dc2626;
        font-weight: 600;
    }

    .actions-cell {
        white-space: nowrap;
    }

    .btn {
        padding: 6px 12px;
        border: none;
        border-radius: 6px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 4px;
        margin-right: 5px;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
    }

    .btn-success {
        background-color: #10b981;
        color: white;
    }

    .btn-success:hover {
        background-color: #059669;
    }

    .btn-warning {
        background-color: #f59e0b;
        color: white;
    }

    .btn-warning:hover {
        background-color: #d97706;
    }

    .btn-danger {
        background-color: #ef4444;
        color: white;
    }

    .btn-danger:hover {
        background-color: #dc2626;
    }

    .btn-info {
        background-color: #06b6d4;
        color: white;
    }

    .btn-info:hover {
        background-color: #0891b2;
    }

    .pagination {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-top: 30px;
        gap: 10px;
    }

    .pagination a, .pagination span {
        padding: 8px 12px;
        border: 1px solid #d1d5db;
        border-radius: 6px;
        text-decoration: none;
        color: #374151;
        transition: all 0.3s ease;
    }

    .pagination a:hover {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .pagination .current {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .stats-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 25px;
    }

    .stat-card {
        background: white;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .stat-number {
        font-size: 2.5rem;
        font-weight: 700;
        color: #1e40af;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6b7280;
        font-size: 0.9rem;
        font-weight: 500;
    }

    .no-assignments {
        text-align: center;
        padding: 60px 20px;
        color: #6b7280;
    }

    .no-assignments i {
        font-size: 4rem;
        color: #d1d5db;
        margin-bottom: 20px;
    }

    .create-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background-color: #10b981;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .create-button:hover {
        background-color: #059669;
        transform: translateY(-1px);
    }

    @media (max-width: 768px) {
        .filters-row {
            grid-template-columns: 1fr;
        }

        .search-box {
            max-width: 100%;
        }

        table {
            font-size: 0.9rem;
        }

        th, td {
            padding: 10px;
        }

        .assignments-container {
            margin: 20px;
            padding: 20px;
        }
    }
</style>

<div class="assignments-container">
    <h1><i class="fas fa-tasks"></i>Assignment Management</h1>

    <!-- Statistics Cards -->
    <div class="stats-section">
        <div class="stat-card">
            <div class="stat-number">{{ $assignments->total() }}</div>
            <div class="stat-label">Total Assignments</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">{{ $assignments->getCollection()->where('status', 'pending')->count() }}</div>
            <div class="stat-label">Pending</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">{{ $assignments->getCollection()->where('status', 'in_progress')->count() }}</div>
            <div class="stat-label">In Progress</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">{{ $assignments->getCollection()->where('status', 'completed')->count() }}</div>
            <div class="stat-label">Completed</div>
        </div>
    </div>

    <!-- Controls Section -->
    <div class="controls-section">
        <div style="margin-bottom: 20px; display: flex; gap: 15px; flex-wrap: wrap;">
            <a href="{{ route('modules.processing.assignment.add') }}" class="create-button">
                <i class="fas fa-plus"></i>
                Create New Assignment
            </a>
            <a href="{{ route('modules.processing.assignment.reports') }}" class="create-button" style="background-color: #8b5cf6;">
                <i class="fas fa-chart-bar"></i>
                View Reports
            </a>
        </div>

        <form method="GET" action="{{ route('modules.processing.assignment.list') }}" id="filterForm">
            <div class="filters-row">
                <div class="search-box">
                    <input type="text" name="search" class="search-input"
                           placeholder="Search assignments by title, lawyer, or client..."
                           value="{{ request('search') }}">
                </div>

                <select name="status" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Statuses</option>
                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                </select>

                <select name="priority" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Priorities</option>
                    <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Low</option>
                    <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                    <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>High</option>
                </select>

                <select name="lawyer_id" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Lawyers</option>
                    @foreach($lawyers as $lawyer)
                        <option value="{{ $lawyer->id }}" {{ request('lawyer_id') == $lawyer->id ? 'selected' : '' }}>
                            {{ $lawyer->first_name }} {{ $lawyer->last_name }}
                        </option>
                    @endforeach
                </select>

                <select name="task_type" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Task Types</option>
                    @foreach($taskTypes as $type)
                        <option value="{{ $type }}" {{ request('task_type') == $type ? 'selected' : '' }}>
                            {{ ucwords(str_replace('_', ' ', $type)) }}
                        </option>
                    @endforeach
                </select>

                <input type="date" name="start_date" value="{{ request('start_date') }}"
                       onchange="document.getElementById('filterForm').submit()" placeholder="Start Date">

                <input type="date" name="end_date" value="{{ request('end_date') }}"
                       onchange="document.getElementById('filterForm').submit()" placeholder="End Date">
            </div>
        </form>
    </div>

    <!-- Assignments Table -->
    <div class="assignments-table">
        @if($assignments->count() > 0)
            <div class="table-header">
                <i class="fas fa-list"></i>
                Assignments List ({{ $assignments->total() }} total)
            </div>

            <table>
                <thead>
                    <tr>
                        <th>Assignment</th>
                        <th>Lawyer</th>
                        <th>Client</th>
                        <th>Task Type</th>
                        <th>Priority</th>
                        <th>Status</th>
                        <th>Due Date</th>
                        <th>Progress</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($assignments as $assignment)
                        <tr>
                            <td>
                                <a href="{{ route('modules.processing.assignment.show', $assignment->id) }}"
                                   class="assignment-title">
                                    {{ $assignment->assignment_title }}
                                </a>
                                <div class="client-name">
                                    @if($assignment->client)
                                        {{ $assignment->client->first_name }} {{ $assignment->client->last_name }}
                                    @else
                                        No client assigned
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div class="lawyer-name">
                                    @if($assignment->lawyer)
                                        {{ $assignment->lawyer->first_name }} {{ $assignment->lawyer->last_name }}
                                    @else
                                        No Lawyer Assigned
                                    @endif
                                </div>
                            </td>
                            <td>
                                @if($assignment->client)
                                    {{ $assignment->client->first_name }} {{ $assignment->client->last_name }}
                                @else
                                    <span style="color: #9ca3af;">N/A</span>
                                @endif
                            </td>
                            <td>
                                <span class="task-type-badge">
                                    {{ ucwords(str_replace('_', ' ', $assignment->task_type)) }}
                                </span>
                            </td>
                            <td>
                                <span class="priority-badge priority-{{ $assignment->priority }}">
                                    {{ ucfirst($assignment->priority) }}
                                </span>
                            </td>
                            <td>
                                <span class="status-badge status-{{ $assignment->status }}">
                                    {{ ucfirst(str_replace('_', ' ', $assignment->status)) }}
                                </span>
                            </td>
                            <td>
                                <div class="due-date {{ $assignment->due_datetime < now() && $assignment->status !== 'completed' ? 'overdue' : '' }}">
                                    {{ $assignment->due_datetime->format('M d, Y') }}
                                    @if($assignment->due_datetime->format('H:i') !== '23:59')
                                        <br><small>{{ $assignment->due_datetime->format('H:i') }}</small>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div style="display: flex; align-items: center; gap: 8px;">
                                    <div style="flex: 1; background: #e2e8f0; border-radius: 10px; height: 8px;">
                                        <div style="width: {{ $assignment->progress_percentage }}%; background: {{ $assignment->progress_percentage == 100 ? '#10b981' : '#3b82f6' }}; height: 100%; border-radius: 10px; transition: width 0.3s ease;"></div>
                                    </div>
                                    <span style="font-size: 0.8rem; color: #6b7280; min-width: 35px;">
                                        {{ $assignment->progress_percentage }}%
                                    </span>
                                </div>
                            </td>
                            <td class="actions-cell">
                                <a href="{{ route('modules.processing.assignment.show', $assignment->id) }}"
                                   class="btn btn-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('modules.processing.assignment.edit', $assignment->id) }}"
                                   class="btn btn-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($assignment->status !== 'completed')
                                    <button type="button" class="btn btn-primary" title="Re-assign"
                                            onclick="openReassignModal({{ $assignment->id }}, '{{ $assignment->lawyer ? $assignment->lawyer->first_name . ' ' . $assignment->lawyer->last_name : 'No Lawyer Assigned' }}')">
                                        <i class="fas fa-user-friends"></i>
                                    </button>
                                    <form method="POST" action="{{ route('modules.processing.assignment.delete', $assignment->id) }}"
                                          style="display: inline;"
                                          onsubmit="return confirm('Are you sure you want to delete this assignment?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <!-- Pagination -->
            <div class="pagination">
                {{ $assignments->appends(request()->query())->links() }}
            </div>
        @else
            <div class="no-assignments">
                <i class="fas fa-tasks"></i>
                <h3>No Assignments Found</h3>
                <p>No assignments match your current filters.</p>
                <a href="{{ route('modules.processing.assignment.add') }}" class="create-button">
                    <i class="fas fa-plus"></i>
                    Create Your First Assignment
                </a>
            </div>
        @endif
    </div>
</div>

<script>
    // Auto-submit form when search input changes
    document.querySelector('.search-input').addEventListener('input', function() {
        clearTimeout(this.searchTimeout);
        this.searchTimeout = setTimeout(() => {
            document.getElementById('filterForm').submit();
        }, 500);
    });

    // Add loading state to form submissions
    document.getElementById('filterForm').addEventListener('submit', function() {
        const submitBtns = document.querySelectorAll('button[type="submit"]');
        submitBtns.forEach(btn => {
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading...';
        });
    });

    // Reset filters
    function resetFilters() {
        const form = document.getElementById('filterForm');
        const inputs = form.querySelectorAll('input, select');
        inputs.forEach(input => {
            if (input.type === 'text' || input.type === 'date') {
                input.value = '';
            } else if (input.tagName === 'SELECT') {
                input.selectedIndex = 0;
            }
        });
        form.submit();
    }

    // Re-assign modal functions
    function openReassignModal(assignmentId, currentLawyerName) {
        document.getElementById('reassignAssignmentId').value = assignmentId;
        document.getElementById('currentLawyerName').textContent = currentLawyerName;
        document.getElementById('reassignForm').action = '/modules/processing/assignment/' + assignmentId + '/reassign';
        document.getElementById('reassignModal').style.display = 'block';
    }

    function closeReassignModal() {
        document.getElementById('reassignModal').style.display = 'none';
    }

    // Close modal when clicking outside
    window.onclick = function(event) {
        const modal = document.getElementById('reassignModal');
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    }
</script>

<!-- Re-assign Modal -->
<div id="reassignModal" class="modal" style="display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0,0,0,0.4);">
    <div class="modal-content" style="background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 80%; max-width: 500px; border-radius: 10px;">
        <span class="close" onclick="closeReassignModal()" style="color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer;">&times;</span>
        <h2>Re-assign Assignment</h2>
        <p>Current Lawyer: <strong id="currentLawyerName"></strong></p>
        <form id="reassignForm" method="POST">
            @csrf
            <input type="hidden" name="assignment_id" id="reassignAssignmentId">
            <div style="margin-bottom: 20px;">
                <label for="new_lawyer_id" style="display: block; margin-bottom: 8px; font-weight: 600;">Select New Lawyer:</label>
                <select name="new_lawyer_id" id="new_lawyer_id" required style="width: 100%; padding: 10px; border: 1px solid #d1d5db; border-radius: 5px;">
                    <option value="">Choose a lawyer...</option>
                    @foreach($lawyers as $lawyer)
                        <option value="{{ $lawyer->id }}">{{ $lawyer->first_name }} {{ $lawyer->last_name }}</option>
                    @endforeach
                </select>
            </div>
            <div style="text-align: right;">
                <button type="button" onclick="closeReassignModal()" class="btn btn-secondary" style="margin-right: 10px;">Cancel</button>
                <button type="submit" class="btn btn-primary">Re-assign</button>
            </div>
        </form>
    </div>
</div>
@endsection

