@extends('layouts.master')

@section('title', 'Assignment Details - Prolex Law Firm')

@section('content')
<style>
    .assignment-detail-container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .assignment-header {
        background: linear-gradient(135deg, #1e40af, #3b82f6);
        color: white;
        padding: 30px;
        border-radius: 12px;
        margin-bottom: 30px;
        text-align: center;
    }

    .assignment-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 10px;
    }

    .assignment-meta {
        display: flex;
        justify-content: center;
        gap: 30px;
        flex-wrap: wrap;
        margin-top: 15px;
    }

    .meta-item {
        display: flex;
        align-items: center;
        gap: 8px;
        background: rgba(255,255,255,0.2);
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 0.9rem;
    }

    .meta-item i {
        opacity: 0.8;
    }

    .content-section {
        background: white;
        padding: 25px;
        border-radius: 10px;
        margin-bottom: 25px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .section-title {
        color: #374151;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #3b82f6;
        display: flex;
        align-items: center;
    }

    .section-title i {
        margin-right: 10px;
        color: #3b82f6;
    }

    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    .info-item {
        display: flex;
        flex-direction: column;
    }

    .info-label {
        font-weight: 600;
        color: #6b7280;
        margin-bottom: 5px;
        font-size: 0.9rem;
    }

    .info-value {
        color: #374151;
        font-size: 1rem;
        padding: 8px 0;
    }

    .priority-badge {
        display: inline-flex;
        align-items: center;
        padding: 6px 16px;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .priority-low {
        background-color: #dcfce7;
        color: #166534;
    }

    .priority-medium {
        background-color: #fef3c7;
        color: #92400e;
    }

    .priority-high {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        padding: 6px 16px;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-pending {
        background-color: #fef3c7;
        color: #92400e;
    }

    .status-in_progress {
        background-color: #dbeafe;
        color: #1e40af;
    }

    .status-completed {
        background-color: #dcfce7;
        color: #166534;
    }

    .status-cancelled {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .task-type-badge {
        background-color: #e0e7ff;
        color: #3730a3;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 0.85rem;
        font-weight: 500;
        display: inline-block;
    }

    .progress-section {
        background: #f8fafc;
        padding: 20px;
        border-radius: 8px;
        border: 1px solid #e2e8f0;
    }

    .progress-bar {
        width: 100%;
        height: 20px;
        background: #e2e8f0;
        border-radius: 10px;
        overflow: hidden;
        margin: 10px 0;
    }

    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #3b82f6, #1e40af);
        border-radius: 10px;
        transition: width 0.5s ease;
        position: relative;
    }

    .progress-text {
        text-align: center;
        font-weight: 600;
        color: #374151;
        margin-top: 5px;
    }

    .description-box {
        background: #f8fafc;
        padding: 20px;
        border-radius: 8px;
        border-left: 4px solid #3b82f6;
        margin: 15px 0;
    }

    .court-info {
        background: linear-gradient(135deg, #eff6ff, #dbeafe);
        border: 1px solid #3b82f6;
        border-radius: 8px;
        padding: 20px;
        margin: 15px 0;
    }

    .court-info-title {
        font-weight: 600;
        color: #1e40af;
        margin-bottom: 15px;
        font-size: 1.1rem;
    }

    .contact-info {
        background: #f0fdf4;
        border: 1px solid #22c55e;
        border-radius: 8px;
        padding: 20px;
        margin: 15px 0;
    }

    .contact-info-title {
        font-weight: 600;
        color: #15803d;
        margin-bottom: 15px;
        font-size: 1.1rem;
    }

    .actions-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 2px solid #e2e8f0;
        flex-wrap: wrap;
        gap: 15px;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
        transform: translateY(-1px);
    }

    .btn-success {
        background-color: #10b981;
        color: white;
    }

    .btn-success:hover {
        background-color: #059669;
        transform: translateY(-1px);
    }

    .btn-warning {
        background-color: #f59e0b;
        color: white;
    }

    .btn-warning:hover {
        background-color: #d97706;
        transform: translateY(-1px);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-1px);
    }

    .empty-value {
        color: #9ca3af;
        font-style: italic;
    }

    .lawyer-card {
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        padding: 20px;
        margin: 15px 0;
    }

    .lawyer-name {
        font-size: 1.2rem;
        font-weight: 600;
        color: #1e40af;
        margin-bottom: 10px;
    }

    .lawyer-details {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
    }

    @media (max-width: 768px) {
        .assignment-meta {
            flex-direction: column;
            align-items: center;
            gap: 15px;
        }

        .info-grid {
            grid-template-columns: 1fr;
        }

        .actions-section {
            flex-direction: column;
            align-items: stretch;
        }

        .assignment-detail-container {
            margin: 20px;
            padding: 20px;
        }
    }
</style>

<div class="assignment-detail-container">
    <!-- Assignment Header -->
    <div class="assignment-header">
        <div class="assignment-title">
            <i class="fas fa-tasks"></i>
            {{ $assignment->assignment_title }}
        </div>
        <div class="assignment-meta">
            <div class="meta-item">
                <i class="fas fa-calendar"></i>
                <span>Due: {{ $assignment->due_datetime->format('M d, Y \a\t H:i') }}</span>
            </div>
            <div class="meta-item">
                <i class="fas fa-flag"></i>
                <span class="priority-badge priority-{{ $assignment->priority }}">
                    {{ ucfirst($assignment->priority) }} Priority
                </span>
            </div>
            <div class="meta-item">
                <i class="fas fa-check-circle"></i>
                <span class="status-badge status-{{ $assignment->status }}">
                    {{ ucfirst(str_replace('_', ' ', $assignment->status)) }}
                </span>
            </div>
            <div class="meta-item">
                <i class="fas fa-clock"></i>
                <span>Created: {{ $assignment->created_at->format('M d, Y') }}</span>
            </div>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: 1fr 300px; gap: 30px;">
        <!-- Main Content -->
        <div>
            <!-- Basic Information -->
            <div class="content-section">
                <h2 class="section-title">
                    <i class="fas fa-info-circle"></i>
                    Basic Information
                </h2>

                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-label">Task Type</div>
                        <div class="info-value">
                            <span class="task-type-badge">
                                {{ ucwords(str_replace('_', ' ', $assignment->task_type)) }}
                            </span>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label">Estimated Hours</div>
                        <div class="info-value">
                            @if($assignment->estimated_hours)
                                {{ $assignment->estimated_hours }} hours
                            @else
                                <span class="empty-value">Not specified</span>
                            @endif
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label">Progress</div>
                        <div class="info-value">
                            <div class="progress-section">
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: {{ $assignment->progress_percentage }}%"></div>
                                </div>
                                <div class="progress-text">{{ $assignment->progress_percentage }}% Complete</div>
                            </div>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label">Billable</div>
                        <div class="info-value">
                            @if($assignment->is_billable)
                                <span style="color: #10b981; font-weight: 600;">
                                    <i class="fas fa-check-circle"></i> Yes
                                </span>
                            @else
                                <span style="color: #ef4444; font-weight: 600;">
                                    <i class="fas fa-times-circle"></i> No
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Description -->
            <div class="content-section">
                <h2 class="section-title">
                    <i class="fas fa-file-alt"></i>
                    Description & Instructions
                </h2>

                <div class="description-box">
                    <h4 style="margin-bottom: 10px; color: #374151;">Assignment Description</h4>
                    <p style="line-height: 1.6; margin-bottom: 20px;">{{ $assignment->description }}</p>

                    @if($assignment->instructions)
                        <h4 style="margin-bottom: 10px; color: #374151;">Special Instructions</h4>
                        <p style="line-height: 1.6; margin-bottom: 20px;">{{ $assignment->instructions }}</p>
                    @endif

                    @if($assignment->documents_required)
                        <h4 style="margin-bottom: 10px; color: #374151;">Documents Required</h4>
                        <p style="line-height: 1.6;">{{ $assignment->documents_required }}</p>
                    @endif
                </div>
            </div>

            <!-- Court Information -->
            @if($assignment->court_datetime || $assignment->court_location || $assignment->opposing_counsel)
                <div class="content-section">
                    <h2 class="section-title">
                        <i class="fas fa-gavel"></i>
                        Court Information
                    </h2>

                    <div class="court-info">
                        <div class="court-info-title">Court Details</div>
                        <div class="info-grid">
                            @if($assignment->court_datetime)
                                <div class="info-item">
                                    <div class="info-label">Court Date & Time</div>
                                    <div class="info-value">{{ $assignment->court_datetime->format('M d, Y \a\t H:i') }}</div>
                                </div>
                            @endif

                            @if($assignment->court_location)
                                <div class="info-item">
                                    <div class="info-label">Court Location</div>
                                    <div class="info-value">{{ $assignment->court_location }}</div>
                                </div>
                            @endif

                            @if($assignment->opposing_counsel)
                                <div class="info-item">
                                    <div class="info-label">Opposing Counsel</div>
                                    <div class="info-value">{{ $assignment->opposing_counsel }}</div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <!-- Contact Information -->
            @if($assignment->client_contact_info)
                <div class="content-section">
                    <h2 class="section-title">
                        <i class="fas fa-address-book"></i>
                        Contact Information
                    </h2>

                    <div class="contact-info">
                        <div class="contact-info-title">Client Contact Details</div>
                        <p style="line-height: 1.6;">{{ $assignment->client_contact_info }}</p>
                    </div>
                </div>
            @endif

            <!-- Billing Information -->
            @if($assignment->billing_notes)
                <div class="content-section">
                    <h2 class="section-title">
                        <i class="fas fa-file-invoice-dollar"></i>
                        Billing Information
                    </h2>

                    <div style="background: #fef3c7; border: 1px solid #f59e0b; border-radius: 8px; padding: 20px;">
                        <h4 style="margin-bottom: 10px; color: #92400e;">Billing Notes</h4>
                        <p style="line-height: 1.6; color: #78350f;">{{ $assignment->billing_notes }}</p>
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div>
            <!-- Assigned Lawyer -->
            <div class="content-section">
                <h2 class="section-title">
                    <i class="fas fa-user-tie"></i>
                    Assigned Lawyer
                </h2>

                <div class="lawyer-card">
                    <div class="lawyer-name">
                        {{ $assignment->lawyer->first_name }} {{ $assignment->lawyer->last_name }}
                    </div>

                    <div class="lawyer-details">
                        @if($assignment->lawyer->email)
                            <div>
                                <strong>Email:</strong><br>
                                <a href="mailto:{{ $assignment->lawyer->email }}" style="color: #3b82f6;">
                                    {{ $assignment->lawyer->email }}
                                </a>
                            </div>
                        @endif

                        @if($assignment->lawyer->phone)
                            <div>
                                <strong>Phone:</strong><br>
                                <a href="tel:{{ $assignment->lawyer->phone }}" style="color: #3b82f6;">
                                    {{ $assignment->lawyer->phone }}
                                </a>
                            </div>
                        @endif

                        @if($assignment->lawyer->bar_number)
                            <div>
                                <strong>Bar Number:</strong><br>
                                {{ $assignment->lawyer->bar_number }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Client Information -->
            @if($assignment->client)
                <div class="content-section">
                    <h2 class="section-title">
                        <i class="fas fa-users"></i>
                        Client Information
                    </h2>

                    <div style="background: #f0fdf4; border: 1px solid #22c55e; border-radius: 8px; padding: 20px;">
                        <div style="font-size: 1.1rem; font-weight: 600; color: #15803d; margin-bottom: 10px;">
                            {{ $assignment->client->first_name }} {{ $assignment->client->last_name }}
                        </div>

                        @if($assignment->client->email)
                            <div style="margin-bottom: 8px;">
                                <strong>Email:</strong>
                                <a href="mailto:{{ $assignment->client->email }}" style="color: #3b82f6; margin-left: 8px;">
                                    {{ $assignment->client->email }}
                                </a>
                            </div>
                        @endif

                        @if($assignment->client->phone)
                            <div style="margin-bottom: 8px;">
                                <strong>Phone:</strong>
                                <a href="tel:{{ $assignment->client->phone }}" style="color: #3b82f6; margin-left: 8px;">
                                    {{ $assignment->client->phone }}
                                </a>
                            </div>
                        @endif

                        @if($assignment->client->address)
                            <div>
                                <strong>Address:</strong>
                                <div style="margin-left: 8px; margin-top: 4px;">{{ $assignment->client->address }}</div>
                            </div>
                        @endif
                    </div>
                </div>
            @endif

            <!-- Case Information -->
            @if($assignment->legalCase)
                <div class="content-section">
                    <h2 class="section-title">
                        <i class="fas fa-folder"></i>
                        Related Case
                    </h2>

                    <div style="background: #eff6ff; border: 1px solid #3b82f6; border-radius: 8px; padding: 20px;">
                        <div style="font-size: 1.1rem; font-weight: 600; color: #1e40af; margin-bottom: 10px;">
                            {{ $assignment->legalCase->case_number }}
                        </div>

                        @if($assignment->legalCase->case_title)
                            <div style="margin-bottom: 8px;">
                                <strong>Title:</strong>
                                <span style="margin-left: 8px;">{{ $assignment->legalCase->case_title }}</span>
                            </div>
                        @endif

                        @if($assignment->legalCase->court_name)
                            <div style="margin-bottom: 8px;">
                                <strong>Court:</strong>
                                <span style="margin-left: 8px;">{{ $assignment->legalCase->court_name }}</span>
                            </div>
                        @endif

                        @if($assignment->legalCase->filing_date)
                            <div>
                                <strong>Filing Date:</strong>
                                <span style="margin-left: 8px;">{{ $assignment->legalCase->filing_date->format('M d, Y') }}</span>
                            </div>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Actions -->
    <div class="actions-section">
        <div>
            <a href="{{ route('modules.processing.assignment.list') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i>
                Back to List
            </a>
        </div>

        <div style="display: flex; gap: 10px;">
            <a href="{{ route('modules.processing.assignment.edit', $assignment->id) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i>
                Edit Assignment
            </a>

            @if($assignment->status !== 'completed')
                <form method="POST" action="{{ route('modules.processing.assignment.delete', $assignment->id) }}"
                      style="display: inline;"
                      onsubmit="return confirm('Are you sure you want to delete this assignment? This action cannot be undone.')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i>
                        Delete
                    </button>
                </form>
            @endif
        </div>
    </div>
</div>

<script>
    // Add some interactive features
    document.addEventListener('DOMContentLoaded', function() {
        // Animate progress bar
        const progressFill = document.querySelector('.progress-fill');
        if (progressFill) {
            const width = progressFill.style.width;
            progressFill.style.width = '0%';
            setTimeout(() => {
                progressFill.style.width = width;
            }, 500);
        }

        // Add click handlers for contact links
        const contactLinks = document.querySelectorAll('a[href^="mailto:"], a[href^="tel:"]');
        contactLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                // Add some visual feedback
                this.style.opacity = '0.7';
                setTimeout(() => {
                    this.style.opacity = '1';
                }, 150);
            });
        });
    });
</script>
@endsection

