@extends('layouts.master')

@section('title', 'Client Invoice - Prolex Law Firm')

@section('content')
@php
$PermissionsAdd = Auth::check() ? Auth::user()->hasPermission('add-invoice') : false;
$PermissionsEdit = Auth::check() ? Auth::user()->hasPermission('edit-invoice') : false;
$PermissionsDelete = Auth::check() ? Auth::user()->hasPermission('delete-invoice') : false;
@endphp

<style>
    /* Modern UI Enhancements */
    body {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        min-height: 100vh;
    }

    .container-fluid {
        animation: fadeInUp 0.8s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Enhanced Page Heading */
    .page-heading {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        padding: 20px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
        animation: slideInLeft 0.6s ease forwards;
    }

    @keyframes slideInLeft {
        from {
            opacity: 0;
            transform: translateX(-50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .page-heading h1 {
        margin: 0;
        font-weight: 700;
        text-shadow: 0 2px 4px rgba(0,0,0,0.3);
    }

    /* Enhanced Cards */
    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(0,0,0,0.15);
    }

    .card-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-bottom: 2px solid #e2e8f0;
        padding: 20px;
    }

    .card-header h6 {
        color: #1e293b;
        font-weight: 600;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .card-header h6::before {
        content: "📋";
        font-size: 1.2em;
    }

    .card-body {
        padding: 25px;
    }

    /* Enhanced Form Styling */
    .form-group {
        margin-bottom: 20px;
        position: relative;
    }

    .form-group label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .form-control {
        border: 2px solid #e5e7eb;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #f9fafb;
    }

    .form-control:focus {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        background: white;
        transform: translateY(-2px);
    }

    .form-control::placeholder {
        color: #9ca3af;
    }

    /* Form Icons */
    .form-group::before {
        content: "";
        position: absolute;
        right: 15px;
        top: 45px;
        width: 20px;
        height: 20px;
        opacity: 0.5;
        pointer-events: none;
    }

    .form-group:nth-child(1)::before { content: "👤"; } /* Client */
    .form-group:nth-child(2)::before { content: "📄"; } /* Invoice Number */
    .form-group:nth-child(3)::before { content: "📅"; } /* Date */
    .form-group:nth-child(4)::before { content: "⚖️"; } /* Case Reference */
    .form-group:nth-child(5)::before { content: "💼"; } /* Description */
    .form-group:nth-child(6)::before { content: "👨‍⚖️"; } /* Lawyer */
    .form-group:nth-child(7)::before { content: "📝"; } /* Narration */
    .form-group:nth-child(8)::before { content: "🏷️"; } /* GL Account */
    .form-group:nth-child(9)::before { content: "💰"; } /* Tax */
    .form-group:nth-child(10)::before { content: "🏷️"; } /* Discount */
    .form-group:nth-child(11)::before { content: "💵"; } /* Price */
    .form-group:nth-child(12)::before { content: "⏱️"; } /* Quantity */
    .form-group:nth-child(13)::before { content: "💱"; } /* Currency */
    .form-group:nth-child(14)::before { content: "📊"; } /* Disbursements */

    /* Enhanced Buttons */
    .btn {
        border-radius: 10px;
        font-weight: 600;
        padding: 12px 24px;
        transition: all 0.3s ease;
        border: none;
        position: relative;
        overflow: hidden;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(59, 130, 246, 0.6);
    }

    .btn-secondary {
        background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
        box-shadow: 0 4px 15px rgba(107, 114, 128, 0.4);
    }

    .btn-secondary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(107, 114, 128, 0.6);
    }

    .btn-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(16, 185, 129, 0.6);
    }

    /* Enhanced Table */
    .table {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    .table thead th {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        border: none;
        padding: 15px 10px;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 0.5px;
    }

    .table tbody tr {
        transition: all 0.3s ease;
        border-bottom: 1px solid #f1f5f9;
    }

    .table tbody tr:hover {
        background: #f0f9ff;
        transform: scale(1.01);
    }

    .table tbody td {
        padding: 12px 10px;
        vertical-align: middle;
        border: none;
    }

    /* Action Buttons */
    .btn-circle {
        border-radius: 50%;
        width: 35px;
        height: 35px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        margin: 0 2px;
    }

    .btn-circle:hover {
        transform: scale(1.1);
    }

    /* Enhanced Alerts */
    .alert {
        border-radius: 10px;
        border: none;
        padding: 15px 20px;
        margin-bottom: 20px;
        animation: slideInRight 0.5s ease forwards;
    }

    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .alert-success {
        background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%);
        color: #166534;
        border-left: 4px solid #16a34a;
    }

    /* Totals Section */
    .totals-card {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        border-radius: 15px;
        padding: 20px;
        margin-top: 20px;
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
    }

    .totals-card p {
        margin: 5px 0;
        font-weight: 600;
        display: flex;
        justify-content: space-between;
    }

    .totals-card .total-label {
        opacity: 0.9;
    }

    .totals-card .total-value {
        font-weight: 700;
        font-size: 1.1em;
    }

    /* Modal Enhancements */
    .modal-content {
        border-radius: 15px;
        border: none;
        box-shadow: 0 20px 40px rgba(0,0,0,0.2);
    }

    .modal-header {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #991b1b;
        border-bottom: none;
        border-radius: 15px 15px 0 0;
        padding: 20px;
    }

    .modal-body {
        padding: 25px;
        font-size: 16px;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .container-fluid {
            padding: 15px;
        }

        .page-heading {
            padding: 15px;
            margin-bottom: 20px;
        }

        .card-body {
            padding: 15px;
        }

        .table-responsive {
            font-size: 12px;
        }

        .table thead th,
        .table tbody td {
            padding: 8px 5px;
        }

        .btn {
            padding: 10px 20px;
            font-size: 14px;
        }

        .totals-card {
            padding: 15px;
        }

        .totals-card p {
            font-size: 14px;
        }
    }

    /* Loading States */
    .loading {
        position: relative;
        pointer-events: none;
        opacity: 0.6;
    }

    .loading::after {
        content: "";
        position: absolute;
        top: 50%;
        left: 50%;
        width: 20px;
        height: 20px;
        margin: -10px 0 0 -10px;
        border: 2px solid #3b82f6;
        border-top: 2px solid transparent;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Tooltips */
    .tooltip-inner {
        background: #1e40af;
        border-radius: 8px;
        font-size: 12px;
    }

    .tooltip.bs-tooltip-top .arrow::before {
        border-top-color: #1e40af;
    }
</style>

<div class="container-fluid">
    <!-- Enhanced Page Heading -->
    <div class="page-heading">
        <h1>Client Invoice Management</h1>
    </div>

    <!-- Form Section - Full Width -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card shadow mb-4">
                <!-- Card Header -->
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary" id="formHeader">Process Invoice</h6>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" id="successMessage" style="margin: 20px;">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="form-group" id="errorMessage" style="margin: 20px;">
                            <div class="card bg-warning text-white shadow">
                                <div class="card-body">
                                    @foreach ($errors->all() as $error)
                                        <div style="color: red;">{{ $error }}</div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif

                    <form class="card-body" action="{{ route('modules.processing.client-invoice.store') }}" method="post" id="invoiceForm">
                        @csrf
                        <input type="hidden" name="_method" id="_method" value="POST">
                        <input type="hidden" id="invoiceId" name="id" value="">
                        <input type="hidden" name="source" value="client-invoice">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="client_id">Select / Enter Client Name</label>
                                    <select class="form-control form-control-user" id="client_id" name="client_id" required>
                                        <option value="" disabled selected>Select Client</option>
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->id }}">{{ $client->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_number">Invoice Number</label>
                                    <input type="text" class="form-control form-control-user" id="invoice_number" placeholder="e.g. INV-20250926-162120" name="invoice_number" value="{{ old('invoice_number', 'INV-' . now()->format('Ymd-His')) }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_date">Date of Invoice</label>
                                    <input type="date" class="form-control form-control-user" id="invoice_date" placeholder="26/09/2025" name="invoice_date" value="{{ old('invoice_date', now()->format('Y-m-d')) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="case_reference">Matter / Case Reference</label>
                                    <input type="text" class="form-control form-control-user" id="case_reference" placeholder="Court case no. / Internal file ref." name="case_reference" value="{{ old('case_reference') }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">Description of Legal Services</label>
                                    <input type="text" class="form-control form-control-user" id="description" placeholder="(e.g. Consultation, Contract Drafting, Court Appearance)" name="description" value="{{ old('description') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="responsible_lawyer">Responsible Lawyer / Partner</label>
                                    <input type="text" class="form-control form-control-user" id="responsible_lawyer" placeholder="(Name of solicitor handling the matter)" name="responsible_lawyer" value="{{ old('responsible_lawyer') }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="narration">Narration / Additional Notes</label>
                                    <input type="text" class="form-control form-control-user" id="narration" placeholder="(Optional remarks on service provided)" name="narration" value="{{ old('narration') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="gl_account">Billing Category / GL Account</label>
                                    <select class="form-control form-control-user" id="gl_account" name="gl_account" required>
                                        <option value="" disabled selected>(Professional Fees, Disbursements, Court Costs, etc.)</option>
                                        @foreach ($glAccounts as $gl)
                                            <option value="{{ $gl->code }}">{{ $gl->code . '/' . $gl->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tax">Applicable Tax</label>
                                    <select class="form-control form-control-user" id="tax" name="tax_id" required>
                                        <option value="" disabled selected>(VAT / Sales Tax if applicable)</option>
                                        @foreach ($taxes as $tax)
                                            <option value="{{ $tax->id . ':' . $tax->rate }}">{{ $tax->rate }}% {{ $tax->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="discount">Discount %</label>
                                    <input type="number" class="form-control form-control-user" id="discount" placeholder="(If client agreement allows)" name="discount" value="{{ old('discount') }}" step="0.01" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="price">Rate</label>
                                    <input type="number" class="form-control form-control-user" id="price" placeholder="(Hourly Rate or Fixed Fee)" name="price" value="{{ old('price') }}" step="0.01" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="quantity">Hours / Quantity</label>
                                    <input type="number" class="form-control form-control-user" id="quantity" placeholder="(Billable time or units)" name="quantity" value="{{ old('quantity') }}" min="1" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency">Currency</label>
                                    <select class="form-control form-control-user" id="currency" name="currency_id" required>
                                        <option value="" disabled selected>(USD, GBP, ZWL, etc.)</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->id }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="disbursements">Disbursements / Operational Costs</label>
                                    <input type="number" class="form-control form-control-user" id="disbursements" placeholder="(Court filing fees, travel, photocopying, courier, etc.)" name="disbursements" value="{{ old('disbursements') }}" step="0.01">
                                </div>
                            </div>
                        </div>

                        <div style="display: flex; justify-content: center; margin-top: 30px;">
                            <input type="submit" style="width: 150px; height: 45px; margin-right: 15px;" value="Save" class="btn btn-primary btn-user btn-block" id="submitButton" onclick="updateURLAndSubmit(event)"/>
                            <input style="width: 150px; height: 45px;" type="reset" value="Refresh" class="btn btn-secondary btn-user btn-block" onclick="refreshForm()"/>
                        </div>
                        <hr>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Section - Full Width Below Form -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 style="float: left;" class="m-0 font-weight-bold text-primary">Client Transactions</h6>
                    @if($PermissionsAdd)
                        <a id="process" href="{{ route('modules.processing.client-invoice.process', ['invoice' => $batch ?? '']) }}" style="float: right; margin-top: -5px;" class="btn btn-success btn-icon-split">
                            <span class="icon text-white-50">
                                <i class="fas fa-check"></i>
                            </span>
                            <span class="text">Process</span>
                        </a>
                    @endif
                    <a href="{{ route('modules.processing.client') }}" style="float: right; margin-top: -5px; margin-left: 10px;" class="btn btn-primary btn-icon-split">
                        <span class="icon text-white-50">
                            <i class="fas fa-arrow-left"></i>
                        </span>
                        <span class="text">Back to Client</span>
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 14px;">
                            <thead>
                                <tr>
                                    <th style="padding: 12px;">Entry Date</th>
                                    <th style="padding: 12px;">Description</th>
                                    <th style="padding: 12px;">Account</th>
                                    <th style="padding: 12px;">Reference</th>
                                    <th style="padding: 12px;">Qty</th>
                                    <th style="padding: 12px;">Price</th>
                                    <th style="padding: 12px;">Disc</th>
                                    <th style="padding: 12px;">Tax %</th>
                                    <th style="padding: 12px;">Tax Amt</th>
                                    <th style="padding: 12px;">Total</th>
                                    <th style="padding: 12px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($clientTransactions as $transaction)
                                    <tr>
                                        <td>{{ $transaction->created_at->format('Y-m-d') }}</td>
                                        <td>{{ $transaction->description }}</td>
                                        <td>{{ $transaction->account }}</td>
                                        <td>{{ $transaction->reference }}</td>
                                        <td>{{ number_format($transaction->quantity, 2) }}</td>
                                        <td>{{ number_format($transaction->price, 2) }}</td>
                                        <td>{{ number_format($transaction->discount, 2) }}</td>
                                        <td>{{ number_format($transaction->tax_rate, 2) }}</td>
                                        <td>{{ number_format($transaction->tax_amount, 2) }}</td>
                                        <td>{{ number_format($transaction->total, 2) }}</td>
                                        <td style="justify-content: center; align-items: center;">
                                            @if($PermissionsEdit)
                                                <a href="#" class="btn btn-primary btn-circle" style="height: 30px; width: 30px;" onclick="editTransaction(event, '{{ $transaction->id }}', '{{ $transaction->description }}', '{{ $transaction->reference }}', '{{ $transaction->price }}', '{{ $transaction->account }}', '{{ $transaction->quantity }}', '{{ $transaction->discount }}', '{{ $transaction->tax }}', '{{ $transaction->currency }}')">
                                                    <i class="fas fa-edit" style="font-size: 0.8em;"></i>
                                                </a>
                                            @endif
                                            @if($PermissionsDelete)
                                                <a href="#" style="height: 30px; width: 30px;" class="btn btn-danger btn-circle" onclick="confirmDelete('{{ $transaction->description }}', '{{ $transaction->reference }}', '{{ route('modules.processing.client-invoice.destroy', $transaction->id) }}'); return false;">
                                                    <i class="fas fa-trash" style="font-size: 0.8em;"></i>
                                                </a>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        @if(isset($totals))
                        <div class="totals-card" style="margin-top: 30px;">
                            <h6 style="margin-bottom: 20px; text-align: center; font-weight: 700; font-size: 1.2em;">Invoice Summary</h6>
                            <p><span class="total-label">Total (Exc):</span> <span class="total-value">KES {{ number_format($totals['subtotal'], 2) }}</span></p>
                            <p><span class="total-label">Total (Tax):</span> <span class="total-value">KES {{ number_format($totals['tax'], 2) }}</span></p>
                            <p><span class="total-label">Total (Dis):</span> <span class="total-value">KES {{ number_format($totals['discount'], 2) }}</span></p>
                            <p style="border-top: 2px solid rgba(255,255,255,0.3); padding-top: 15px; margin-top: 15px;"><span class="total-label">Total (Inc):</span> <span class="total-value" style="font-size: 1.3em; color: #fbbf24;">KES {{ number_format($totals['total'], 2) }}</span></p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmDeleteModal" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmDeleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete: <span id="deleteItemName"></span>?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteButton">Delete</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Initialize tooltips
    $(document).ready(function() {
        $('[data-toggle="tooltip"]').tooltip();
    });

    function editTransaction(event, id, description, reference, price, account, quantity, discount, tax, currency) {
        event.preventDefault();
        // Add loading state
        const form = document.getElementById('invoiceForm');
        form.classList.add('loading');

        setTimeout(() => {
            setFormValues(id, description, reference, price, account, quantity, discount, tax, currency, 'Edit Invoice', 'Update');
            form.classList.remove('loading');
        }, 500);
    }

    function refreshForm() {
        // Add loading state
        const form = document.getElementById('invoiceForm');
        form.classList.add('loading');

        setTimeout(() => {
            setFormValues('', '', '', '', '', '', '', '', '', '', 'Process Invoice', 'Save');
            hideMessages();
            form.classList.remove('loading');
        }, 300);
    }

    function setFormValues(id, description, reference, price, account, quantity, discount, tax, currency, headerText, buttonText) {
        document.getElementById('invoiceId').value = id;
        document.getElementById('description').value = description;
        document.getElementById('reference').value = reference;
        document.getElementById('price').value = price;
        document.getElementById('account').value = account;
        document.getElementById('quantity').value = quantity;
        document.getElementById('discount').value = discount;
        document.getElementById('tax').value = tax;
        document.getElementById('currency').value = currency;
        document.getElementById('formHeader').innerText = headerText;
        document.getElementById('submitButton').value = buttonText;

        if (buttonText === 'Update') {
            document.getElementById('_method').value = 'PUT';
            document.getElementById('invoiceForm').action = '/modules/processing/client-invoice/update/' + id;
        } else {
            document.getElementById('_method').value = 'POST';
            document.getElementById('invoiceForm').action = '{{ route("modules.processing.client-invoice.store") }}';
        }
    }

    function confirmDelete(name, reference, deleteUrl) {
        document.getElementById('deleteItemName').innerText = `${name} => ${reference}`;
        $('#confirmDeleteModal').modal('show');
        document.getElementById('confirmDeleteButton').onclick = function() {
            // Add loading state to modal
            this.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Deleting...';
            this.disabled = true;
            window.location.href = deleteUrl;
        };
    }

    function updateURLAndSubmit(event) {
        event.preventDefault();
        const form = document.getElementById('invoiceForm');
        const submitBtn = document.getElementById('submitButton');

        // Add loading state
        form.classList.add('loading');
        submitBtn.disabled = true;
        submitBtn.value = 'Processing...';

        const batchValue = document.getElementById('invoice_number').value.trim();
        const processButton = document.getElementById('process');
        if (processButton) {
            processButton.href = processButton.href.replace(/invoice=[^&]*/, `invoice=${batchValue}`);
        }

        // Simulate processing delay for better UX
        setTimeout(() => {
            form.submit();
        }, 800);
    }

    function hideMessages() {
        const successMsg = document.getElementById('successMessage');
        const errorMsg = document.getElementById('errorMessage');
        if (successMsg) successMsg.style.display = 'none';
        if (errorMsg) errorMsg.style.display = 'none';
    }

    // Add ripple effect to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            ripple.classList.add('ripple');
            this.appendChild(ripple);

            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            ripple.style.width = ripple.style.height = size + 'px';

            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';

            ripple.addEventListener('animationend', () => {
                ripple.remove();
            });
        });
    });

    // Auto-hide success messages after 5 seconds
    setTimeout(() => {
        const successMsg = document.getElementById('successMessage');
        if (successMsg) {
            successMsg.style.transition = 'opacity 0.5s ease';
            successMsg.style.opacity = '0';
            setTimeout(() => successMsg.style.display = 'none', 500);
        }
    }, 5000);
</script>
@endsection

