@extends('layouts.master')

@section('title', 'Client Quotation - Prolex Law Firm')

@section('content')
@php
$PermissionsAdd = Auth::check() ? Auth::user()->hasPermission('add-quotation') : false;
$PermissionsEdit = Auth::check() ? Auth::user()->hasPermission('edit-quotation') : false;
$PermissionsDelete = Auth::check() ? Auth::user()->hasPermission('delete-quotation') : false;
@endphp

<style>
    /* Modern UI Enhancements */
    body {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        min-height: 100vh;
    }

    .container-fluid {
        animation: fadeInUp 0.8s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Enhanced Page Heading */
    .page-heading {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        padding: 20px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
        animation: slideInLeft 0.6s ease forwards;
    }

    @keyframes slideInLeft {
        from {
            opacity: 0;
            transform: translateX(-50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .page-heading h1 {
        margin: 0;
        font-weight: 700;
        text-shadow: 0 2px 4px rgba(0,0,0,0.3);
    }

    /* Enhanced Cards */
    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(0,0,0,0.15);
    }

    .card-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-bottom: 2px solid #e2e8f0;
        padding: 20px;
    }

    .card-header h6 {
        color: #1e293b;
        font-weight: 600;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .card-header h6::before {
        content: "📋";
        font-size: 1.2em;
    }

    .card-body {
        padding: 25px;
    }

    /* Enhanced Form Styling */
    .form-group {
        margin-bottom: 20px;
        position: relative;
    }

    .form-group label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .form-control {
        border: 2px solid #e5e7eb;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #f9fafb;
    }

    .form-control:focus {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        background: white;
        transform: translateY(-2px);
    }

    .form-control::placeholder {
        color: #9ca3af;
    }

    /* Enhanced Buttons */
    .btn {
        border-radius: 10px;
        font-weight: 600;
        padding: 12px 24px;
        transition: all 0.3s ease;
        border: none;
        position: relative;
        overflow: hidden;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(59, 130, 246, 0.6);
    }

    .btn-secondary {
        background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
        box-shadow: 0 4px 15px rgba(107, 114, 128, 0.4);
    }

    .btn-secondary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(107, 114, 128, 0.6);
    }

    .btn-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(16, 185, 129, 0.6);
    }

    .btn-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        box-shadow: 0 4px 15px rgba(239, 68, 68, 0.4);
    }

    .btn-danger:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(239, 68, 68, 0.6);
    }

    /* Enhanced Table */
    .table {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    .table thead th {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        border: none;
        padding: 15px 10px;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 0.5px;
    }

    .table tbody tr {
        transition: all 0.3s ease;
        border-bottom: 1px solid #f1f5f9;
    }

    .table tbody tr:hover {
        background: #f0f9ff;
        transform: scale(1.01);
    }

    .table tbody td {
        padding: 12px 10px;
        vertical-align: middle;
        border: none;
    }

    /* Enhanced Alerts */
    .alert {
        border-radius: 10px;
        border: none;
        padding: 15px 20px;
        margin-bottom: 20px;
        animation: slideInRight 0.5s ease forwards;
    }

    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .alert-success {
        background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%);
        color: #166534;
        border-left: 4px solid #16a34a;
    }

    /* Totals Section */
    .totals-card {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        border-radius: 15px;
        padding: 20px;
        margin-top: 20px;
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
    }

    .totals-card p {
        margin: 5px 0;
        font-weight: 600;
        display: flex;
        justify-content: space-between;
    }

    .totals-card .total-label {
        opacity: 0.9;
    }

    .totals-card .total-value {
        font-weight: 700;
        font-size: 1.1em;
    }

    /* Modal Enhancements */
    .modal-content {
        border-radius: 15px;
        border: none;
        box-shadow: 0 20px 40px rgba(0,0,0,0.2);
    }

    .modal-header {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #991b1b;
        border-bottom: none;
        border-radius: 15px 15px 0 0;
        padding: 20px;
    }

    .modal-body {
        padding: 25px;
        font-size: 16px;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .container-fluid {
            padding: 15px;
        }

        .page-heading {
            padding: 15px;
            margin-bottom: 20px;
        }

        .card-body {
            padding: 15px;
        }

        .table-responsive {
            font-size: 12px;
        }

        .table thead th,
        .table tbody td {
            padding: 8px 5px;
        }

        .btn {
            padding: 10px 20px;
            font-size: 14px;
        }

        .totals-card {
            padding: 15px;
        }

        .totals-card p {
            font-size: 14px;
        }
    }

    /* Loading States */
    .loading {
        position: relative;
        pointer-events: none;
        opacity: 0.6;
    }

    .loading::after {
        content: "";
        position: absolute;
        top: 50%;
        left: 50%;
        width: 20px;
        height: 20px;
        margin: -10px 0 0 -10px;
        border: 2px solid #3b82f6;
        border-top: 2px solid transparent;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Tooltips */
    .tooltip-inner {
        background: #1e40af;
        border-radius: 8px;
        font-size: 12px;
    }

    .tooltip.bs-tooltip-top .arrow::before {
        border-top-color: #1e40af;
    }

    /* Services Table Enhancements */
    #servicesTable {
        margin-bottom: 20px;
    }

    #servicesTable thead th {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        border: none;
        padding: 12px 8px;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 11px;
        letter-spacing: 0.5px;
    }

    #servicesTable tbody td {
        padding: 8px;
        vertical-align: middle;
    }

    #servicesTable .form-control {
        border: 1px solid #d1d5db;
        border-radius: 6px;
        padding: 6px 8px;
        font-size: 13px;
    }

    #servicesTable .btn-danger {
        padding: 4px 8px;
        font-size: 12px;
    }

    /* Section Header */
    .section-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        padding: 15px;
        border-radius: 10px;
        margin-bottom: 20px;
        border: 1px solid #e2e8f0;
    }

    .section-header i {
        color: #3b82f6;
        font-size: 1.1em;
    }
</style>

<div class="container-fluid">
    <!-- Enhanced Page Heading -->
    <div class="page-heading">
        <h1>Client Quotation Management</h1>
    </div>

    <!-- Form Section - Full Width -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card shadow mb-4">
                <!-- Card Header -->
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary" id="formHeader">{{ isset($quotation) ? 'Edit Quotation' : 'Create New Quotation' }}</h6>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" id="successMessage" style="margin: 20px;">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="form-group" id="errorMessage" style="margin: 20px;">
                            <div class="card bg-warning text-white shadow">
                                <div class="card-body">
                                    @foreach ($errors->all() as $error)
                                        <div style="color: red;">{{ $error }}</div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif

                    <form method="POST" action="{{ isset($quotation) ? route('modules.processing.client-quotation.update', $quotation->id) : route('modules.processing.client-quotation.store') }}" id="quotationForm">
                        @method(isset($quotation) ? 'PUT' : 'POST')
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="client_id">Client <span class="text-danger">*</span></label>
                                    <select name="client_id" class="form-control" id="clientSelect" required>
                                        <option value="">Select Client</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ isset($quotation) && $quotation->client_id == $client->id ? 'selected' : '' }}>
                                                {{ $client->client_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('client_id')
                                        <div class="error-message">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="quotation_date">Quotation Date <span class="text-danger">*</span></label>
                                    <input type="date" name="quotation_date" class="form-control" value="{{ isset($quotation) ? $quotation->quotation_date->format('Y-m-d') : now()->format('Y-m-d') }}" required>
                                    @error('quotation_date')
                                        <div class="error-message">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="section-header d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <i class="fas fa-list me-2"></i> Services
                            </div>
                            <button type="button" class="btn btn-primary btn-sm" id="addServiceBtn">
                                <i class="fas fa-plus me-1"></i> Add Service
                            </button>
                        </div>

                        <table class="table table-bordered" id="servicesTable">
                            <thead class="table-light">
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="50%">Description <span class="text-danger">*</span></th>
                                    <th width="15%">Quantity</th>
                                    <th width="20%">Price Estimate <span class="text-danger">*</span></th>
                                    <th width="10%"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Service lines will be added dynamically -->
                            </tbody>
                        </table>

                        <div class="row justify-content-end mt-4">
                            <div class="col-md-5">
                                <div class="totals-card">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="fw-bold total-label">Total Amount:</span>
                                        <span id="totalAmount" class="fw-bold total-value">$0.00</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="terms">Terms</label>
                                    <textarea name="terms" class="form-control" rows="4" placeholder="Enter terms and conditions for this quotation...">{{ isset($quotation) ? $quotation->terms : '' }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="validity_period">Validity Period (days)</label>
                                    <input type="number" name="validity_period" class="form-control" min="1" value="{{ isset($quotation) ? $quotation->validity_period : 30 }}">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="notes">Notes</label>
                            <textarea name="notes" class="form-control" rows="3" placeholder="Any additional notes or comments...">{{ isset($quotation) ? $quotation->notes : '' }}</textarea>
                        </div>

                        <div style="display: flex; justify-content: center; margin-top: 30px;">
                            <a href="{{ route('modules.processing.client') }}" class="btn btn-secondary" style="margin-right: 15px;">
                                <i class="fas fa-times me-2"></i> Cancel
                            </a>
                            <button type="submit" class="btn btn-success" id="submitQuotationBtn">
                                <i class="fas fa-paper-plane me-2"></i> Send Quotation
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Quotations List Section - Full Width Below Form -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Existing Quotations</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="quotationsDataTable" width="100%" cellspacing="0" style="font-size: 14px;">
                            <thead>
                                <tr>
                                    <th style="padding: 12px;">Quotation #</th>
                                    <th style="padding: 12px;">Client</th>
                                    <th style="padding: 12px;">Date</th>
                                    <th style="padding: 12px;">Status</th>
                                    <th style="padding: 12px;">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($clientQuotations as $quotation)
                                    <tr>
                                        <td>{{ $quotation->quotation_number }}</td>
                                        <td>{{ $quotation->client->client_name ?? 'N/A' }}</td>
                                        <td>{{ $quotation->quotation_date->format('Y-m-d') }}</td>
                                        <td>{{ $quotation->status }}</td>
                                        <td style="justify-content: center; align-items: center;">
                                            @if($PermissionsEdit)
                                                <a href="{{ route('modules.processing.client-quotation.edit', $quotation->id) }}" class="btn btn-primary btn-sm me-1">Edit</a>
                                            @endif
                                            @if($PermissionsAdd)
                                                <form method="POST" action="{{ route('modules.processing.client-quotation.process', $quotation->id) }}" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success btn-sm me-1">Send</button>
                                                </form>
                                            @endif
                                            @if($PermissionsDelete)
                                                <form method="POST" action="{{ route('modules.processing.client-quotation.destroy', $quotation->id) }}" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const servicesTableBody = document.querySelector('#servicesTable tbody');
    const totalAmountSpan = document.getElementById('totalAmount');

    function addServiceLine(data = {}) {
        const idx = servicesTableBody.children.length;
        const row = document.createElement('tr');
        row.innerHTML = `
            <td>${idx + 1}</td>
            <td><input type="text" name="services[${idx}][description]" class="form-control form-control-sm" value="${data.description || ''}" required></td>
            <td><input type="number" name="services[${idx}][quantity]" class="form-control form-control-sm" min="1" value="${data.quantity || 1}"></td>
            <td><input type="number" name="services[${idx}][unit_price]" class="form-control form-control-sm" step="0.01" value="${data.unit_price || ''}" required></td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-danger remove-service"><i class="fas fa-trash-alt"></i></button>
            </td>
        `;
        servicesTableBody.appendChild(row);

        row.querySelector('.remove-service').addEventListener('click', () => {
            row.remove();
            renumberRows();
            updateTotal();
        });

        row.querySelectorAll('input').forEach(input => {
            input.addEventListener('input', updateTotal);
        });
    }

    function renumberRows() {
        Array.from(servicesTableBody.children).forEach((row, index) => {
            row.children[0].textContent = index + 1;
            row.querySelectorAll('input').forEach(input => {
                const name = input.getAttribute('name');
                const newName = name.replace(/services\[\d+\]/, `services[${index}]`);
                input.setAttribute('name', newName);
            });
        });
    }

    function updateTotal() {
        let total = 0;
        Array.from(servicesTableBody.children).forEach(row => {
            const quantity = parseFloat(row.querySelector('input[name$="[quantity]"]').value) || 1;
            const unitPrice = parseFloat(row.querySelector('input[name$="[unit_price]"]').value) || 0;
            total += quantity * unitPrice;
        });
        totalAmountSpan.textContent = '$' + total.toFixed(2);
    }

    document.getElementById('addServiceBtn').addEventListener('click', () => {
        addServiceLine();
    });

    // Initialize with existing lines or one empty line
    @if(isset($quotation) && $quotation->lines->count() > 0)
        @foreach($quotation->lines as $line)
            addServiceLine({
                description: {!! json_encode($line->description) !!},
                quantity: {!! json_encode($line->quantity) !!},
                unit_price: {!! json_encode($line->unit_price) !!}
            });
        @endforeach
    @else
        addServiceLine();
    @endif

    updateTotal();
});
</script>
@endsection

