@extends('layouts.master')

@section('title', 'Create Court Filing - Prolex Law Firm')

@push('styles')
    <link rel="stylesheet" href="{{ asset('css/court-filings.css') }}">
@endpush

@section('content')
<div class="main-container">
    {{-- Success Alert --}}
    @if(session('success'))
    <div class="alert alert-success">
        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
        </svg>
        <div class="alert-content">
            {{ session('success') }}
        </div>
    </div>
    @endif

    {{-- Error Alert --}}
    @if ($errors->any())
    <div class="alert alert-error">
        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
        </svg>
        <div class="alert-content">
            <h3>Please correct the following errors:</h3>
            <ul class="alert-list">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    </div>
    @endif

    {{-- Page Header --}}
    <div class="page-header">
        <h1 class="page-title">Create Court Filing</h1>
        <p class="page-subtitle">Complete the form below to submit a new court filing to the system</p>
    </div>

    {{-- Progress Bar --}}
    <div class="progress-container">
        <div class="progress-header">
            <span class="progress-label">Form Completion</span>
            <span id="progress-percentage" class="progress-percentage">0%</span>
        </div>
        <div class="progress-bar-bg">
            <div id="progress-bar" class="progress-bar-fill" style="width: 0%"></div>
        </div>
    </div>

    {{-- Form --}}
    <form id="filing-form" action="{{ route('court-filings.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        {{-- Case Management Integration --}}
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z" />
                    </svg>
                    Case Management Integration
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="case_id" class="form-label">Link to Existing Case (Optional)</label>
                        <select name="case_id" id="case_id" class="form-select">
                            <option value="">Select a case</option>
                            @foreach($cases as $case)
                                <option value="{{ $case->id }}" {{ old('case_id') == $case->id ? 'selected' : '' }}>
                                    {{ $case->case_id }} - {{ $case->client_name }}
                                </option>
                            @endforeach
                        </select>
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Link this filing to an existing case for better tracking
                        </div>
                        @error('case_id')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="case_reference" class="form-label">Case Reference (Manual)</label>
                        <input type="text" name="case_reference" id="case_reference" value="{{ old('case_reference') }}" placeholder="Enter case reference manually" class="form-input" />
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Use this if the case is not yet in the system
                        </div>
                        @error('case_reference')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Basic Filing Information --}}
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Basic Filing Information
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="filing_code" class="form-label">Filing Code <span class="required">*</span></label>
                        <input type="text" name="filing_code" id="filing_code" value="{{ old('filing_code') }}" placeholder="e.g., CF-2024-001" class="form-input" required />
                        @error('filing_code')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="filing_title" class="form-label">Filing Title <span class="required">*</span></label>
                        <input type="text" name="filing_title" id="filing_title" value="{{ old('filing_title') }}" placeholder="e.g., Motion for Summary Judgment" maxlength="200" class="form-input" required />
                        <div class="char-counter" data-field="filing_title">0 / 200</div>
                        @error('filing_title')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="filing_type_id" class="form-label">Filing Type <span class="required">*</span></label>
                        <select name="filing_type_id" id="filing_type_id" class="form-select" required>
                            <option value="">Select filing type</option>
                            @foreach($filingTypes as $type)
                                <option value="{{ $type->filing_type_id }}" {{ old('filing_type_id') == $type->filing_type_id ? 'selected' : '' }}>
                                    {{ $type->type_name }}
                                </option>
                            @endforeach
                        </select>
                        @error('filing_type_id')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="court_jurisdiction" class="form-label">Court / Jurisdiction <span class="required">*</span></label>
                        <input type="text" name="court_jurisdiction" id="court_jurisdiction" value="{{ old('court_jurisdiction') }}" placeholder="e.g., High Court – Civil Division" class="form-input" required />
                        @error('court_jurisdiction')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="filing_date" class="form-label">Filing Date <span class="required">*</span></label>
                        <input type="date" name="filing_date" id="filing_date" value="{{ old('filing_date') }}" class="form-input" required />
                        @error('filing_date')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="due_date" class="form-label">Due Date / Deadline</label>
                        <input type="date" name="due_date" id="due_date" value="{{ old('due_date') }}" class="form-input" />
                        <div id="deadline-warning" class="hidden"></div>
                        @error('due_date')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="filed_by" class="form-label">Filed By <span class="required">*</span></label>
                        <input type="text" name="filed_by" id="filed_by" value="{{ old('filed_by') }}" placeholder="Secretary, paralegal, or lawyer name" class="form-input" required />
                        @error('filed_by')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Document Management --}}
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                    Document Management
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="document_path" class="form-label">Document Upload</label>
                        <div class="file-upload-area">
                            <input type="file" name="document_path" id="document_path" class="file-upload-input" accept=".pdf,.doc,.docx" data-file-upload />
                            <svg class="file-upload-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                            </svg>
                            <p class="file-upload-text">Click to upload or drag and drop</p>
                            <p class="file-upload-hint">PDF, DOC, DOCX up to 10MB</p>
                        </div>
                        <div id="file-info" class="hidden"></div>
                        @error('document_path')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="version" class="form-label">Version / Revision Number</label>
                        <input type="text" name="version" id="version" value="{{ old('version') }}" placeholder="e.g., v1.0, v1.1" class="form-input" />
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Track document versions for revision history
                        </div>
                        @error('version')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field form-grid-full">
                        <label for="filing_description" class="form-label">Filing Description</label>
                        <textarea name="filing_description" id="filing_description" placeholder="Detailed description of the filing" maxlength="500" class="form-textarea">{{ old('filing_description') }}</textarea>
                        <div class="char-counter" data-field="filing_description">0 / 500</div>
                        @error('filing_description')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Court Details --}}
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                    </svg>
                    Court Details
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="court_area_id" class="form-label">Court Area</label>
                        <select name="court_area_id" id="court_area_id" class="form-select">
                            <option value="">Select court area</option>
                            @foreach($courtAreas as $area)
                                <option value="{{ $area->area_code }}" {{ old('court_area_id') == $area->area_code ? 'selected' : '' }}>
                                    {{ $area->area_name }} - {{ $area->city }}
                                </option>
                            @endforeach
                        </select>
                        @error('court_area_id')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="judge_id" class="form-label">Assigned Judge</label>
                        <select name="judge_id" id="judge_id" class="form-select">
                            <option value="">Select judge</option>
                            @foreach($judges as $judge)
                                <option value="{{ $judge->judge_code }}" {{ old('judge_id') == $judge->judge_code ? 'selected' : '' }}>
                                    {{ $judge->judge_name }}
                                </option>
                            @endforeach
                        </select>
                        @error('judge_id')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Status Tracking --}}
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V9a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4" />
                    </svg>
                    Status Tracking
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="filing_status_id" class="form-label">Filing Status <span class="required">*</span></label>
                        <select name="filing_status_id" id="filing_status_id" class="form-select" required>
                            <option value="">Select filing status</option>
                            @foreach($filingStatuses as $status)
                                <option value="{{ $status->id }}" {{ old('filing_status_id') == $status->id ? 'selected' : '' }}>
                                    {{ $status->status_name }}
                                </option>
                            @endforeach
                        </select>
                        <div id="status-badge"></div>
                        @error('filing_status_id')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="court_acknowledgment" class="form-label">Court Acknowledgment</label>
                        <input type="date" name="court_acknowledgment" id="court_acknowledgment" value="{{ old('court_acknowledgment') }}" class="form-input" />
                        @error('court_acknowledgment')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field form-grid-full">
                        <label for="next_action" class="form-label">Next Action / Follow-Up</label>
                        <input type="text" name="next_action" id="next_action" value="{{ old('next_action') }}" placeholder="e.g., Serve Opposing Party, Prepare Response" class="form-input" />
                        @error('next_action')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Assignment & Notes --}}
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                    Assignment & Notes
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="assigned_lawyers" class="form-label">Assigned Lawyer(s)</label>
                        <select name="assigned_lawyers[]" id="assigned_lawyers" multiple class="form-select" style="min-height: 140px; padding: 0.5rem;">
                            @foreach($lawyers as $lawyer)
                                <option value="{{ $lawyer->id }}" {{ (collect(old('assigned_lawyers'))->contains($lawyer->id)) ? 'selected' : '' }}>
                                    {{ $lawyer->name }}
                                </option>
                            @endforeach
                        </select>
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Hold Ctrl/Cmd to select multiple lawyers
                        </div>
                        @error('assigned_lawyers')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field">
                        <label for="internal_notes" class="form-label">Internal Notes</label>
                        <textarea name="internal_notes" id="internal_notes" placeholder="Special handling notes, reminders, or client instructions" maxlength="1000" class="form-textarea">{{ old('internal_notes') }}</textarea>
                        <div class="char-counter" data-field="internal_notes">0 / 1000</div>
                        @error('internal_notes')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-field form-grid-full">
                        <label for="external_notes" class="form-label">External Notes</label>
                        <textarea name="external_notes" id="external_notes" placeholder="Notes intended for client or co-counsel communication" maxlength="500" class="form-textarea" style="min-height: 80px;">{{ old('external_notes') }}</textarea>
                        <div class="char-counter" data-field="external_notes">0 / 500</div>
                        @error('external_notes')
                            <div class="warning-message error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        {{-- Action Bar --}}
        <div class="action-bar">
            <div class="action-info">
                <div class="info-item">
                    <svg class="info-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Required fields marked with *
                </div>
                <div class="info-item">
                    <svg class="info-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                    Data will be securely saved
                </div>
            </div>
            <div class="action-buttons">
                <button type="button" data-reset-form class="btn btn-secondary">
                    <svg class="btn-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                    </svg>
                    Reset Form
                </button>
                <a href="{{ route('court-filings.index') }}" class="btn btn-danger">
                    <svg class="btn-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <svg class="btn-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                    </svg>
                    Save Filing
                </button>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
    <script src="{{ asset('js/court-filings.js') }}"></script>
@endpush
