@extends('layouts.master')

@section('title', 'Edit Court Filing - Prolex Law Firm')

@section('content')
<div class="p-10 max-w-6xl mx-auto">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-4xl font-bold text-gray-800">Edit Court Filing</h1>
        <div class="flex space-x-4">
            <a href="{{ route('court-filings.show', $courtFiling->id) }}" class="bg-gray-600 text-white px-6 py-3 rounded-lg hover:bg-gray-700 transition-colors flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                </svg>
                View Filing
            </a>
            <a href="{{ route('court-filings.index') }}" class="bg-gray-600 text-white px-6 py-3 rounded-lg hover:bg-gray-700 transition-colors flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Back to Filings
            </a>
        </div>
    </div>

    <form action="{{ route('court-filings.update', $courtFiling->id) }}" method="POST" class="bg-white rounded-xl shadow-lg p-8 space-y-6">
        @csrf
        @method('PUT')

        <fieldset class="border border-gray-300 rounded p-6">
            <legend class="font-semibold text-xl text-gray-800 px-2">Case Management Integration</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Link to Existing Case</label>
                    <select name="legal_case_id" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <option value="">Select a case (optional)</option>
                        @foreach($legalCases as $case)
                            <option value="{{ $case->id }}" {{ $courtFiling->legal_case_id == $case->id ? 'selected' : '' }}>
                                {{ $case->case_id }} - {{ $case->client_name }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-sm text-gray-500 mt-1">Link this filing to an existing case for better tracking</p>
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Case Reference (Manual)</label>
                    <input type="text" name="case_reference" value="{{ $courtFiling->case_reference }}" placeholder="Enter case reference manually" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" />
                    <p class="text-sm text-gray-500 mt-1">Use this if the case is not in the system yet</p>
                </div>
            </div>
        </fieldset>

        <fieldset class="border border-gray-300 rounded p-6">
            <legend class="font-semibold text-xl text-gray-800 px-2">Basic Filing Information</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Filing Title / Document Name *</label>
                    <input type="text" name="filing_title" value="{{ $courtFiling->filing_title }}" placeholder="e.g., Motion for Summary Judgment" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" required />
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Filing Type *</label>
                    <select name="filing_type" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                        <option value="">Select filing type</option>
                        <option value="Complaint" {{ $courtFiling->filing_type == 'Complaint' ? 'selected' : '' }}>Complaint</option>
                        <option value="Motion" {{ $courtFiling->filing_type == 'Motion' ? 'selected' : '' }}>Motion</option>
                        <option value="Affidavit" {{ $courtFiling->filing_type == 'Affidavit' ? 'selected' : '' }}>Affidavit</option>
                        <option value="Appeal" {{ $courtFiling->filing_type == 'Appeal' ? 'selected' : '' }}>Appeal</option>
                        <option value="Brief" {{ $courtFiling->filing_type == 'Brief' ? 'selected' : '' }}>Brief</option>
                        <option value="Notice" {{ $courtFiling->filing_type == 'Notice' ? 'selected' : '' }}>Notice</option>
                        <option value="Petition" {{ $courtFiling->filing_type == 'Petition' ? 'selected' : '' }}>Petition</option>
                        <option value="Response" {{ $courtFiling->filing_type == 'Response' ? 'selected' : '' }}>Response</option>
                        <option value="Reply" {{ $courtFiling->filing_type == 'Reply' ? 'selected' : '' }}>Reply</option>
                        <option value="Other" {{ $courtFiling->filing_type == 'Other' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Court / Jurisdiction *</label>
                    <input type="text" name="court_jurisdiction" value="{{ $courtFiling->court_jurisdiction }}" placeholder="e.g., High Court – Civil Division" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" required />
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Filing Date *</label>
                    <input type="date" name="filing_date" value="{{ $courtFiling->filing_date->format('Y-m-d') }}" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" required />
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Due Date / Deadline</label>
                    <input type="date" name="due_date" value="{{ $courtFiling->due_date ? $courtFiling->due_date->format('Y-m-d') : '' }}" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" />
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Filed By / Responsible Staff *</label>
                    <input type="text" name="filed_by" value="{{ $courtFiling->filed_by }}" placeholder="Secretary, paralegal, or lawyer name" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" required />
                </div>
            </div>
        </fieldset>

        <fieldset class="border border-gray-300 rounded p-6">
            <legend class="font-semibold text-xl text-gray-800 px-2">Document Management</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Document Upload / Attachment</label>
                    <input type="file" name="document_path" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" />
                    <p class="text-sm text-gray-500 mt-1">Current: {{ $courtFiling->document_path ?: 'No document uploaded' }}</p>
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Version / Revision Number</label>
                    <input type="text" name="version" value="{{ $courtFiling->version }}" placeholder="e.g., v1.0, v1.1" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" />
                </div>
            </div>
        </fieldset>

        <fieldset class="border border-gray-300 rounded p-6">
            <legend class="font-semibold text-xl text-gray-800 px-2">Status Tracking</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Filing Status *</label>
                    <select name="filing_status" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                        <option value="draft" {{ $courtFiling->filing_status == 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="ready for filing" {{ $courtFiling->filing_status == 'ready for filing' ? 'selected' : '' }}>Ready for Filing</option>
                        <option value="filed" {{ $courtFiling->filing_status == 'filed' ? 'selected' : '' }}>Filed</option>
                        <option value="rejected" {{ $courtFiling->filing_status == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        <option value="awaiting response" {{ $courtFiling->filing_status == 'awaiting response' ? 'selected' : '' }}>Awaiting Response</option>
                    </select>
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Court Acknowledgment</label>
                    <input type="date" name="court_acknowledgment" value="{{ $courtFiling->court_acknowledgment ? $courtFiling->court_acknowledgment->format('Y-m-d') : '' }}" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" />
                </div>
                <div class="md:col-span-2">
                    <label class="block mb-2 font-medium text-gray-700">Next Action / Follow-Up</label>
                    <input type="text" name="next_action" value="{{ $courtFiling->next_action }}" placeholder="e.g., Serve Opposing Party, Prepare Response" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" />
                </div>
            </div>
        </fieldset>

        <fieldset class="border border-gray-300 rounded p-6">
            <legend class="font-semibold text-xl text-gray-800 px-2">Assignment & Notes</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Assigned Lawyer(s)</label>
                    <select name="assigned_lawyers[]" multiple class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        @foreach($lawyers as $lawyer)
                            <option value="{{ $lawyer->id }}" {{ $courtFiling->assigned_lawyers && in_array($lawyer->id, $courtFiling->assigned_lawyers) ? 'selected' : '' }}>
                                {{ $lawyer->name }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-sm text-gray-500 mt-1">Hold Ctrl/Cmd to select multiple lawyers</p>
                </div>
                <div>
                    <label class="block mb-2 font-medium text-gray-700">Internal Notes / Instructions</label>
                    <textarea name="internal_notes" placeholder="Special handling notes, reminders, or client instructions" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" rows="4">{{ $courtFiling->internal_notes }}</textarea>
                </div>
                <div class="md:col-span-2">
                    <label class="block mb-2 font-medium text-gray-700">External Notes</label>
                    <textarea name="external_notes" placeholder="Notes intended for client or co-counsel communication (optional)" class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:ring-2 focus:ring-blue-500 focus:border-transparent" rows="4">{{ $courtFiling->external_notes }}</textarea>
                </div>
            </div>
        </fieldset>

        <div class="flex justify-end space-x-4 mt-8">
            <a href="{{ route('court-filings.show', $courtFiling->id) }}" class="bg-gray-500 text-white px-6 py-3 rounded-lg hover:bg-gray-600 transition-colors">Cancel</a>
            <button type="submit" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                </svg>
                Update Filing
            </button>
        </div>
    </form>
</div>
@endsection

