@extends('layouts.master')

@section('title', 'Court Filing Details - Prolex Law Firm')

@section('content')
<div class="p-10 max-w-6xl mx-auto">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-4xl font-bold text-gray-800">Court Filing Details</h1>
        <div class="flex space-x-4">
            <a href="{{ route('court-filings.edit', $courtFiling->id) }}" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                </svg>
                Edit Filing
            </a>
            <a href="{{ route('court-filings.index') }}" class="bg-gray-600 text-white px-6 py-3 rounded-lg hover:bg-gray-700 transition-colors flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Back to Filings
            </a>
        </div>
    </div>

    <div class="bg-white rounded-xl shadow-lg p-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Case Management Integration -->
            <div class="md:col-span-2">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Case Management Integration</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Linked Case</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">
                            @if($courtFiling->legalCase)
                                {{ $courtFiling->legalCase->case_id }} - {{ $courtFiling->legalCase->client_name }}
                            @else
                                No case linked
                            @endif
                        </p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Case Reference</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->case_reference ?: 'N/A' }}</p>
                    </div>
                </div>
            </div>

            <!-- Basic Filing Information -->
            <div class="md:col-span-2">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Basic Filing Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filing Title</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->filing_title }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filing Type</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->filing_type }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Court / Jurisdiction</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->court_jurisdiction }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filing Date</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->filing_date->format('M d, Y') }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Due Date</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->due_date ? $courtFiling->due_date->format('M d, Y') : 'N/A' }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filed By</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->filed_by }}</p>
                    </div>
                </div>
            </div>

            <!-- Document Management -->
            <div class="md:col-span-2">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Document Management</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Document Path</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->document_path ?: 'No document uploaded' }}</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Version</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->version ?: 'N/A' }}</p>
                    </div>
                </div>
            </div>

            <!-- Status Tracking -->
            <div class="md:col-span-2">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Status Tracking</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Filing Status</label>
                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                            @if($courtFiling->filing_status == 'draft') bg-yellow-100 text-yellow-800
                            @elseif($courtFiling->filing_status == 'filed') bg-green-100 text-green-800
                            @elseif($courtFiling->filing_status == 'rejected') bg-red-100 text-red-800
                            @else bg-blue-100 text-blue-800 @endif">
                            {{ ucfirst($courtFiling->filing_status) }}
                        </span>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Court Acknowledgment</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->court_acknowledgment ? $courtFiling->court_acknowledgment->format('M d, Y') : 'N/A' }}</p>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Next Action</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->next_action ?: 'N/A' }}</p>
                    </div>
                </div>
            </div>

            <!-- Assignment & Notes -->
            <div class="md:col-span-2">
                <h3 class="text-xl font-semibold text-gray-800 mb-4 border-b pb-2">Assignment & Notes</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Assigned Lawyers</label>
                        <div class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg">
                            @if($courtFiling->assigned_lawyers && count($courtFiling->assigned_lawyers) > 0)
                                <ul class="list-disc list-inside">
                                    @foreach($courtFiling->assigned_lawyers as $lawyerId)
                                        @php
                                            $lawyer = \App\Models\Lawyer::find($lawyerId);
                                        @endphp
                                        @if($lawyer)
                                            <li>{{ $lawyer->name }}</li>
                                        @endif
                                    @endforeach
                                </ul>
                            @else
                                No lawyers assigned
                            @endif
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Internal Notes</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg whitespace-pre-wrap">{{ $courtFiling->internal_notes ?: 'N/A' }}</p>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 mb-2">External Notes</label>
                        <p class="text-gray-900 bg-gray-50 px-4 py-2 rounded-lg whitespace-pre-wrap">{{ $courtFiling->external_notes ?: 'N/A' }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Timestamps -->
        <div class="mt-8 pt-6 border-t border-gray-200">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Created At</label>
                    <p class="text-gray-600 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->created_at->format('M d, Y H:i') }}</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Last Updated</label>
                    <p class="text-gray-600 bg-gray-50 px-4 py-2 rounded-lg">{{ $courtFiling->updated_at->format('M d, Y H:i') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

