@extends('layouts.master')

@section('title', 'Create New Assignment - Prolex Law Firm')

@section('content')
<style>
    .assignment-container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        padding: 25px;
        border-radius: 10px;
        margin-bottom: 25px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .section-title {
        color: #374151;
        font-size: 1.3rem;
        font-weight: 600;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #3b82f6;
        display: flex;
        align-items: center;
    }

    .section-title i {
        margin-right: 10px;
        color: #3b82f6;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-bottom: 20px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group.full-width {
        grid-column: 1 / -1;
    }

    label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        font-size: 0.95rem;
    }

    input, select, textarea {
        padding: 12px 16px;
        border: 2px solid #d1d5db;
        border-radius: 8px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #fff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        min-height: 100px;
        resize: vertical;
    }

    .priority-indicator {
        display: inline-flex;
        align-items: center;
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .priority-low {
        background-color: #dcfce7;
        color: #166534;
    }

    .priority-medium {
        background-color: #fef3c7;
        color: #92400e;
    }

    .priority-high {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .required {
        color: #dc2626;
        margin-left: 4px;
    }

    .form-actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 2px solid #e2e8f0;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
        transform: translateY(-1px);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-1px);
    }

    .help-text {
        font-size: 0.85rem;
        color: #6b7280;
        margin-top: 4px;
        font-style: italic;
    }

    .court-info {
        background: linear-gradient(135deg, #eff6ff, #dbeafe);
        border: 1px solid #3b82f6;
        border-radius: 8px;
        padding: 15px;
        margin-top: 10px;
    }

    .court-info-title {
        font-weight: 600;
        color: #1e40af;
        margin-bottom: 10px;
    }

    @media (max-width: 768px) {
        .form-row {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
            gap: 15px;
        }

        .assignment-container {
            margin: 20px;
            padding: 20px;
        }
    }
</style>

<div class="assignment-container">
    <h1><i class="fas fa-tasks"></i>Create New Assignment</h1>

    <form action="{{ route('modules.processing.assignment.store') }}" method="POST" id="assignmentForm">
        @csrf

        <!-- Basic Assignment Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-info-circle"></i>
                Basic Information
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="assignment_title">Assignment Title <span class="required">*</span></label>
                    <input type="text" id="assignment_title" name="assignment_title" required
                           placeholder="Enter assignment title" value="{{ old('assignment_title') }}">
                    <div class="help-text">Brief, descriptive title for the assignment</div>
                </div>

                <div class="form-group">
                    <label for="lawyer_id">Assigned Lawyer <span class="required">*</span></label>
                    <select id="lawyer_id" name="lawyer_id" required>
                        <option value="">Select a lawyer</option>
                        @foreach($lawyers as $lawyer)
                            <option value="{{ $lawyer->id }}" {{ old('lawyer_id') == $lawyer->id ? 'selected' : '' }}>
                                {{ $lawyer->first_name }} {{ $lawyer->last_name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="help-text">Lawyer responsible for this assignment</div>
                </div>

                <div class="form-group">
                    <label for="task_type">Task Type <span class="required">*</span></label>
                    <select id="task_type" name="task_type" required>
                        <option value="">Select task type</option>
                        @foreach($taskTypes as $type)
                            <option value="{{ $type }}" {{ old('task_type') == $type ? 'selected' : '' }}>
                                {{ ucwords(str_replace('_', ' ', $type)) }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="priority">Priority <span class="required">*</span></label>
                    <select id="priority" name="priority" required>
                        <option value="">Select priority</option>
                        @foreach($priorities as $priority)
                            <option value="{{ $priority }}" {{ old('priority') == $priority ? 'selected' : '' }}>
                                {{ ucfirst($priority) }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <!-- Client & Case Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-users"></i>
                Client & Case Information
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="client_id">Client</label>
                    <select id="client_id" name="client_id">
                        <option value="">Select a client</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ old('client_id') == $client->id ? 'selected' : '' }}>
                                {{ $client->first_name }} {{ $client->last_name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="help-text">Client associated with this assignment</div>
                </div>

                <div class="form-group">
                    <label for="case_id">Related Case</label>
                    <select id="case_id" name="case_id">
                        <option value="">Select a case</option>
                        @foreach($cases as $case)
                            <option value="{{ $case->id }}" {{ old('case_id') == $case->id ? 'selected' : '' }}>
                                {{ $case->case_number }} - {{ $case->case_title }}
                            </option>
                        @endforeach
                    </select>
                    <div class="help-text">Legal case related to this assignment</div>
                </div>

                <div class="form-group">
                    <label for="case_type_id">Case Type</label>
                    <select id="case_type_id" name="case_type_id">
                        <option value="">Select case type</option>
                        @foreach($caseTypes as $type)
                            <option value="{{ $type->id }}" {{ old('case_type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->type_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="case_category_id">Case Category</label>
                    <select id="case_category_id" name="case_category_id">
                        <option value="">Select case category</option>
                        @foreach($caseCategories as $category)
                            <option value="{{ $category->id }}" {{ old('case_category_id') == $category->id ? 'selected' : '' }}>
                                {{ $category->category_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <!-- Due Date & Time -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-calendar-alt"></i>
                Schedule & Deadlines
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="due_date">Due Date <span class="required">*</span></label>
                    <input type="date" id="due_date" name="due_date" required value="{{ old('due_date') }}">
                </div>

                <div class="form-group">
                    <label for="due_time">Due Time</label>
                    <input type="time" id="due_time" name="due_time" value="{{ old('due_time') }}">
                    <div class="help-text">Leave blank for end of day deadline</div>
                </div>

                <div class="form-group">
                    <label for="estimated_hours">Estimated Hours</label>
                    <input type="number" id="estimated_hours" name="estimated_hours" step="0.5" min="0.5" max="100"
                           placeholder="0.0" value="{{ old('estimated_hours') }}">
                    <div class="help-text">Estimated time required to complete</div>
                </div>

                <div class="form-group">
                    <label for="status">Status <span class="required">*</span></label>
                    <select id="status" name="status" required>
                        <option value="pending" {{ old('status', 'pending') == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Description & Instructions -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-file-alt"></i>
                Description & Instructions
            </h2>

            <div class="form-row">
                <div class="form-group full-width">
                    <label for="description">Assignment Description <span class="required">*</span></label>
                    <textarea id="description" name="description" required
                              placeholder="Detailed description of the assignment...">{{ old('description') }}</textarea>
                    <div class="help-text">Comprehensive description of what needs to be accomplished</div>
                </div>

                <div class="form-group full-width">
                    <label for="instructions">Special Instructions</label>
                    <textarea id="instructions" name="instructions"
                              placeholder="Any special instructions or requirements...">{{ old('instructions') }}</textarea>
                    <div class="help-text">Specific instructions, preferences, or special requirements</div>
                </div>

                <div class="form-group full-width">
                    <label for="documents_required">Documents Required</label>
                    <textarea id="documents_required" name="documents_required"
                              placeholder="List any documents needed for this assignment...">{{ old('documents_required') }}</textarea>
                    <div class="help-text">Documents, files, or materials required to complete the assignment</div>
                </div>
            </div>
        </div>

        <!-- Court Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-gavel"></i>
                Court Information
            </h2>

            <div class="court-info">
                <div class="court-info-title">Court Details (if applicable)</div>
                <div class="form-row">
                    <div class="form-group">
                        <label for="court_date">Court Date</label>
                        <input type="date" id="court_date" name="court_date" value="{{ old('court_date') }}">
                    </div>

                    <div class="form-group">
                        <label for="court_time">Court Time</label>
                        <input type="time" id="court_time" name="court_time" value="{{ old('court_time') }}">
                    </div>

                    <div class="form-group">
                        <label for="court_location">Court Location</label>
                        <input type="text" id="court_location" name="court_location"
                               placeholder="Court name and address" value="{{ old('court_location') }}">
                    </div>

                    <div class="form-group">
                        <label for="opposing_counsel">Opposing Counsel</label>
                        <input type="text" id="opposing_counsel" name="opposing_counsel"
                               placeholder="Name of opposing counsel" value="{{ old('opposing_counsel') }}">
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-phone"></i>
                Contact & Billing Information
            </h2>

            <div class="form-row">
                <div class="form-group full-width">
                    <label for="client_contact_info">Client Contact Information</label>
                    <textarea id="client_contact_info" name="client_contact_info"
                              placeholder="Client contact details, phone numbers, email addresses...">{{ old('client_contact_info') }}</textarea>
                    <div class="help-text">Client contact information relevant to this assignment</div>
                </div>

                <div class="form-group full-width">
                    <label for="billing_notes">Billing Notes</label>
                    <textarea id="billing_notes" name="billing_notes"
                              placeholder="Any billing-related notes or special arrangements...">{{ old('billing_notes') }}</textarea>
                    <div class="help-text">Notes for billing department or special billing arrangements</div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="form-actions">
            <a href="{{ route('modules.processing.task-management') }}" class="btn btn-secondary">
                <i class="fas fa-times"></i>
                Cancel
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i>
                Create Assignment
            </button>
        </div>
    </form>
</div>

<script>
    // Form validation and enhancement
    document.getElementById('assignmentForm').addEventListener('submit', function(e) {
        const requiredFields = ['assignment_title', 'lawyer_id', 'task_type', 'priority', 'due_date', 'description', 'status'];
        let isValid = true;

        requiredFields.forEach(field => {
            const element = document.getElementById(field);
            if (!element.value.trim()) {
                element.style.borderColor = '#dc2626';
                isValid = false;
            } else {
                element.style.borderColor = '#d1d5db';
            }
        });

        if (!isValid) {
            e.preventDefault();
            alert('Please fill in all required fields.');
        }
    });

    // Priority color indicators
    document.getElementById('priority').addEventListener('change', function() {
        const priority = this.value;
        const indicators = document.querySelectorAll('.priority-indicator');
        indicators.forEach(indicator => indicator.remove());

        if (priority) {
            const indicator = document.createElement('span');
            indicator.className = `priority-indicator priority-${priority}`;
            indicator.textContent = priority.toUpperCase();
            this.parentNode.appendChild(indicator);
        }
    });

    // Auto-populate client contact info when client is selected
    document.getElementById('client_id').addEventListener('change', function() {
        const clientId = this.value;
        if (clientId) {
            // In a real application, you would make an AJAX call to get client contact info
            // For now, we'll just show a placeholder
            const contactInfo = document.getElementById('client_contact_info');
            if (!contactInfo.value) {
                contactInfo.placeholder = 'Client contact information will be loaded...';
            }
        }
    });

    // Show/hide court information based on task type
    document.getElementById('task_type').addEventListener('change', function() {
        const taskType = this.value;
        const courtInfo = document.querySelector('.court-info');

        if (taskType === 'court_appearance') {
            courtInfo.style.display = 'block';
        } else {
            courtInfo.style.display = 'none';
        }
    });

    // Initialize form
    document.addEventListener('DOMContentLoaded', function() {
        // Trigger priority indicator if value exists
        const prioritySelect = document.getElementById('priority');
        if (prioritySelect.value) {
            prioritySelect.dispatchEvent(new Event('change'));
        }

        // Trigger task type check
        const taskTypeSelect = document.getElementById('task_type');
        if (taskTypeSelect.value) {
            taskTypeSelect.dispatchEvent(new Event('change'));
        }
    });
</script>
@endsection

