@extends('layouts.master')

@section('title', 'Diary Dashboard')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Diary Dashboard</h3>
                    <div class="card-tools">
                        <a href="{{ route('modules.processing.diary.list') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-list"></i> View All Entries
                        </a>
                        <a href="{{ route('modules.processing.diary.add') }}" class="btn btn-success btn-sm">
                            <i class="fas fa-plus"></i> Add New Entry
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $todayEntries ?? 0 }}</h3>
                                    <p>Today's Entries</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-day"></i>
                                </div>
                                <a href="{{ route('modules.processing.diary.today') }}" class="small-box-footer">
                                    View Today <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>

                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $upcomingEntries ?? 0 }}</h3>
                                    <p>Upcoming Entries</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-plus"></i>
                                </div>
                                <a href="{{ route('modules.processing.diary.upcoming') }}" class="small-box-footer">
                                    View Upcoming <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>

                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $overdueEntries ?? 0 }}</h3>
                                    <p>Overdue Entries</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-times"></i>
                                </div>
                                <a href="{{ route('modules.processing.diary.overdue') }}" class="small-box-footer">
                                    View Overdue <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>

                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $totalEntries ?? 0 }}</h3>
                                    <p>Total Entries</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-alt"></i>
                                </div>
                                <a href="{{ route('modules.processing.diary.list') }}" class="small-box-footer">
                                    View All <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Entries -->
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Recent Entries</h3>
                                </div>
                                <div class="card-body">
                                    @if(isset($recentEntries) && $recentEntries->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>Date & Time</th>
                                                        <th>Task Title</th>
                                                        <th>Priority</th>
                                                        <th>Status</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($recentEntries as $entry)
                                                        <tr>
                                                            <td>
                                                                <div>{{ $entry->formatted_date }}</div>
                                                                <small class="text-muted">{{ $entry->formatted_time }}</small>
                                                            </td>
                                                            <td>{{ Str::limit($entry->task_title, 30) }}</td>
                                                            <td>
                                                                @if($entry->priority == 'high')
                                                                    <span class="badge badge-danger">{{ ucfirst($entry->priority) }}</span>
                                                                @elseif($entry->priority == 'medium')
                                                                    <span class="badge badge-warning">{{ ucfirst($entry->priority) }}</span>
                                                                @else
                                                                    <span class="badge badge-secondary">{{ ucfirst($entry->priority) }}</span>
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if($entry->status == 'completed')
                                                                    <span class="badge badge-success">{{ ucfirst($entry->status) }}</span>
                                                                @elseif($entry->status == 'in-progress')
                                                                    <span class="badge badge-primary">{{ ucfirst($entry->status) }}</span>
                                                                @elseif($entry->status == 'pending')
                                                                    <span class="badge badge-warning">{{ ucfirst($entry->status) }}</span>
                                                                @else
                                                                    <span class="badge badge-secondary">{{ ucfirst($entry->status) }}</span>
                                                                @endif
                                                            </td>
                                                            <td>
                                                                <a href="{{ route('modules.processing.diary.show', $entry->id) }}" class="btn btn-sm btn-info">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="text-center py-4">
                                            <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                                            <p class="text-muted">No recent entries found.</p>
                                            <a href="{{ route('modules.processing.diary.add') }}" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Add Your First Entry
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <!-- Quick Actions -->
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Quick Actions</h3>
                                </div>
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('modules.processing.diary.add') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add New Entry
                                        </a>
                                        <a href="{{ route('modules.processing.diary.today') }}" class="btn btn-info">
                                            <i class="fas fa-calendar-day"></i> Today's Tasks
                                        </a>
                                        <a href="{{ route('modules.processing.diary.upcoming') }}" class="btn btn-warning">
                                            <i class="fas fa-calendar-plus"></i> Upcoming Tasks
                                        </a>
                                        <a href="{{ route('modules.processing.diary.overdue') }}" class="btn btn-danger">
                                            <i class="fas fa-calendar-times"></i> Overdue Tasks
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <!-- Task Type Distribution -->
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Task Distribution</h3>
                                </div>
                                <div class="card-body">
                                    @php
                                        $taskTypes = ['meeting', 'court-filing', 'draft-review', 'call', 'follow-up', 'internal-task', 'other'];
                                        $typeCounts = [];
                                        foreach($taskTypes as $type) {
                                            $typeCounts[$type] = \App\Models\Diary::where('task_type', $type)->count();
                                        }
                                    @endphp

                                    @foreach($taskTypes as $type)
                                        @if($typeCounts[$type] > 0)
                                            <div class="progress-group mb-3">
                                                <span class="text-sm">{{ ucwords(str_replace('-', ' ', $type)) }}</span>
                                                <span class="float-right text-sm">{{ $typeCounts[$type] }}</span>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar bg-primary" style="width: {{ ($typeCounts[$type] / max($totalEntries ?? 1, 1)) * 100 }}%"></div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .small-box {
        border-radius: 0.25rem;
        margin-bottom: 1rem;
        position: relative;
        display: block;
        box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    }
    .small-box>.inner {
        padding: 10px;
    }
    .small-box h3 {
        font-size: 2.2rem;
        font-weight: bold;
        margin: 0 0 10px 0;
        white-space: nowrap;
        padding: 0;
    }
    .small-box p {
        font-size: 1rem;
    }
    .small-box .icon {
        color: rgba(0,0,0,0.15);
        z-index: 0;
        position: absolute;
        top: 20px;
        right: 20px;
        font-size: 70px;
    }
    .small-box-footer {
        position: relative;
        text-align: center;
        padding: 3px 0;
        color: #fff;
        color: rgba(255,255,255,0.8);
        display: block;
        z-index: 10;
        background: rgba(0,0,0,0.1);
        text-decoration: none;
    }
    .small-box-footer:hover {
        color: #fff;
        background: rgba(0,0,0,0.15);
    }
    .progress-group {
        margin-bottom: 1rem;
    }
    .progress-group .progress {
        margin-bottom: 0.25rem;
    }
</style>
@endpush

