@extends('layouts.master')

@section('title', 'Diary Management')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Diary Entries</h3>
                    <div class="card-tools">
                        <a href="{{ route('modules.processing.diary.calendar') }}" class="btn btn-success btn-sm">
                            <i class="fas fa-calendar-alt"></i> Calendar View
                        </a>
                        <a href="{{ route('modules.processing.diary.add') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Entry
                        </a>
                        <a href="{{ route('modules.processing.diary.dashboard') }}" class="btn btn-info btn-sm">
                            <i class="fas fa-chart-bar"></i> Dashboard
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filter Buttons -->
                    <div class="mb-3">
                        <div class="btn-group" role="group">
                            <a href="{{ route('modules.processing.diary.list') }}" class="btn btn-outline-primary {{ request()->routeIs('modules.processing.diary.list') ? 'active' : '' }}">All</a>
                            <a href="{{ route('modules.processing.diary.today') }}" class="btn btn-outline-success {{ request()->routeIs('modules.processing.diary.today') ? 'active' : '' }}">Today</a>
                            <a href="{{ route('modules.processing.diary.upcoming') }}" class="btn btn-outline-warning {{ request()->routeIs('modules.processing.diary.upcoming') ? 'active' : '' }}">Upcoming</a>
                            <a href="{{ route('modules.processing.diary.overdue') }}" class="btn btn-outline-danger {{ request()->routeIs('modules.processing.diary.overdue') ? 'active' : '' }}">Overdue</a>
                        </div>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Date & Time</th>
                                    <th>Task Title</th>
                                    <th>Client/Case</th>
                                    <th>Task Type</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Location</th>
                                    <th>Duration</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($diaryEntries ?? [] as $entry)
                                    <tr>
                                        <td>
                                            <div>{{ $entry->formatted_date }}</div>
                                            <small class="text-muted">{{ $entry->formatted_time }}</small>
                                        </td>
                                        <td>{{ $entry->task_title }}</td>
                                        <td>{{ $entry->client_case ?? '-' }}</td>
                                        <td>
                                            <span class="badge badge-info">{{ ucwords(str_replace('-', ' ', $entry->task_type)) }}</span>
                                        </td>
                                        <td>
                                            @if($entry->priority == 'high')
                                                <span class="badge badge-danger">{{ ucfirst($entry->priority) }}</span>
                                            @elseif($entry->priority == 'medium')
                                                <span class="badge badge-warning">{{ ucfirst($entry->priority) }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ ucfirst($entry->priority) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($entry->status == 'completed')
                                                <span class="badge badge-success">{{ ucfirst($entry->status) }}</span>
                                            @elseif($entry->status == 'in-progress')
                                                <span class="badge badge-primary">{{ ucfirst($entry->status) }}</span>
                                            @elseif($entry->status == 'pending')
                                                <span class="badge badge-warning">{{ ucfirst($entry->status) }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ ucfirst($entry->status) }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $entry->location ?? '-' }}</td>
                                        <td>{{ $entry->duration ?? '-' }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('modules.processing.diary.show', $entry->id) }}" class="btn btn-sm btn-info" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('modules.processing.diary.edit', $entry->id) }}" class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('modules.processing.diary.delete', $entry->id) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this entry?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">
                                            <div class="py-4">
                                                <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No diary entries found.</p>
                                                <a href="{{ route('modules.processing.diary.add') }}" class="btn btn-primary">
                                                    <i class="fas fa-plus"></i> Add Your First Entry
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if(isset($diaryEntries) && $diaryEntries->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $diaryEntries->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .badge {
        font-size: 0.75rem;
    }
    .table th {
        background-color: #f8f9fa;
        font-weight: 600;
    }
    .btn-group .btn {
        margin-right: 2px;
    }
    .btn-group .btn:last-child {
        margin-right: 0;
    }
</style>
@endpush

