@extends('layouts.master')

@section('title', 'Diary Entry Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Diary Entry Details</h3>
                    <div class="card-tools">
                        <a href="{{ route('modules.processing.diary.edit', $diaryEntry->id) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('modules.processing.diary.list') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <!-- Main Details -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-calendar-alt"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Date & Time</span>
                                            <span class="info-box-number">
                                                {{ $diaryEntry->formatted_date }}<br>
                                                <small>{{ $diaryEntry->formatted_time }}</small>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success"><i class="fas fa-tasks"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Task Title</span>
                                            <span class="info-box-number">{{ $diaryEntry->task_title }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-warning"><i class="fas fa-user"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Client/Case</span>
                                            <span class="info-box-number">{{ $diaryEntry->client_case ?? 'Not specified' }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-primary"><i class="fas fa-tag"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Task Type</span>
                                            <span class="info-box-number">{{ ucwords(str_replace('-', ' ', $diaryEntry->task_type)) }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-danger"><i class="fas fa-exclamation-triangle"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Priority</span>
                                            <span class="info-box-number">
                                                @if($diaryEntry->priority == 'high')
                                                    <span class="badge badge-danger">{{ ucfirst($diaryEntry->priority) }}</span>
                                                @elseif($diaryEntry->priority == 'medium')
                                                    <span class="badge badge-warning">{{ ucfirst($diaryEntry->priority) }}</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ ucfirst($diaryEntry->priority) }}</span>
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-check-circle"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Status</span>
                                            <span class="info-box-number">
                                                @if($diaryEntry->status == 'completed')
                                                    <span class="badge badge-success">{{ ucfirst($diaryEntry->status) }}</span>
                                                @elseif($diaryEntry->status == 'in-progress')
                                                    <span class="badge badge-primary">{{ ucfirst($diaryEntry->status) }}</span>
                                                @elseif($diaryEntry->status == 'pending')
                                                    <span class="badge badge-warning">{{ ucfirst($diaryEntry->status) }}</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ ucfirst($diaryEntry->status) }}</span>
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-secondary"><i class="fas fa-map-marker-alt"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Location</span>
                                            <span class="info-box-number">{{ $diaryEntry->location ? ucwords(str_replace('-', ' ', $diaryEntry->location)) : 'Not specified' }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-light"><i class="fas fa-clock"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Duration</span>
                                            <span class="info-box-number">{{ $diaryEntry->duration ?? 'Not specified' }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Notes Section -->
                            @if($diaryEntry->notes)
                                <div class="row">
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <h3 class="card-title">Notes</h3>
                                            </div>
                                            <div class="card-body">
                                                <p class="text-justify">{{ $diaryEntry->notes }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>

                        <div class="col-md-4">
                            <!-- Quick Actions -->
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Quick Actions</h3>
                                </div>
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('modules.processing.diary.edit', $diaryEntry->id) }}" class="btn btn-warning">
                                            <i class="fas fa-edit"></i> Edit Entry
                                        </a>
                                        <a href="{{ route('modules.processing.diary.add') }}" class="btn btn-success">
                                            <i class="fas fa-plus"></i> Add New Entry
                                        </a>
                                        <a href="{{ route('modules.processing.diary.dashboard') }}" class="btn btn-info">
                                            <i class="fas fa-chart-bar"></i> Dashboard
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <!-- Entry Information -->
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Entry Information</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm">
                                        <tr>
                                            <th>Created:</th>
                                            <td>{{ $diaryEntry->created_at->format('M d, Y H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Last Updated:</th>
                                            <td>{{ $diaryEntry->updated_at->format('M d, Y H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Entry ID:</th>
                                            <td>#{{ $diaryEntry->id }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <!-- Status Change -->
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Quick Status Update</h3>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('modules.processing.diary.update', $diaryEntry->id) }}" method="POST">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="task_title" value="{{ $diaryEntry->task_title }}">
                                        <input type="hidden" name="client_case" value="{{ $diaryEntry->client_case }}">
                                        <input type="hidden" name="task_type" value="{{ $diaryEntry->task_type }}">
                                        <input type="hidden" name="priority" value="{{ $diaryEntry->priority }}">
                                        <input type="hidden" name="location" value="{{ $diaryEntry->location }}">
                                        <input type="hidden" name="duration" value="{{ $diaryEntry->duration }}">
                                        <input type="hidden" name="notes" value="{{ $diaryEntry->notes }}">
                                        <input type="hidden" name="date_time" value="{{ $diaryEntry->date_time->format('Y-m-d\TH:i') }}">

                                        <div class="form-group">
                                            <label for="quick_status">Status</label>
                                            <select class="form-control" id="quick_status" name="status" onchange="this.form.submit()">
                                                <option value="pending" {{ $diaryEntry->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                                <option value="in-progress" {{ $diaryEntry->status == 'in-progress' ? 'selected' : '' }}>In Progress</option>
                                                <option value="completed" {{ $diaryEntry->status == 'completed' ? 'selected' : '' }}>Completed</option>
                                                <option value="deferred" {{ $diaryEntry->status == 'deferred' ? 'selected' : '' }}>Deferred</option>
                                            </select>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .info-box {
        box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
        border-radius: .25rem;
        margin-bottom: 1rem;
        background-color: #fff;
        display: flex;
        align-items: center;
    }
    .info-box-icon {
        border-top-left-radius: .25rem;
        border-bottom-left-radius: .25rem;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 70px;
        height: 70px;
    }
    .info-box-content {
        padding: 5px 10px;
        margin-left: 0;
        flex: 1;
    }
    .info-box-text {
        text-transform: uppercase;
        font-weight: 700;
        font-size: .875rem;
    }
    .info-box-number {
        font-size: 1.125rem;
        font-weight: 700;
    }
    .badge {
        font-size: 0.875rem;
    }
    .card-header {
        background-color: #f8f9fa;
    }
    .btn {
        margin-right: 0.25rem;
    }
    .btn:last-child {
        margin-right: 0;
    }
</style>
@endpush

