@extends('layouts.master')

@section('title', 'Edit Assignment - Prolex Law Firm')

@section('content')
<style>
    .assignment-container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        padding: 25px;
        border-radius: 10px;
        margin-bottom: 25px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .section-title {
        color: #374151;
        font-size: 1.3rem;
        font-weight: 600;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #3b82f6;
        display: flex;
        align-items: center;
    }

    .section-title i {
        margin-right: 10px;
        color: #3b82f6;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-bottom: 20px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group.full-width {
        grid-column: 1 / -1;
    }

    label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        font-size: 0.95rem;
    }

    input, select, textarea {
        padding: 12px 16px;
        border: 2px solid #d1d5db;
        border-radius: 8px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #fff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        min-height: 100px;
        resize: vertical;
    }

    .priority-indicator {
        display: inline-flex;
        align-items: center;
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .priority-low {
        background-color: #dcfce7;
        color: #166534;
    }

    .priority-medium {
        background-color: #fef3c7;
        color: #92400e;
    }

    .priority-high {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .required {
        color: #dc2626;
        margin-left: 4px;
    }

    .form-actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 2px solid #e2e8f0;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
        transform: translateY(-1px);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-1px);
    }

    .btn-info {
        background-color: #06b6d4;
        color: white;
    }

    .btn-info:hover {
        background-color: #0891b2;
        transform: translateY(-1px);
    }

    .help-text {
        font-size: 0.85rem;
        color: #6b7280;
        margin-top: 4px;
        font-style: italic;
    }

    .court-info {
        background: linear-gradient(135deg, #eff6ff, #dbeafe);
        border: 1px solid #3b82f6;
        border-radius: 8px;
        padding: 15px;
        margin-top: 10px;
    }

    .court-info-title {
        font-weight: 600;
        color: #1e40af;
        margin-bottom: 10px;
    }

    .progress-section {
        background: #f8fafc;
        padding: 15px;
        border-radius: 8px;
        border: 1px solid #e2e8f0;
        margin-top: 10px;
    }

    .progress-bar {
        width: 100%;
        height: 12px;
        background: #e2e8f0;
        border-radius: 6px;
        overflow: hidden;
    }

    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #3b82f6, #1e40af);
        border-radius: 6px;
        transition: width 0.3s ease;
    }

    .progress-text {
        text-align: center;
        font-size: 0.9rem;
        font-weight: 600;
        color: #374151;
        margin-top: 8px;
    }

    .current-info {
        background: #f0fdf4;
        border: 1px solid #22c55e;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 15px;
    }

    .current-info-title {
        font-weight: 600;
        color: #15803d;
        margin-bottom: 10px;
    }

    @media (max-width: 768px) {
        .form-row {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
            gap: 15px;
        }

        .assignment-container {
            margin: 20px;
            padding: 20px;
        }
    }
</style>

<div class="assignment-container">
    <h1><i class="fas fa-edit"></i>Edit Assignment</h1>

    <!-- Current Assignment Info -->
    <div class="current-info">
        <div class="current-info-title">Current Assignment: {{ $assignment->assignment_title }}</div>
        <div style="display: flex; gap: 20px; flex-wrap: wrap;">
            <span><strong>Status:</strong> {{ ucfirst(str_replace('_', ' ', $assignment->status)) }}</span>
            <span><strong>Priority:</strong> {{ ucfirst($assignment->priority) }}</span>
            <span><strong>Due:</strong> {{ $assignment->due_datetime->format('M d, Y H:i') }}</span>
            <span><strong>Progress:</strong> {{ $assignment->progress_percentage }}%</span>
        </div>
    </div>

    <form action="{{ route('modules.processing.assignment.update', $assignment->id) }}" method="POST" id="assignmentForm">
        @csrf
        @method('PUT')

        <!-- Basic Assignment Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-info-circle"></i>
                Basic Information
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="assignment_title">Assignment Title <span class="required">*</span></label>
                    <input type="text" id="assignment_title" name="assignment_title" required
                           placeholder="Enter assignment title" value="{{ old('assignment_title', $assignment->assignment_title) }}">
                    <div class="help-text">Brief, descriptive title for the assignment</div>
                </div>

                <div class="form-group">
                    <label for="lawyer_id">Assigned Lawyer <span class="required">*</span></label>
                    <select id="lawyer_id" name="lawyer_id" required>
                        <option value="">Select a lawyer</option>
                        @foreach($lawyers as $lawyer)
                            <option value="{{ $lawyer->id }}" {{ (old('lawyer_id', $assignment->lawyer_id) == $lawyer->id) ? 'selected' : '' }}>
                                {{ $lawyer->first_name }} {{ $lawyer->last_name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="help-text">Lawyer responsible for this assignment</div>
                </div>

                <div class="form-group">
                    <label for="task_type">Task Type <span class="required">*</span></label>
                    <select id="task_type" name="task_type" required>
                        <option value="">Select task type</option>
                        @foreach($taskTypes as $type)
                            <option value="{{ $type }}" {{ (old('task_type', $assignment->task_type) == $type) ? 'selected' : '' }}>
                                {{ ucwords(str_replace('_', ' ', $type)) }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="priority">Priority <span class="required">*</span></label>
                    <select id="priority" name="priority" required>
                        <option value="">Select priority</option>
                        @foreach($priorities as $priority)
                            <option value="{{ $priority }}" {{ (old('priority', $assignment->priority) == $priority) ? 'selected' : '' }}>
                                {{ ucfirst($priority) }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <!-- Client & Case Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-users"></i>
                Client & Case Information
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="client_id">Client</label>
                    <select id="client_id" name="client_id">
                        <option value="">Select a client</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ (old('client_id', $assignment->client_id) == $client->id) ? 'selected' : '' }}>
                                {{ $client->first_name }} {{ $client->last_name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="help-text">Client associated with this assignment</div>
                </div>

                <div class="form-group">
                    <label for="case_id">Related Case</label>
                    <select id="case_id" name="case_id">
                        <option value="">Select a case</option>
                        @foreach($cases as $case)
                            <option value="{{ $case->id }}" {{ (old('case_id', $assignment->case_id) == $case->id) ? 'selected' : '' }}>
                                {{ $case->case_number }} - {{ $case->case_title }}
                            </option>
                        @endforeach
                    </select>
                    <div class="help-text">Legal case related to this assignment</div>
                </div>

                <div class="form-group">
                    <label for="case_type_id">Case Type</label>
                    <select id="case_type_id" name="case_type_id">
                        <option value="">Select case type</option>
                        @foreach($caseTypes as $type)
                            <option value="{{ $type->id }}" {{ (old('case_type_id', $assignment->case_type_id) == $type->id) ? 'selected' : '' }}>
                                {{ $type->type_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="case_category_id">Case Category</label>
                    <select id="case_category_id" name="case_category_id">
                        <option value="">Select case category</option>
                        @foreach($caseCategories as $category)
                            <option value="{{ $category->id }}" {{ (old('case_category_id', $assignment->case_category_id) == $category->id) ? 'selected' : '' }}>
                                {{ $category->category_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <!-- Due Date & Time -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-calendar-alt"></i>
                Schedule & Deadlines
            </h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="due_date">Due Date <span class="required">*</span></label>
                    <input type="date" id="due_date" name="due_date" required
                           value="{{ old('due_date', $assignment->due_datetime->format('Y-m-d')) }}">
                </div>

                <div class="form-group">
                    <label for="due_time">Due Time</label>
                    <input type="time" id="due_time" name="due_time"
                           value="{{ old('due_time', $assignment->due_datetime->format('H:i')) }}">
                    <div class="help-text">Leave blank for end of day deadline</div>
                </div>

                <div class="form-group">
                    <label for="estimated_hours">Estimated Hours</label>
                    <input type="number" id="estimated_hours" name="estimated_hours" step="0.5" min="0.5" max="100"
                           placeholder="0.0" value="{{ old('estimated_hours', $assignment->estimated_hours) }}">
                    <div class="help-text">Estimated time required to complete</div>
                </div>

                <div class="form-group">
                    <label for="status">Status <span class="required">*</span></label>
                    <select id="status" name="status" required>
                        <option value="pending" {{ (old('status', $assignment->status) == 'pending') ? 'selected' : '' }}>Pending</option>
                        <option value="in_progress" {{ (old('status', $assignment->status) == 'in_progress') ? 'selected' : '' }}>In Progress</option>
                        <option value="completed" {{ (old('status', $assignment->status) == 'completed') ? 'selected' : '' }}>Completed</option>
                        <option value="cancelled" {{ (old('status', $assignment->status) == 'cancelled') ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>
            </div>

            <!-- Progress Section -->
            <div class="progress-section">
                <label for="progress_percentage">Progress Percentage</label>
                <div class="form-row" style="margin-bottom: 10px;">
                    <div class="form-group" style="flex: 1;">
                        <input type="range" id="progress_percentage" name="progress_percentage" min="0" max="100"
                               value="{{ old('progress_percentage', $assignment->progress_percentage) }}"
                               oninput="updateProgressDisplay(this.value)">
                    </div>
                    <div class="form-group" style="width: 80px;">
                        <input type="number" id="progress_input" name="progress_percentage" min="0" max="100"
                               value="{{ old('progress_percentage', $assignment->progress_percentage) }}"
                               oninput="updateProgressSlider(this.value)">
                    </div>
                </div>
                <div class="progress-bar">
                    <div class="progress-fill" id="progressFill" style="width: {{ $assignment->progress_percentage }}%"></div>
                </div>
                <div class="progress-text" id="progressText">{{ $assignment->progress_percentage }}% Complete</div>
            </div>
        </div>

        <!-- Description & Instructions -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-file-alt"></i>
                Description & Instructions
            </h2>

            <div class="form-row">
                <div class="form-group full-width">
                    <label for="description">Assignment Description <span class="required">*</span></label>
                    <textarea id="description" name="description" required
                              placeholder="Detailed description of the assignment...">{{ old('description', $assignment->description) }}</textarea>
                    <div class="help-text">Comprehensive description of what needs to be accomplished</div>
                </div>

                <div class="form-group full-width">
                    <label for="instructions">Special Instructions</label>
                    <textarea id="instructions" name="instructions"
                              placeholder="Any special instructions or requirements...">{{ old('instructions', $assignment->instructions) }}</textarea>
                    <div class="help-text">Specific instructions, preferences, or special requirements</div>
                </div>

                <div class="form-group full-width">
                    <label for="documents_required">Documents Required</label>
                    <textarea id="documents_required" name="documents_required"
                              placeholder="List any documents needed for this assignment...">{{ old('documents_required', $assignment->documents_required) }}</textarea>
                    <div class="help-text">Documents, files, or materials required to complete the assignment</div>
                </div>
            </div>
        </div>

        <!-- Court Information -->
        <div class="form-section">
            <h2 class="section-title">
                <i class="fas fa-gavel"></i>
                Court Information
            </h2>

            <div class="court-info">
                <div class="court-info-title">Court Details (if applicable)</div>
                <div class="form-row">
                    <div class="form-group">
                        <label for="court_date">Court Date</label>
                        <input type="date" id="court_date" name="court_date"
                               value="{{ old('court_date', $assignment->court_datetime ? $assignment->court_datetime->format('Y-m-d') : '') }}">
                    </div>

                    <div class="form-group">
                        <label for="court_time">Court Time</label>
                        <input type="time" id="court_time" name="court_time"
                               value="{{ old('court_time', $assignment->court_datetime ? $assignment->court_datetime->format('H:i') : '') }}">
                    </div>

                    <div class="form-group">
                        <label for="court_location">Court Location</label>
                        <input type="text" id="court_location" name="court_location"
                               placeholder="Court name and address" value="{{ old('court_location', $assignment->court_location) }}">
                    </div>

                    <div class="form-group">
                        <label for="opposing_counsel">Opposing Counsel</label>
                        <input type="text" id="opposing_counsel" name="opposing_counsel"
                               placeholder="Name of opposing counsel" value="{{ old('opposing_counsel', $assignment->opposing_counsel) }}">
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Information -->
        <div class="form-section">
            <h2 class="section-title">

