@extends('layouts.master')

@section('title', 'Edit Diary Entry')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Diary Entry</h3>
                    <div class="card-tools">
                        <a href="{{ route('modules.processing.diary.show', $diaryEntry->id) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> View
                        </a>
                        <a href="{{ route('modules.processing.diary.list') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('modules.processing.diary.update', $diaryEntry->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-6">
                                <!-- Date and Time -->
                                <div class="form-group">
                                    <label for="date_time">Date & Time *</label>
                                    <input type="datetime-local" class="form-control @error('date_time') is-invalid @enderror"
                                           id="date_time" name="date_time"
                                           value="{{ old('date_time', $diaryEntry->date_time ? $diaryEntry->date_time->format('Y-m-d\TH:i') : '') }}" required>
                                    @error('date_time')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Task Title -->
                                <div class="form-group">
                                    <label for="task_title">Task Title *</label>
                                    <input type="text" class="form-control @error('task_title') is-invalid @enderror"
                                           id="task_title" name="task_title" value="{{ old('task_title', $diaryEntry->task_title) }}"
                                           placeholder="Enter task title" required>
                                    @error('task_title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Client/Case -->
                                <div class="form-group">
                                    <label for="client_case">Client/Case</label>
                                    <input type="text" class="form-control @error('client_case') is-invalid @enderror"
                                           id="client_case" name="client_case" value="{{ old('client_case', $diaryEntry->client_case) }}"
                                           placeholder="Enter client name or case reference">
                                    @error('client_case')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Task Type -->
                                <div class="form-group">
                                    <label for="task_type">Task Type *</label>
                                    <select class="form-control @error('task_type') is-invalid @enderror"
                                            id="task_type" name="task_type" required>
                                        <option value="">Select Task Type</option>
                                        <option value="meeting" {{ old('task_type', $diaryEntry->task_type) == 'meeting' ? 'selected' : '' }}>Meeting</option>
                                        <option value="court-filing" {{ old('task_type', $diaryEntry->task_type) == 'court-filing' ? 'selected' : '' }}>Court Filing</option>
                                        <option value="draft-review" {{ old('task_type', $diaryEntry->task_type) == 'draft-review' ? 'selected' : '' }}>Draft Review</option>
                                        <option value="call" {{ old('task_type', $diaryEntry->task_type) == 'call' ? 'selected' : '' }}>Phone Call</option>
                                        <option value="follow-up" {{ old('task_type', $diaryEntry->task_type) == 'follow-up' ? 'selected' : '' }}>Follow-up</option>
                                        <option value="internal-task" {{ old('task_type', $diaryEntry->task_type) == 'internal-task' ? 'selected' : '' }}>Internal Task</option>
                                        <option value="other" {{ old('task_type', $diaryEntry->task_type) == 'other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                    @error('task_type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <!-- Priority -->
                                <div class="form-group">
                                    <label for="priority">Priority *</label>
                                    <select class="form-control @error('priority') is-invalid @enderror"
                                            id="priority" name="priority" required>
                                        <option value="">Select Priority</option>
                                        <option value="low" {{ old('priority', $diaryEntry->priority) == 'low' ? 'selected' : '' }}>Low</option>
                                        <option value="medium" {{ old('priority', $diaryEntry->priority) == 'medium' ? 'selected' : '' }}>Medium</option>
                                        <option value="high" {{ old('priority', $diaryEntry->priority) == 'high' ? 'selected' : '' }}>High</option>
                                    </select>
                                    @error('priority')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Status -->
                                <div class="form-group">
                                    <label for="status">Status *</label>
                                    <select class="form-control @error('status') is-invalid @enderror"
                                            id="status" name="status" required>
                                        <option value="">Select Status</option>
                                        <option value="pending" {{ old('status', $diaryEntry->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="in-progress" {{ old('status', $diaryEntry->status) == 'in-progress' ? 'selected' : '' }}>In Progress</option>
                                        <option value="completed" {{ old('status', $diaryEntry->status) == 'completed' ? 'selected' : '' }}>Completed</option>
                                        <option value="deferred" {{ old('status', $diaryEntry->status) == 'deferred' ? 'selected' : '' }}>Deferred</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Location -->
                                <div class="form-group">
                                    <label for="location">Location</label>
                                    <select class="form-control @error('location') is-invalid @enderror"
                                            id="location" name="location">
                                        <option value="">Select Location</option>
                                        <option value="office" {{ old('location', $diaryEntry->location) == 'office' ? 'selected' : '' }}>Office</option>
                                        <option value="courtroom" {{ old('location', $diaryEntry->location) == 'courtroom' ? 'selected' : '' }}>Courtroom</option>
                                        <option value="online-meeting" {{ old('location', $diaryEntry->location) == 'online-meeting' ? 'selected' : '' }}>Online Meeting</option>
                                        <option value="phone-call" {{ old('location', $diaryEntry->location) == 'phone-call' ? 'selected' : '' }}>Phone Call</option>
                                        <option value="other" {{ old('location', $diaryEntry->location) == 'other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                    @error('location')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Duration -->
                                <div class="form-group">
                                    <label for="duration">Duration</label>
                                    <input type="text" class="form-control @error('duration') is-invalid @enderror"
                                           id="duration" name="duration" value="{{ old('duration', $diaryEntry->duration) }}"
                                           placeholder="e.g., 30 minutes, 1 hour, 2 hours">
                                    @error('duration')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Notes -->
                        <div class="form-group">
                            <label for="notes">Notes</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror"
                                      id="notes" name="notes" rows="4"
                                      placeholder="Additional notes or details about the task">{{ old('notes', $diaryEntry->notes) }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Form Actions -->
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Entry
                            </button>
                            <a href="{{ route('modules.processing.diary.show', $diaryEntry->id) }}" class="btn btn-info">
                                <i class="fas fa-eye"></i> View Details
                            </a>
                            <a href="{{ route('modules.processing.diary.list') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .form-group {
        margin-bottom: 1.5rem;
    }
    .card-header {
        background-color: #f8f9fa;
    }
    .btn {
        margin-right: 0.5rem;
    }
    .btn:last-child {
        margin-right: 0;
    }
</style>
@endpush

