@extends('layouts.master')

@section('title', 'Journal Processing - Prolex Law Firm')

@section('content')
<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0"><i class="fas fa-book-open me-2"></i>Journal Processing</h2>
        <a href="{{ route('modules.processing') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Processing Modules
        </a>
    </div>

    <!-- Journal Type Navigation -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-list me-2"></i>Select Journal Type</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <a href="{{ route('modules.processing.journals.client') }}" class="btn btn-outline-primary btn-lg w-100">
                                <i class="fas fa-users me-2"></i>
                                Client Journal
                            </a>
                        </div>
                        <div class="col-md-4 mb-3">
                            <a href="{{ route('modules.processing.journals.supplier') }}" class="btn btn-outline-success btn-lg w-100">
                                <i class="fas fa-truck me-2"></i>
                                Supplier Journal
                            </a>
                        </div>
                        <div class="col-md-4 mb-3">
                            <a href="{{ route('modules.processing.journals.general') }}" class="btn btn-outline-warning btn-lg w-100">
                                <i class="fas fa-book me-2"></i>
                                General Journal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Journal Entries Table -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-table me-2"></i>Recent Journal Entries</h5>
                    <div class="btn-group btn-group-sm">
                        <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown">
                            <i class="fas fa-filter me-1"></i>Filter
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="filterJournals('all')">All Entries</a></li>
                            <li><a class="dropdown-item" href="#" onclick="filterJournals('customer')">Customer</a></li>
                            <li><a class="dropdown-item" href="#" onclick="filterJournals('supplier')">Supplier</a></li>
                            <li><a class="dropdown-item" href="#" onclick="filterJournals('general')">General</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="journalEntriesTable">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Account Code</th>
                                    <th>Description</th>
                                    <th>Reference</th>
                                    <th>Debit</th>
                                    <th>Credit</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Sample data - In real implementation, this would be populated from database -->
                                <tr data-type="client">
                                    <td>{{ date('d/m/Y') }}</td>
                                    <td><span class="badge bg-primary">Client</span></td>
                                    <td>1100</td>
                                    <td>Client payment received</td>
                                    <td>REC-001</td>
                                    <td class="text-success">5,000.00</td>
                                    <td>-</td>
                                    <td><span class="badge bg-success">Processed</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-outline-secondary" title="Print">
                                            <i class="fas fa-print"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr data-type="supplier">
                                    <td>{{ date('d/m/Y', strtotime('-1 day')) }}</td>
                                    <td><span class="badge bg-success">Supplier</span></td>
                                    <td>2100</td>
                                    <td>Office supplies purchase</td>
                                    <td>INV-2024-001</td>
                                    <td>-</td>
                                    <td class="text-danger">1,250.00</td>
                                    <td><span class="badge bg-warning text-dark">Pending</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-outline-secondary" title="Print">
                                            <i class="fas fa-print"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr data-type="general">
                                    <td>{{ date('d/m/Y', strtotime('-2 days')) }}</td>
                                    <td><span class="badge bg-warning">General</span></td>
                                    <td>4100</td>
                                    <td>Bank charges</td>
                                    <td>BC-001</td>
                                    <td>-</td>
                                    <td class="text-danger">25.00</td>
                                    <td><span class="badge bg-success">Processed</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-outline-secondary" title="Print">
                                            <i class="fas fa-print"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr data-type="client">
                                    <td>{{ date('d/m/Y', strtotime('-3 days')) }}</td>
                                    <td><span class="badge bg-primary">Client</span></td>
                                    <td>1100</td>
                                    <td>Legal fees received</td>
                                    <td>LF-2024-001</td>
                                    <td class="text-success">15,000.00</td>
                                    <td>-</td>
                                    <td><span class="badge bg-success">Processed</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-outline-secondary" title="Print">
                                            <i class="fas fa-print"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination placeholder -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <p class="text-muted mb-0">Showing 4 of 4 entries</p>
                        <nav aria-label="Journal entries pagination">
                            <ul class="pagination pagination-sm mb-0">
                                <li class="page-item disabled">
                                    <span class="page-link">Previous</span>
                                </li>
                                <li class="page-item active">
                                    <span class="page-link">1</span>
                                </li>
                                <li class="page-item disabled">
                                    <span class="page-link">Next</span>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterJournals(type) {
    const table = document.getElementById('journalEntriesTable');
    const rows = table.querySelectorAll('tbody tr');

    rows.forEach(row => {
        if (type === 'all' || row.getAttribute('data-type') === type) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });

    // Update the filter button text
    const filterBtn = document.querySelector('.dropdown-toggle');
    const typeNames = {
        'all': 'All Entries',
        'customer': 'Customer',
        'supplier': 'Supplier',
        'general': 'General'
    };
    filterBtn.innerHTML = `<i class="fas fa-filter me-1"></i>${typeNames[type]}`;
}

// Auto-hide alerts after 5 seconds
setTimeout(() => {
    document.querySelectorAll('.alert').forEach(alert => alert.style.display = 'none');
}, 5000);
</script>

<style>
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}

.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}

.table th {
    background-color: #f8f9fa;
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table td {
    vertical-align: middle;
}

.table-responsive {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.badge {
    font-size: 0.75rem;
    padding: 0.35em 0.65em;
}

.btn-outline-primary:hover, .btn-outline-success:hover, .btn-outline-warning:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.15);
}

@media (max-width: 768px) {
    table.table {
        font-size: 0.85rem;
    }
    table.table th,
    table.table td {
        white-space: nowrap;
        padding: 0.5rem 0.25rem;
    }
    .btn-group-sm .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
    }
}

.text-success {
    color: #28a745 !important;
    font-weight: 600;
}

.text-danger {
    color: #dc3545 !important;
    font-weight: 600;
}
</style>
@endsection
