@extends('layouts.master')

@section('title', 'Supplier Journal - Prolex Law Firm')

@section('content')
@php
$PermissionsAdd = Auth::check() ? Auth::user()->hasPermission('add-journal') : false;
$PermissionsEdit = Auth::check() ? Auth::user()->hasPermission('edit-journal') : false;
$PermissionsDelete = Auth::check() ? Auth::user()->hasPermission('delete-journal') : false;
@endphp

<style>
    /* Modern UI Enhancements */
    body {
        background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
        min-height: 100vh;
    }

    .container-fluid {
        animation: fadeInUp 0.8s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Enhanced Page Heading */
    .page-heading {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        padding: 20px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
        animation: slideInLeft 0.6s ease forwards;
    }

    @keyframes slideInLeft {
        from {
            opacity: 0;
            transform: translateX(-50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .page-heading h1 {
        margin: 0;
        font-weight: 700;
        text-shadow: 0 2px 4px rgba(0,0,0,0.3);
    }

    /* Enhanced Cards */
    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(0,0,0,0.15);
    }

    .card-header {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-bottom: 2px solid #e2e8f0;
        padding: 20px;
    }

    .card-header h6 {
        color: #1e293b;
        font-weight: 600;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .card-header h6::before {
        content: "🧾";
        font-size: 1.2em;
    }

    .card-body {
        padding: 25px;
    }

    /* Enhanced Form Styling */
    .form-group {
        margin-bottom: 20px;
        position: relative;
    }

    .form-group label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .form-control {
        border: 2px solid #e5e7eb;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #f9fafb;
    }

    .form-control:focus {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        background: white;
        transform: translateY(-2px);
    }

    .form-control::placeholder {
        color: #9ca3af;
    }

    .form-select {
        border: 2px solid #e5e7eb;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 14px;
        transition: all 0.3s ease;
        background: #f9fafb;
    }

    .form-select:focus {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        background: white;
        transform: translateY(-2px);
    }

    /* Enhanced Buttons */
    .btn {
        border-radius: 10px;
        font-weight: 600;
        padding: 12px 24px;
        transition: all 0.3s ease;
        border: none;
        position: relative;
        overflow: hidden;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(59, 130, 246, 0.6);
    }

    .btn-secondary {
        background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
        box-shadow: 0 4px 15px rgba(107, 114, 128, 0.4);
    }

    .btn-secondary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(107, 114, 128, 0.6);
    }

    .btn-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
    }

    .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(16, 185, 129, 0.6);
    }

    .btn-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        box-shadow: 0 4px 15px rgba(239, 68, 68, 0.4);
    }

    .btn-danger:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(239, 68, 68, 0.6);
    }

    /* Enhanced Table */
    .table {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    .table thead th {
        background: linear-gradient(135deg, #1e40af 0%, #3b82f6 100%);
        color: white;
        border: none;
        padding: 15px 10px;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 0.5px;
    }

    .table tbody tr {
        transition: all 0.3s ease;
        border-bottom: 1px solid #f1f5f9;
    }

    .table tbody tr:hover {
        background: #f0f9ff;
        transform: scale(1.01);
    }

    .table tbody td {
        padding: 12px 10px;
        vertical-align: middle;
        border: none;
    }

    /* Enhanced Alerts */
    .alert {
        border-radius: 10px;
        border: none;
        padding: 15px 20px;
        margin-bottom: 20px;
        animation: slideInRight 0.5s ease forwards;
    }

    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .alert-success {
        background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%);
        color: #166534;
        border-left: 4px solid #16a34a;
    }

    /* Modal Enhancements */
    .modal-content {
        border-radius: 15px;
        border: none;
        box-shadow: 0 20px 40px rgba(0,0,0,0.2);
    }

    .modal-header {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        color: #991b1b;
        border-bottom: none;
        border-radius: 15px 15px 0 0;
        padding: 20px;
    }

    .modal-body {
        padding: 25px;
        font-size: 16px;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .container-fluid {
            padding: 15px;
        }

        .page-heading {
            padding: 15px;
            margin-bottom: 20px;
        }

        .card-body {
            padding: 15px;
        }

        .table-responsive {
            font-size: 12px;
        }

        .table thead th,
        .table tbody td {
            padding: 8px 5px;
        }

        .btn {
            padding: 10px 20px;
            font-size: 14px;
        }
    }

    /* Loading States */
    .loading {
        position: relative;
        pointer-events: none;
        opacity: 0.6;
    }

    .loading::after {
        content: "";
        position: absolute;
        top: 50%;
        left: 50%;
        width: 20px;
        height: 20px;
        margin: -10px 0 0 -10px;
        border: 2px solid #3b82f6;
        border-top: 2px solid transparent;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Tooltips */
    .tooltip-inner {
        background: #1e40af;
        border-radius: 8px;
        font-size: 12px;
    }

    .tooltip.bs-tooltip-top .arrow::before {
        border-top-color: #1e40af;
    }

    /* Enhanced Action Buttons */
    .btn-circle {
        border-radius: 50%;
        width: 35px;
        height: 35px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        margin: 0 2px;
        transition: all 0.3s ease;
    }

    .btn-circle:hover {
        transform: scale(1.1);
    }

    .btn-circle i {
        font-size: 14px;
    }
</style>

<div class="container-fluid">
    <!-- Enhanced Page Heading -->
    <div class="page-heading">
        <h1>Supplier Journal Management</h1>
    </div>

    <!-- Form Section - Full Width -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card shadow mb-4">
                <!-- Card Header -->
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary" id="formHeader">{{ isset($entry) ? 'Edit Journal Entry' : 'Process Journal Entry' }}</h6>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" id="successMessage" style="margin: 20px;">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="form-group" id="errorMessage" style="margin: 20px;">
                            <div class="card bg-warning text-white shadow">
                                <div class="card-body">
                                    @foreach ($errors->all() as $error)
                                        <div style="color: red;">{{ $error }}</div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif

                    <form method="POST" action="{{ isset($entry) ? route('supplier.journal.update', $entry->id) : route('supplier.journal.store') }}" id="journalForm">
                        @method(isset($entry) ? 'PUT' : 'POST')
                        @csrf

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="section-header">
                                    <i class="fas fa-book me-2"></i> Journal Details
                                </div>

                                <div class="form-group">
                                    <label for="account_code">Account Code</label>
                                    <input type="text" class="form-control" id="account_code" value="{{ $supplierAccount->code ?? '2100' }}" readonly>
                                </div>

                                <div class="form-group">
                                    <label for="date">Date <span class="text-danger">*</span></label>
                                    <input type="date" name="date" class="form-control" id="date" value="{{ isset($entry) ? $entry->date : now()->format('Y-m-d') }}" required>
                                </div>

                                <div class="form-group">
                                    <label for="narration">Narration <span class="text-danger">*</span></label>
                                    <input type="text" name="narration" class="form-control" id="narration" value="{{ isset($entry) ? $entry->narration : '' }}" placeholder="Enter narration" required>
                                </div>

                                <div class="form-group">
                                    <label for="supplier_id">Supplier Account <span class="text-danger">*</span></label>
                                    <select name="supplier_id" class="form-select" id="supplier_id" required>
                                        <option value="">Select Supplier Account</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ isset($entry) && $entry->supplier_id == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->supplier_code }} - {{ $supplier->full_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="section-header">
                                    <i class="fas fa-money-bill me-2"></i> Transaction Details
                                </div>

                                <div class="form-group">
                                    <label for="reference">Reference <span class="text-danger">*</span></label>
                                    <input type="text" name="reference" class="form-control" id="reference" value="{{ isset($entry) ? $entry->reference : '' }}" placeholder="Enter reference" required>
                                </div>

                                <div class="form-group">
                                    <label for="tr_code">TR Code <span class="text-danger">*</span></label>
                                    <select name="tr_code" class="form-select" id="tr_code" required>
                                        <option value="">Select TR Code</option>
                                        <option value="DR" {{ isset($entry) && $entry->tr_code == 'DR' ? 'selected' : '' }}>DR</option>
                                        <option value="CR" {{ isset($entry) && $entry->tr_code == 'CR' ? 'selected' : '' }}>CR</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="currency_id">Currency <span class="text-danger">*</span></label>
                                    <select name="currency_id" class="form-select" id="currency_id" required>
                                        <option value="">Select Currency</option>
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency->currency_id }}" {{ isset($entry) && $entry->currency_id == $currency->currency_id ? 'selected' : '' }}>
                                                {{ $currency->currency_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="amount">Amount <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" class="form-control" id="amount" value="{{ isset($entry) ? $entry->amount : '' }}" step="0.01" min="0.01" placeholder="00.00" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-success" id="processJournalBtn">
                                    <i class="fas fa-save"></i> {{ isset($entry) ? 'Update Entry' : 'Process Entry' }}
                                </button>
                                <a href="{{ route('modules.processing.journal') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Back to Journals
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Section - Full Width Below Form -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Supplier Journal Entries</h6>
                    @if($tempEntries->isNotEmpty())
                        <a href="#" class="btn btn-success btn-icon-split" style="float: right; margin-top: -5px;" onclick="processAll()">
                            <span class="icon text-white-50">
                                <i class="fas fa-check"></i>
                            </span>
                            <span class="text">Process All</span>
                        </a>
                    @endif
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 14px;">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Supplier Code</th>
                                    <th>Supplier Name</th>
                                    <th>Narration</th>
                                    <th>DR</th>
                                    <th>CR</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($tempEntries as $entry)
                                    <tr>
                                        <td>{{ date('d/m/Y', strtotime($entry->date)) }}</td>
                                        <td>{{ $entry->supplier->supplier_code }}</td>
                                        <td>{{ $entry->supplier->full_name }}</td>
                                        <td>{{ $entry->narration }}</td>
                                        <td>{{ $entry->tr_code === 'DR' ? number_format($entry->amount, 2) : '' }}</td>
                                        <td>{{ $entry->tr_code === 'CR' ? number_format($entry->amount, 2) : '' }}</td>
                                        <td>
                                            <span class="badge badge-{{ $entry->status == 'Processed' ? 'success' : 'warning' }}">
                                                {{ $entry->status }}
                                            </span>
                                        </td>
                                        <td style="justify-content: center; align-items: center;">
                                            @if($PermissionsDelete)
                                                <a href="#" style="height: 30px; width: 30px;" class="btn btn-danger btn-circle" onclick="confirmDelete('{{ $entry->id }}', '{{ route('supplier.journal.delete', $entry->id) }}'); return false;" title="Delete">
                                                    <i class="fas fa-trash" style="font-size: 0.8em;"></i>
                                                </a>
                                            @endif
                                            @if($entry->status !== 'Processed')
                                                <form action="{{ route('supplier.journal.processSingle', $entry->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success btn-circle" style="height: 30px; width: 30px;" title="Process">
                                                        <i class="fas fa-check" style="font-size: 0.8em;"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8">No journal entries found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmDeleteModal" tabindex="-1" role="dialog" aria-labelledby="confirmDeleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmDeleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this journal entry?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteButton">Delete</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // confirm delete
    window.confirmDelete = function(id, deleteUrl) {
        document.getElementById('confirmDeleteButton').onclick = function() {
            window.location.href = deleteUrl;
        };
        $('#confirmDeleteModal').modal('show');
    };

    // process all
    window.processAll = function() {
        if (confirm('Are you sure you want to process all entries?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '{{ route("supplier.journal.process") }}';
            const csrf = document.createElement('input');
            csrf.type = 'hidden';
            csrf.name = '_token';
            csrf.value = '{{ csrf_token() }}';
            form.appendChild(csrf);
            document.body.appendChild(form);
            form.submit();
        }
    };
});
</script>
@endsection

