@extends('layouts.master')

@section('title', 'Lawyer Details - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .details-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .detail-row {
        display: flex;
        justify-content: space-between;
        padding: 10px 0;
        border-bottom: 1px solid #e2e8f0;
    }

    .detail-row:last-child {
        border-bottom: none;
    }

    .detail-label {
        font-weight: 600;
        color: #4a5568;
        flex: 1;
    }

    .detail-value {
        color: #2d3748;
        flex: 2;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        display: inline-block;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(107, 114, 128, 0.3);
    }
</style>

<div class="container">
    <h1>Lawyer Details</h1>

    <a href="{{ route('modules.edit.lawyer-management') }}" class="back-btn">
        <i class="fas fa-arrow-left"></i> Back to Lawyer Management
    </a>

    <div class="details-section">
        <h2 class="section-title">Personal Information</h2>
        <div class="detail-row">
            <span class="detail-label">Lawyer ID:</span>
            <span class="detail-value">{{ $lawyer->lawyer_id }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">First Name:</span>
            <span class="detail-value">{{ $lawyer->first_name }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Last Name:</span>
            <span class="detail-value">{{ $lawyer->last_name }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Email:</span>
            <span class="detail-value">{{ $lawyer->email ?? 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Primary Phone:</span>
            <span class="detail-value">{{ $lawyer->phone_primary ?? 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Secondary Phone:</span>
            <span class="detail-value">{{ $lawyer->phone_secondary ?? 'N/A' }}</span>
        </div>
    </div>

    <div class="details-section">
        <h2 class="section-title">Professional Information</h2>
        <div class="detail-row">
            <span class="detail-label">Lawyer Group:</span>
            <span class="detail-value">{{ $lawyer->lawyerGroup ? $lawyer->lawyerGroup->group_name : 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Certificate Number:</span>
            <span class="detail-value">{{ $lawyer->certificate_number ?? 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Date of Admission:</span>
            <span class="detail-value">{{ $lawyer->date_of_admission ? $lawyer->date_of_admission->format('Y-m-d') : 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Status:</span>
            <span class="detail-value">{{ $lawyer->status }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Lawyer Type:</span>
            <span class="detail-value">{{ $lawyer->lawyer_type ?? 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Tariff:</span>
            <span class="detail-value">{{ $lawyer->lawyer_tier ?? 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Tier:</span>
            <span class="detail-value">{{ $lawyer->tier ?? 'N/A' }}</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Notes:</span>
            <span class="detail-value">{{ $lawyer->notes ?? 'N/A' }}</span>
        </div>
    </div>
</div>

@endsection
