@extends('layouts.master')

@section('title', 'Processing Options - Prolex Law Firm')

@section('content')
<div class="p-8 max-w-6xl mx-auto">
    <h1 class="text-3xl font-bold text-gray-800 mb-8">Processing Options</h1>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
        <!-- Client Management -->
        <a href="{{ route('modules.processing.client') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-users text-2xl text-blue-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Client Management</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage client invoices, receipts, and quotations.</p>
            <div class="w-full bg-blue-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-arrow-right mr-2"></i>Access Client Processing
            </div>
        </a>

        <!-- Diary Management -->
        <a href="{{ route('modules.processing.diary') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-calendar-alt text-2xl text-green-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Diary Management</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Schedule and manage case diaries and appointments.</p>
            <div class="w-full bg-green-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-arrow-right mr-2"></i>Access Diary Processing
            </div>
        </a>

        <!-- Case Processing -->
        <a href="{{ route('modules.processing.case') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-gavel text-2xl text-purple-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Case Processing</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Process and manage legal cases and assignments.</p>
            <div class="w-full bg-purple-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-arrow-right mr-2"></i>Access Case Processing
            </div>
        </a>

        <!-- Assignment Reports -->
        <a href="{{ route('modules.processing.assignment.reports') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-chart-bar text-2xl text-red-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Assignment Reports</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Generate and view assignment reports.</p>
            <div class="w-full bg-red-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-arrow-right mr-2"></i>View Reports
            </div>
        </a>

        <!-- Court Filings -->
        <a href="{{ route('modules.processing.court-filings') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-file-contract text-2xl text-indigo-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Court Filings</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage court filings and legal documents.</p>
            <div class="w-full bg-indigo-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-arrow-right mr-2"></i>Access Court Filings
            </div>
        </a>

        <!-- Supplier Processing -->
        <a href="{{ route('modules.processing.supplier') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-truck text-2xl text-teal-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Supplier Processing</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage supplier accounts and transactions.</p>
            <div class="w-full bg-teal-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-arrow-right mr-2"></i>Access Supplier Processing
            </div>
        </a>

        <!-- Client Invoice -->
        <a href="{{ route('modules.processing.client-invoice') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-file-invoice-dollar text-2xl text-cyan-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Client Invoice</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Create and manage client invoices.</p>
            <div class="w-full bg-cyan-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-plus mr-2"></i>Manage Invoices
            </div>
        </a>

        <!-- Client Receipt -->
        <a href="{{ route('modules.processing.client-receipt') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-receipt text-2xl text-emerald-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Client Receipt</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Process client payments and receipts.</p>
            <div class="w-full bg-emerald-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-plus mr-2"></i>Manage Receipts
            </div>
        </a>

        <!-- Supplier Invoice -->
        <a href="{{ route('modules.processing.supplier-invoice') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-file-invoice text-2xl text-orange-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Supplier Invoice</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage supplier invoices and payments.</p>
            <div class="w-full bg-orange-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-plus mr-2"></i>Manage Supplier Invoices
            </div>
        </a>

        <!-- Cash Book -->
        <a href="{{ route('modules.processing.cash-book') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-cash-register text-2xl text-yellow-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Cash Book</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage cash transactions and records.</p>
            <div class="w-full bg-yellow-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-book mr-2"></i>Access Cash Book
            </div>
        </a>

        <!-- Journal -->
        <a href="{{ route('modules.processing.journal') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-book-open text-2xl text-pink-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Journal</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage general journal entries.</p>
            <div class="w-full bg-pink-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-edit mr-2"></i>Access Journal
            </div>
        </a>

        <!-- Chart of Accounts -->
        <a href="{{ route('modules.processing.chart-of-accounts') }}" class="block no-underline bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
            <div class="flex items-center mb-4">
                <i class="fas fa-sitemap text-2xl text-slate-600 mr-3"></i>
                <h3 class="text-lg font-semibold text-gray-800">Chart of Accounts</h3>
            </div>
            <p class="text-gray-600 text-sm mb-4">Manage accounting chart of accounts.</p>
            <div class="w-full bg-slate-600 text-white py-2 px-4 rounded-lg text-sm text-center">
                <i class="fas fa-list mr-2"></i>View Chart
            </div>
        </a>
    </div>

    <div class="mt-8 text-center">
        <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
            <i class="fas fa-home mr-2"></i>Back to Dashboard
        </a>
    </div>
</div>
@endsection

