@extends('layouts.master')

@section('title', 'Task Management - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .section-title {
        color: #374151;
        font-size: 1.5rem;
        font-weight: 600;
        margin: 30px 0 20px 0;
        padding-bottom: 10px;
        border-bottom: 2px solid #e2e8f0;
    }

    #searchInput {
        width: 100%;
        padding: 12px 16px;
        font-size: 1rem;
        border: 2px solid #3b82f6;
        border-radius: 8px;
        margin-bottom: 25px;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }

    #searchInput:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .options-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .option-item {
        background: white;
        padding: 25px;
        border-radius: 10px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        text-decoration: none;
        color: #374151;
        transition: all 0.3s ease;
        border: 2px solid transparent;
        position: relative;
        overflow: hidden;
    }

    .option-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.1);
        border-color: #3b82f6;
    }

    .option-item h3 {
        color: #1e40af;
        margin-bottom: 10px;
        font-size: 1.3rem;
        font-weight: 600;
    }

    .option-item p {
        color: #6b7280;
        font-size: 0.95rem;
        line-height: 1.5;
    }

    .option-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
    }

    .option-icon svg {
        width: 24px;
        height: 24px;
        fill: white;
    }

    .diary-section {
        background: linear-gradient(135deg, #eff6ff, #dbeafe);
        border-radius: 10px;
        padding: 25px;
        margin-bottom: 20px;
        border: 1px solid #e2e8f0;
    }

    .assignment-section {
        background: linear-gradient(135deg, #f0f9ff, #bae6fd);
        border-radius: 10px;
        padding: 25px;
        border: 1px solid #e2e8f0;
    }

    .section-description {
        color: #4b5563;
        font-size: 1rem;
        margin-bottom: 20px;
        text-align: center;
        font-style: italic;
    }
</style>

<div class="container">
    <h1>Task Management</h1>

    <input
        type="search"
        id="searchInput"
        placeholder="Search task management options..."
        aria-label="Search task options"
        autocomplete="off"
    />

    <div class="diary-section">
        <h2 class="section-title">📅 Diary Management</h2>
        <p class="section-description">Manage your daily tasks, appointments, and schedule entries</p>

        <div class="options-grid">
            <a href="{{ route('modules.processing.diary.add') }}" class="option-item">
                <div class="option-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                    </svg>
                </div>
                <h3>Add Diary Entry</h3>
                <p>Create a new diary entry for appointments, tasks, or notes</p>
            </a>

            <a href="{{ route('modules.processing.diary.list') }}" class="option-item">
                <div class="option-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"/>
                    </svg>
                </div>
                <h3>Manage Diary Entries</h3>
                <p>View, edit, and organize all your diary entries</p>
            </a>

            <a href="{{ route('modules.processing.diary.calendar') }}" class="option-item">
                <div class="option-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z"/>
                    </svg>
                </div>
                <h3>Calendar View</h3>
                <p>View diary entries in a calendar format</p>
            </a>
        </div>
    </div>

    <div class="assignment-section">
        <h2 class="section-title">👥 Assignment & Collaboration</h2>
        <p class="section-description">Manage team assignments, collaboration tasks, and project workflows</p>

        <div class="options-grid">
            <a href="{{ route('modules.processing.assignment.add') }}" class="option-item">
                <div class="option-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                    </svg>
                </div>
                <h3>Create New Assignment</h3>
                <p>Assign tasks to team members and set deadlines</p>
            </a>

            <a href="{{ route('modules.processing.assignment.list') }}" class="option-item">
                <div class="option-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-1 9H9V9h10v2zm-4 4H9v-2h6v2z"/>
                    </svg>
                </div>
                <h3>Manage Assignments</h3>
                <p>Track progress and manage all assignments</p>
            </a>

            <a href="{{ route('modules.processing.assignment.reports') }}" class="option-item">
                <div class="option-icon">
                    <svg viewBox="0 0 24 24">
                        <path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z"/>
                    </svg>
                </div>
                <h3>Assignment Reports</h3>
                <p>Generate reports on assignment progress and completion</p>
            </a>
        </div>
    </div>
</div>

<script>
    // Search/filter functionality
    const searchInput = document.getElementById('searchInput');
    const allOptions = document.querySelectorAll('.option-item');

    searchInput.addEventListener('input', () => {
        const query = searchInput.value.toLowerCase().trim();
        allOptions.forEach(option => {
            const text = option.textContent.toLowerCase();
            const parentSection = option.closest('.diary-section, .assignment-section');
            option.style.display = text.includes(query) ? '' : 'none';

            // Show/hide sections based on visible options
            const visibleOptions = parentSection.querySelectorAll('.option-item[style*="display: none"]').length !==
                                 parentSection.querySelectorAll('.option-item').length;
            parentSection.style.display = visibleOptions ? '' : 'none';
        });

        // Show all sections if no query
        if (!query) {
            document.querySelectorAll('.diary-section, .assignment-section').forEach(section => {
                section.style.display = '';
                section.querySelectorAll('.option-item').forEach(option => {
                    option.style.display = '';
                });
            });
        }
    });

    // Add click animation to options
    allOptions.forEach(item => {
        item.addEventListener('click', function (e) {
            // Create ripple effect
            const ripple = document.createElement('span');
            ripple.classList.add('ripple');
            this.appendChild(ripple);

            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            ripple.style.width = ripple.style.height = size + 'px';

            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';

            ripple.addEventListener('animationend', () => {
                ripple.remove();
            });
        });
    });
</script>
@endsection

